// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SessionFile_HeaderFile
#define _IFSelect_SessionFile_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_IFSelect_WorkSession_HeaderFile
#include <Handle_IFSelect_WorkSession.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_Dico_DictionaryOfInteger_HeaderFile
#include <Handle_Dico_DictionaryOfInteger.hxx>
#endif
#ifndef _TColStd_SequenceOfAsciiString_HeaderFile
#include <TColStd_SequenceOfAsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Character_HeaderFile
#include <Standard_Character.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class IFSelect_WorkSession;
class TColStd_HArray1OfInteger;
class Dico_DictionaryOfInteger;
class TCollection_AsciiString;
class Standard_Transient;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A SessionFile is intended to manage access between a <br>
//!           WorkSession and an Ascii Form, to be considered as a Dump. <br>
//!           It allows to write the File from the WorkSession, and later <br>
//!           read the File to the WorkSession, by keeping required <br>
//!           descriptions (such as dependances). <br>
//! <br>
//!           The produced File is under an Ascii Form, then it may be <br>
//!           easily consulted. <br>
//!           It is possible to cumulate reading of several Files. But in <br>
//!           case of Names conflict, the newer Names are forgottens. <br>
//! <br>
//!           The Dump supports the description of XSTEP functionnalities <br>
//!           (Sharing an Interface File, with Selections, Dispatches, <br>
//!           Modifiers ...) but does not refer to the Interface File <br>
//!           which is currently loaded. <br>
//! <br>
//!           SessionFile works with a library of SessionDumper type objects <br>
//! <br>
//!           The File is Produced as follows : <br>
//!           SessionFile produces all general Informations (such as Int and <br>
//!           Text Parameters, Types and Inputs of Selections, Dispatches, <br>
//!           Modifiers ...) and calls the SessionDumpers to produce all <br>
//!           the particular Data : creation arguments, parameters to be set <br>
//!           It is Read in the same terms : <br>
//!           SessionFile reads and interprets all general Informations, <br>
//!           and calls the SessionDumpers to recognize Types and for a <br>
//!           recognized Type create the corresponding Object with its <br>
//!           particular parameters as they were written. <br>
//!           The best way to work is to have one SessionDumper for each <br>
//!           consistent set of classes (e.g. a package). <br>
class IFSelect_SessionFile  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a SessionFile, ready to read Files in order to load <br>
//!           them into a given WorkSession. <br>
//!           The following Read Operations must then be called. <br>
//!           It is also possible to perform a Write, which produces a <br>
//!           complete File of all the content of the WorkSession. <br>
Standard_EXPORT IFSelect_SessionFile(const Handle(IFSelect_WorkSession)& WS);

//! Creates a SessionFile which Writes the content of a WorkSession <br>
//!           to a File (directly calls Write) <br>
//!           Then, IsDone aknowledges on the result of the Operation. <br>
//!           But such a SessionFile may not Read a File to a WorkSession. <br>
Standard_EXPORT IFSelect_SessionFile(const Handle(IFSelect_WorkSession)& WS,const Standard_CString filename);

//! Clears the lines recorded whatever for writing or for reading <br>
Standard_EXPORT   void ClearLines() ;

//! Returns the count of recorded lines <br>
Standard_EXPORT   Standard_Integer NbLines() const;

//! Returns a line given its rank in the list of recorded lines <br>
Standard_EXPORT  const TCollection_AsciiString& Line(const Standard_Integer num) const;

//! Adds a line to the list of recorded lines <br>
Standard_EXPORT   void AddLine(const Standard_CString line) ;

//! Removes the last line. Can be called recursively. <br>
//!           Does nothing if the list is empty <br>
Standard_EXPORT   void RemoveLastLine() ;

//! Writes the recorded lines to a file named <name> then clears <br>
//!           the list of lines. <br>
//!           Returns False (with no clearing) if the file could not be <br>
//!           created <br>
Standard_EXPORT   Standard_Boolean WriteFile(const Standard_CString name) ;

//! Reads the recorded lines from a file named <name>, after <br>
//!           having cleared the list (stops if RecognizeFile fails) <br>
//!           Returns False (with no clearing) if the file could not be read <br>
Standard_EXPORT   Standard_Boolean ReadFile(const Standard_CString name) ;

//! Recognizes the header line. returns True if OK, False else <br>
Standard_EXPORT   Standard_Boolean RecognizeFile(const Standard_CString headerline) ;

//! Performs a Write Operation from a WorkSession to a File <br>
//!           i.e. calls WriteSession then WriteEnd, and WriteFile <br>
//!           Returned Value is : 0 for OK, -1 File could not be created, <br>
//!            >0 Error during Write (see WriteSession) <br>
//!           IsDone can be called too (will return True for OK) <br>
Standard_EXPORT   Standard_Integer Write(const Standard_CString filename) ;

//! Performs a Read Operation from a file to a WorkSession <br>
//!           i.e. calls ReadFile, then ReadSession and ReadEnd <br>
//!           Returned Value is : 0 for OK, -1 File could not be opened, <br>
//!            >0 Error during Read  (see WriteSession) <br>
//!           IsDone can be called too (will return True for OK) <br>
Standard_EXPORT   Standard_Integer Read(const Standard_CString filename) ;

//! Prepares the Write operation from a WorkSession (IFSelect) to <br>
//!           a File, i.e. fills the list of lines (the file itself remains <br>
//!           to be written; or NbLines/Line may be called) <br>
//!           Important Remark : this excludes the reading of the last line, <br>
//!           which is performed by WriteEnd <br>
//!           Returns 0 if OK, status > 0 in case of error <br>
Standard_EXPORT   Standard_Integer WriteSession() ;

//! Writes the trailing line. It is separate from WriteSession, <br>
//!           in order to allow to redefine WriteSession without touching <br>
//!           WriteEnd (WriteSession defines the body of the file) <br>
//!           WriteEnd fills the list of lines. Returns a status of error, <br>
//!           0 if OK, >0 else <br>
Standard_EXPORT   Standard_Integer WriteEnd() ;

//! Writes a line to the File. If <follow> is given, it is added <br>
//!           at the following of the line. '\n' must be added for the end. <br>
Standard_EXPORT   void WriteLine(const Standard_CString line,const Standard_Character follow = 0) ;

//! Writes the Parameters own to each type of Item. Uses the <br>
//!           Library of SessionDumpers <br>
//!           Returns True if Done, False if <item> could not be treated <br>
//!           (hence it remains written with no Own Parameter) <br>
Standard_EXPORT   Standard_Boolean WriteOwn(const Handle(Standard_Transient)& item) ;

//! Performs a Read Operation from a File to a WorkSession, i.e. <br>
//!           reads the list of line (which must have already been loaded, <br>
//!           by ReadFile or by calls to AddLine) <br>
//!           Important Remark : this excludes the reading of the last line, <br>
//!           which is performed by ReadEnd <br>
//!           Returns 0 for OK, >0 status for Read Error (not a suitable <br>
//!           File, or WorkSession given as Immutable at Creation Time) <br>
//!           IsDone can be called too (will return True for OK) <br>
Standard_EXPORT   Standard_Integer ReadSession() ;

//! Reads the end of a file (its last line). Returns 0 if OK, <br>
//!           status >0 in case of error (not a suitable end line). <br>
Standard_EXPORT   Standard_Integer ReadEnd() ;

//! Reads a Line and splits it into a set of alphanumeric items, <br>
//!           which can then be queried by NbParams/ParamValue ... <br>
Standard_EXPORT   Standard_Boolean ReadLine() ;

//! Internal routine which processes a line into words <br>
//!           and prepares its exploration <br>
Standard_EXPORT   void SplitLine(const Standard_CString line) ;

//! Tries to Read an Item, by calling the Library of Dumpers <br>
//!           Sets the list of parameters of the line to be read from the <br>
//!           first own one <br>
Standard_EXPORT   Standard_Boolean ReadOwn(Handle(Standard_Transient)& item) ;

//! Adds an Item to the WorkSession, taken as Name the first <br>
//!           item of the read Line. If this Name is not a Name but a Number <br>
//!           or if this Name is already recorded in the WorkSession, it <br>
//!           adds the Item but with no Name. Then the Name is recorded <br>
//!           in order to be used by the method ItemValue <br>
//!           <active> commands to make <item> active or not in the session <br>
Standard_EXPORT   void AddItem(const Handle(Standard_Transient)& item,const Standard_Boolean active = Standard_True) ;

//! Returns True if the last Read or Write operation has been <br>
//!           corectly performed. ELse returns False. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns the WorkSession on which a SessionFile works. <br>
//!           Remark that it is returned as Immutable. <br>
Standard_EXPORT   Handle_IFSelect_WorkSession WorkSession() const;

//! At beginning of writing an Item, writes its basics : <br>
//!           - either its name in the session if it has one <br>
//!           - or its relative number of item in the file, else <br>
//!             (preceeded by a '_') <br>
//!           - then, its Dynamic Type (in the sense of cdl : pk_class) <br>
//!           This basic description can be followed by the parameters <br>
//!           which are used in the definition of the item. <br>
Standard_EXPORT   void NewItem(const Standard_Integer ident,const Handle(Standard_Transient)& par) ;

//! Sets Parameters to be sent as Own if <mode> is True (their <br>
//!           Name or Number or Void Mark or Text Value is preceeded by a <br>
//!           Column sign ':') else they are sent normally <br>
//!           Hence, the Own Parameter are clearly identified in the File <br>
Standard_EXPORT   void SetOwn(const Standard_Boolean mode) ;

//! During a Write action, commands to send a Void Parameter <br>
//!           i.e. a Parameter which is present but undefined <br>
//!           Its form will be the dollar sign : $ <br>
Standard_EXPORT   void SendVoid() ;

//! During a Write action, commands to send the identification of <br>
//!           a Parameter : if it is Null (undefined) it is send as Void ($) <br>
//!           if it is Named in the WorkSession, its Name is sent preceeded <br>
//!           by ':', else a relative Ident Number is sent preceeded by '#' <br>
//!           (relative to the present Write, i.e. starting at one, without <br>
//!           skip, and counted part from Named Items) <br>
Standard_EXPORT   void SendItem(const Handle(Standard_Transient)& par) ;

//! During a Write action, commands to send a Text without <br>
//!           interpretation. It will be sent as well <br>
Standard_EXPORT   void SendText(const Standard_CString text) ;

//! Sets the rank of Last General Parameter to a new value. It is <br>
//!           followed by the Fist Own Parameter of the item. <br>
//!           Used by SessionFile after reading general parameters. <br>
Standard_EXPORT   void SetLastGeneral(const Standard_Integer lastgen) ;

//! During a Read operation, SessionFile processes sequencially <br>
//!           the Items to read. For each one, it gives access to the list <br>
//!           of its Parameters : they were defined by calls to <br>
//!           SendVoid/SendParam/SendText during Writing the File. <br>
//!           NbParams returns the count of Parameters for the line <br>
//!           currently read. <br>
Standard_EXPORT   Standard_Integer NbParams() const;

//! Returns True if a Parameter, given its rank in the Own List <br>
//!           (see NbOwnParams), is Void. Returns also True if <num> is <br>
//!           out of range (undefined parameters) <br>
Standard_EXPORT   Standard_Boolean IsVoid(const Standard_Integer num) const;

//! Returns True if a Parameter, in the Own List (see NbOwnParams) <br>
//!           is a Text (between "..."). Else it is an Item (Parameter, <br>
//!           Selection, Dispatch ...), which can be Void. <br>
Standard_EXPORT   Standard_Boolean IsText(const Standard_Integer num) const;

//! Returns a Parameter (alphanumeric item of a line) as it <br>
//!           has been read <br>
Standard_EXPORT  const TCollection_AsciiString& ParamValue(const Standard_Integer num) const;

//! Returns the content of a Text Parameter (without the quotes). <br>
//!           Returns an empty string if the Parameter is not a Text. <br>
Standard_EXPORT   TCollection_AsciiString TextValue(const Standard_Integer num) const;

//! Returns a Parameter as an Item. Returns a Null Handle if the <br>
//!           Parameter is a Text, or if it is defined as Void <br>
Standard_EXPORT   Handle_Standard_Transient ItemValue(const Standard_Integer num) const;

//! Specific Destructor (closes the File if not yet done) <br>
Standard_EXPORT   void Destroy() ;
~IFSelect_SessionFile()
{
  Destroy();
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_IFSelect_WorkSession thesess;
Handle_TColStd_HArray1OfInteger thenums;
Handle_Dico_DictionaryOfInteger thenames;
Standard_Integer thenl;
TColStd_SequenceOfAsciiString theline;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean themode;
TColStd_SequenceOfAsciiString thelist;
TCollection_AsciiString thebuff;
Standard_Integer thelastgen;
Standard_Boolean thedone;
Standard_Boolean theownflag;
Standard_Integer thenewnum;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
