// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRAlgo_EdgeStatus_HeaderFile
#define _HLRAlgo_EdgeStatus_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Intrv_Intervals_HeaderFile
#include <Intrv_Intervals.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class describes the Hidden  Line status of an <br>
//!          Edge. It contains : <br>
//! <br>
//!            The Bounds of the Edge and their tolerances <br>
//! <br>
//!            Two flags indicating if the edge is full visible <br>
//!            or full hidden. <br>
class HLRAlgo_EdgeStatus  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT HLRAlgo_EdgeStatus();

//! Creates a  new  EdgeStatus.  Default visible.  The <br>
//!          Edge is   bounded by the  interval  <Start>, <End> <br>
//!          with the tolerances <TolStart>, <TolEnd>. <br>
Standard_EXPORT HLRAlgo_EdgeStatus(const Standard_Real Start,const Standard_ShortReal TolStart,const Standard_Real End,const Standard_ShortReal TolEnd);

//! Initialize  an  EdgeStatus.  Default visible.  The <br>
//!          Edge is   bounded by the  interval  <Start>, <End> <br>
//!          with the tolerances <TolStart>, <TolEnd>. <br>
Standard_EXPORT   void Initialize(const Standard_Real Start,const Standard_ShortReal TolStart,const Standard_Real End,const Standard_ShortReal TolEnd) ;

  void Bounds(Standard_Real& Start,Standard_ShortReal& TolStart,Standard_Real& End,Standard_ShortReal& TolEnd) const;


Standard_EXPORT   Standard_Integer NbVisiblePart() const;


Standard_EXPORT   void VisiblePart(const Standard_Integer Index,Standard_Real& Start,Standard_ShortReal& TolStart,Standard_Real& End,Standard_ShortReal& TolEnd) const;

//! Hides  the  interval  <Start>,    <End>   with the <br>
//!          tolerances <TolStart>,  <TolEnd>. This interval is <br>
//!          subtracted from the visible  parts.  If the hidden <br>
//!          part is on ( or under ) the face the flag <OnFace> <br>
//!          is True ( or False ).  If the hidden  part is on ( <br>
//!          or  inside  ) the boundary  of  the  face the flag <br>
//!          <OnBoundary> is True ( or False ). <br>
Standard_EXPORT   void Hide(const Standard_Real Start,const Standard_ShortReal TolStart,const Standard_Real End,const Standard_ShortReal TolEnd,const Standard_Boolean OnFace,const Standard_Boolean OnBoundary) ;
//! Hide the whole Edge. <br>
  void HideAll() ;
//! Show the whole Edge. <br>
  void ShowAll() ;

  Standard_Boolean AllHidden() const;

  void AllHidden(const Standard_Boolean B) ;

  Standard_Boolean AllVisible() const;

  void AllVisible(const Standard_Boolean B) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myStart;
Standard_Real myEnd;
Standard_ShortReal myTolStart;
Standard_ShortReal myTolEnd;
Standard_Boolean myFlags;
Intrv_Intervals myVisibles;


};


#include <HLRAlgo_EdgeStatus.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
