#!/bin/bash

# utility shell script to create etc/openvms.zip file.

# Completely inflexible and tailored to the author's liking. :-P

# Usage: from bash shell:
#
#  cd to parent of omnivms;
#  ./omnivms/bin/scripts/make_etc_openvms.zip.sh
#
# Note that omnivms and omnivmstmp are hard-coded names for now.

# Note that I have not tested this with GNV.  Maybe someday...

if [ -a omnivmstmp ]; then 
  echo 'cannot run '$0': perform a rm -r omnivmstmp first!';
  exit 2;
fi

if [ -d omnivms ]; then

  # move into the omnivms directory.

  cd omnivms;
  pwd;

  # The bash equivalent of the DCL purge [...] command on [X]emacs
  # numbered (or unnumbered) backups.

  find * -name '*~' -exec rm -v '{}' ';';

  # Need to add $(RM) corba_interfaces.opt to a clean :: rule somewhere...

  find * -name corba_interfaces.opt -exec rm -v '{}' ';';

  # Move all regular files in the omni/mk directory that don't contain the
  # string '.mk' to the ../omnivmstmp directory

  find mk -not -name '*.mk*' -and -type f\
    -exec install -Dv '{}' ../omnivmstmp/'{}' ';'\
    -exec rm -v '{}' ';';

#  for file in $(find mk -not -name '*.mk*' -and -type f); do 
#    install -Dv $file ../omnivmstmp/$file;
#  done
#  rm -v $(find mk -not -name '*.mk*' -and -type f)

  # move all remaining *.mms, *.dcl, *.com, etc. files

  find * \( -iname '*.mms' -o -iname '*.com' -o -iname '*.dcl' -o\
	    -iname '*.opt' -o -iname 'tcpSocketVax*' -o\
	    -iname 'corba*Float.cc' \)\
    -exec install -Dv '{}' ../omnivmstmp/'{}' ';'\
    -exec rm -v '{}' ';';

  find bin/scripts/make_etc_openvms.zip.sh\
    -exec install -Dv '{}' ../omnivmstmp/'{}' ';'\
    -exec rm -v '{}' ';';

  find src/tool/openvms*\
    -exec install -Dv '{}' ../omnivmstmp/'{}' ';'\
    -exec rm -v '{}' ';';

  find src/services -name '*.py'\
    -exec install -Dv '{}' ../omnivmstmp/'{}' ';'\
    -exec rm -v '{}' ';';

  cd ../omnivmstmp;
  mkdir etc;
  zip -mrv etc/openvms.zip * -x etc/ etc/openvms.zip;
  cd ..;
  mv omnivmstmp/etc/openvms.zip omnivms/etc/openvms.zip;
  rmdir omnivmstmp/etc;
  rmdir -v omnivmstmp;

else

  echo 'cannot run '$0': omnivms does not exist or is not a directory!';
  exit 2;

fi
