#!/usr/bin/python
# -*- python -*-
#

import re,os,string,sys

# having to reinvent the wheel to try and backport to python 1.5.2:
def isupper(str):
    for x in str:
        if x>='a' and x<='z':
            return 0
    return 1

class Symbol:

    class Table:

        def __init__(self):
            self.__table={}

        def add(self, name, symbol):
            self.__table[name]=symbol

        def lookup(self, name):
            return self.__table[name]

    useAlias=0
    table=Table()
    commandEcho=0

    def __init__(self, mangledName):
        self.__mangledName=mangledName
        self.__demangledName=None
        self.__hidden=0
        self.__type="PROCEDURE"
        Symbol.table.add(mangledName, self)

    def str(self):
        if self.__demangledName:
            if self.__hidden:
                return '%s|@%s' % (self.__mangledName.ljust(31),
                                   self.__demangledName)
            else:
                return '%s| %s' % (self.__mangledName.ljust(31),
                                   self.__demangledName)
        else:
            return self.__mangledName

    def demangle(self, demangledName):
        self.__demangledName=demangledName
        # hide anything that references the unnamed namespace.
        if string.find(self.__demangledName,'<unnamed>') != -1:
            self.hide()

    def hide(self):
        self.__hidden=1

    def decl(self):
        return self.__demangledName

    def vector(self):
        if self.__hidden:
            entry=None
        elif isupper(self.__mangledName) or not Symbol.useAlias:
            entry="SYMBOL_VECTOR=(%s=%s)" % (self.__mangledName, self.__type)
        else:
            entry="SYMBOL_VECTOR=(%s=%s,%s/%s=%s)" % (
                self.__mangledName,
                self.__type,
                string.upper(self.__mangledName),
                self.__mangledName,
                self.__type)
        return entry

    def reclassify(self):
        self.__type="DATA"
        if self.commandEcho:
            print '''%s reclassified as %s''' % (self.__mangledName,
                                                 self.__type)

class Module:

    def __init__(self, name):
        self.__name=name
        self.__symbols=[]

    def append(self, entry):
        self.__symbols.append(entry)

    def prn(self):
        print 80*'-'
        print self.__name
        print 80*'-'
        print
        for entry in self.__symbols:
            print entry.str()
        print 80*'-'
        print

    def entry(self, inx):
        return self.__symbols[inx]

    def name(self):
        return self.__name

    def symbols(self):
        return self.__symbols

    def hideInitializers(self):

        '''\
Remove the initialization entry points that CXX creates.

For some really odd reason, the CXX compiler sometimes creates a
function called __init_MODULE_CC_... and a pointer to said function
called _p_init_MODULE_CC_.... where MODULE_CC is taken from the name
of the file and "..." is a random looking sequence of characters.

This function will never be called from outside the shareable
image. Therefore, hide these entry points.
'''

        moduleId=string.replace(string.replace(self.__name,'-','_'),'^.','_')
        init=re.compile('''void __init_%s_[a-zA-Z0-9_]+\(\)''' % moduleId)
        pinit=re.compile('''void \(\*const _p__init_%s_[a-zA-Z0-9_]+\)\(\)'''
                        % moduleId)
        for entry in self.__symbols:

            # Note that match is wrongheaded perlishness that works in
            # this case since we *are* at the start of the string.

            if init.match(entry.decl()):
                entry.hide()
            elif pinit.match(entry.decl()):
                entry.hide()

    def symbolVector(self, out):
        out.write("""!\n! %s\n!\n""" % self.__name)
        for symbol in self.__symbols:
            symbolVector=symbol.vector()
            if symbolVector:
                out.write(symbolVector+'\n')

class Builder:
    '''Build a shareable image from C++ compiled object files.'''
    def __init__(self, builddir, libname, libVersion, repositoryDirs=None):
        self.builddir=builddir
        self.libname=libname
        self.libnameonly=os.path.splitext(libname)[0]
        self.lib=builddir+libname
        if repositoryDirs:
            self.repositoryDir=string.join(repositoryDirs,',')
        else:
            self.repositoryDir='[.cxx_repository]'
        versiontuple=string.split(libVersion,'.')

        # Do something sensible with version number.
        #
        # E.g.,
        # 4.0.4 => 4,4
        # 4.1.1 => 4,1001
        # 3.1   => 1,3001
        # 2     => 1,2
        # ""    => 1,0

        if len(versiontuple)>=3:
            imageMajor=versiontuple[0]
            imageMinor=str(int(versiontuple[1])*1000+int(versiontuple[2]))
        else:
            imageMajor="1"
            if len(versiontuple)==2:
                imageMinor=str(int(versiontuple[0])*1000+int(versiontuple[1]))
            elif len(versiontuple)==1:
                imageMinor=str(int(versiontuple[0]))
            else:
                imageMinor="0"
            
        self.imageversion='''%s,%s''' % (imageMajor,imageMinor)
        self.optionsFilename=self.builddir+self.libnameonly+".opt"
        if sys.version[0]=='1':
            v=0
        else:
            v=os.getenv("compile_verify")
            if v!=None:
                v=bool(int(v))
        self.__compile_verify=v
        Symbol.commandEcho=self.__compile_verify

##        if self.__compile_verify:
##            # I think this is probably too much even if compile_verify
##            # is set...
##            print "cxxshareableimage.Builder symbol table:"
##            names=self.__dict__.keys()
##            names.sort()
##            for name in self.__dict__.keys():
##                print "%s==%s" % (name,str(self.__dict__[name]))

    def commandEcho(self):
        return self.__compile_verify

    def makeSymbolTable(self):
        if self.commandEcho():
            print '''Extracting entry point names in %s...''' % self.lib
        namesoutput=os.popen('''lib/list/names %s''' % self.lib)
        inHeader=1
        lines=namesoutput.readlines()
        if self.commandEcho():
            print '''Parsing names in %s...''' % self.lib
        header=[]
        self.modules=[]
        self.namesfile=self.lib+'.dat'
        out=open(self.namesfile,'w')

        module=None
        for line in lines:
            if len(line)==1:
                inHeader=0
            if inHeader:
                header.append(line)
            else:
                tuple=string.split(line)
                if len(tuple):
                    if len(tuple)==2 and tuple[0]=='Module':
                        if module:
                            self.modules.append(module)
                        module=Module(tuple[1])
                    else:
                        out.write(line)
                        symbol=Symbol(line[:-1])
                        module.append(symbol)

        if module:
            self.modules.append(module)

        out.close()

        if self.commandEcho():
            print '''Demangling names for %s...''' % self.lib

        cxxdemfilter=os.popen('''pipe cxxdemangler/repository=(%s) < %s'''
                              %(self.repositoryDir, self.namesfile))
        demangledNames=cxxdemfilter.readlines()

        inx=0
        for module in self.modules:
            for symbol in module.symbols():
                symbol.demangle(demangledNames[inx][:-1])
                inx=inx+1
            module.hideInitializers()
        os.remove(self.namesfile)

    def createOptionsFile(self, otherLibs):
        optionsFile=open(self.optionsFilename,'w')
        optionsFile.write("""! Options file for %s
GSMATCH=LEQUAL,%s
CASE_SENSITIVE=YES
""" % (self.libname,self.imageversion))
        for module in self.modules:
            module.symbolVector(optionsFile)

        for lib in otherLibs:
            optionsFile.write("""%s\n""" % lib)
        optionsFile.close()

    def linkShareableImage(self, whichPass, destination):
        if self.commandEcho():
            print """Linking %s %s pass...""" % (self.libname, whichPass)

        cmd="""cxxlink/repository=(%s)/shareable=%s%s %s/opt,%s/lib""" % (
            self.repositoryDir,
            destination,
            self.__linkOptions,
            self.optionsFilename,
            self.libname)
        if self.commandEcho():
            print cmd
        cxxlinkoutput=os.popen(cmd)
        return cxxlinkoutput.readlines()

    def reclassify(self, cxxlinkreport):
        if self.commandEcho():
            print "Reclassifying..."

        # %LINK-W-SYMVABNORMAL, Symbol ID_UCS_2__q1_4omni11omniCodeSet
        errorMsgFormat=re.compile(
            """%LINK-W-SYMVABNORMAL, Symbol ([A-Za-z_][$A-Za-z_0-9]*)""")
        for line in cxxlinkreport:
            match=errorMsgFormat.match(line)
            if match:
                Symbol.table.lookup(match.group(1)).reclassify()
##            else:
##                print "%s doesn't match!" % line[:-1]

    def target(self, target):
        self.__target=target
    def linkOptions(self, linkOptions):
        self.__linkOptions=linkOptions

    def build(self, otherLibs):
        self.makeSymbolTable()
        self.createOptionsFile(otherLibs)
        if not hasattr(self,"_Builder__linkOptions"):
            self.__linkOptions="/map/full"
        cxxlinkreport=self.linkShareableImage("initial", "NL:")
        self.reclassify(cxxlinkreport)
        Symbol.useAlias=1
        # Note: it is necessary to recreate the options file after
        # reclassifying...
        self.createOptionsFile(otherLibs)
        if hasattr(self,"_Builder__target"):
            shareableLib=self.__target
        else:
            shareableLib=self.builddir+self.libnameonly+"_rt.exe"

        cxxlinkreport=self.linkShareableImage("final", shareableLib)
        status=1        # VMS success
        errorMsgFormat=re.compile(
            """%[A-Za-z]+-[EWS]-[A-Za-z]+""")
        for line in cxxlinkreport:
            if errorMsgFormat.match(line):
                status=2
            # This is likely an error message so print this regardless
            # of self.commandEcho().
            print line[:-1]
        if status & 1 != 1:
            sys.exit(status)

class Usage(Exception):
    pass

class VmsOsPath:
    """Because os.path isn't quite smart enough on VMS."""
    class __Split:
        """To get the syntax right, I have to make this a function object."""
        def __call__(self, arg):
            i=string.find(arg,'::')
            if i!=-1:
                node,rest=arg[:i+2],arg[i+2:]
            else:
                node,rest='',arg
            pos=string.find(rest,':')
            device,rest=rest[:pos+1],arg[pos+1:]
            pos=string.rfind(rest,']')
            dir,name=rest[:pos+1],rest[pos+1:]
            return node+device+dir,name
    split=__Split()

if __name__=="__main__":

    # Caveat: The try/catch makes it harder to debug this but is
    # needed so we can fix the return code for VMS when there's an error.

    try:
        if len(sys.argv) != 7:
            print\
 '''Usage: python %s $@ $< libs linkopt version cxxrepositories''' \
 % sys.argv[0]
            print '''This is normally invoked from MMS'''
            raise Usage()
        target=sys.argv[1]
        source=sys.argv[2]
        builddir,libname=VmsOsPath.split(source)
        otherLibs=string.split(sys.argv[3])
        linkOptions=sys.argv[4]
        libversion=sys.argv[5]
        cxxrepositories=string.split(sys.argv[6])
        builder=Builder(builddir, libname, libversion, cxxrepositories)
        if builder.commandEcho():
            print """Python running:""",sys.argv
        builder.target(target)
        builder.linkOptions(linkOptions)
        builder.build(otherLibs)
    except Exception,e:
        print str(e)
        # Exit with something that will make MMS stop!
        sys.exit(2)
