# Configuring octocatalog-diff to use PuppetDB

octocatalog-diff can interact with PuppetDB in the following ways:

- Retrieving the most recent set of facts for a node
- Query for exported resources during a Puppet run with storeconfigs enabled
- Retrieving a catalog for a node

For this to work, you will need to configure or provide information about your PuppetDB server to octocatalog-diff. You can provide this information via a [configuration file](/doc/configuration.md), via environment variables, or via command line parameters.

## Required information

- **Version of PuppetDB**: octocatalog-diff supports PuppetDB's query API v4, which requires that you be running PuppetDB 2.3 or higher.

- **URL to PuppetDB**: This is the URL with the host name and port number to reach your PuppetDB instance. If you have already set up your Puppet master to communicate with PuppetDB, you can see the URL by reviewing `/etc/puppetlabs/puppet/puppetdb.conf` (on Puppet Server) or `/etc/puppet/puppetdb.conf` (on Puppet Master 3.x). The URL (or URLs) to your PuppetDB installation are visible in the `server_urls` configuration setting.

- **SSL Authentication Information**: Whether your PuppetDB instance requires clients to authenticate via SSL certificates. Unless you have made a special effort to configure your PuppetDB instance not to require client certificates, it is likely that client certificate authentication is required.

NOTE: In certain situations, you may need to define or alter the `certificate-whitelist` setting in your PuppetDB configuration to whitelist the certificate used by octocatalog-diff. Please see [Configuring PuppetDB](https://docs.puppet.com/puppetdb/latest/configure.html#certificate-whitelist) in the Puppet documentation for additional information.

## Supplying necessary information via configuration files

The following settings can be used in a [configuration file](/doc/configuration.md).

| Setting | Description |
| --- | --- |
| `settings[:puppetdb_url]` | PuppetDB URL settings. If this is a string, it will set a single PuppetDB URL. If it is an array, it will set multiple URLs, which will be tried in a random order until one responds. |
| `settings[:puppetdb_ssl_ca]` | Path to the certificate of the CA that signed PuppetDB's certificate. This file is typically found in `/etc/puppetlabs/puppetdb/ssl/ca.pem` on your PuppetDB server. This file should contain only the public certificate, so it is safe to distribute to developer workstations or CI environments. |
| `settings[:puppetdb_ssl_client_cert]` | TEXT of the certificate of the client SSL keypair. You should generate a keypair specifically for this client (or if you are running this on a machine managed by Puppet, you may be able to use the keypair for the client machine). You should **NOT** copy the certificate from your PuppetDB server itself. Note: This variable needs to be set to the TEXT of the certificate, and not the file path. This means you will likely want to use `File.read(...)` if you are configuring this to be read from a file. |
| `settings[:puppetdb_ssl_client_key]` | Path to the private key of the client SSL keypair. You should generate a keypair specifically for this client (or if you are running this on a machine managed by Puppet, you may be able to use the keypair for the client machine). You should **NOT** copy the private key from your PuppetDB server itself.  Note: This variable needs to be set to the TEXT of the key, and not the file path. This means you will likely want to use `File.read(...)` if you are configuring this to be read from a file. |
| `settings[:puppetdb_ssl_client_pem]` | Concatenation of the text of `puppetdb_ssl_client_key` and `puppetdb_ssl_client_cert` as previously described. This is a good alternative if your certificate chain is complex and it's easier just to put everything in a single place. Note: this option is second in precedence; if `settings[:puppetdb_ssl_client_cert]` and `settings[:puppetdb_ssl_client_key]` are both set, this will be ignored. |
| `settings[:puppetdb_ssl_client_password]` | Plain text string containing the password to unlock the private key. For keys generated by the Puppet Master CA, this is not required and should be left undefined. |

## Supplying necessary information via the command line

The following arguments can be used on the command line.

| Setting | Description |
| --- | --- |
| --puppetdb-url https://puppetdb.example.net:8081 | PuppetDB URL. The argument should match the `server_urls` configuration setting as described previously. Please note that only one URL is supported via the command line method, so if you have multiple `server_urls` URLs specified, you can only choose one. To use multiple URLs for failover purposes, please configure via configuration files. |
| --puppetdb-ssl-ca FILENAME | Path to the certificate of the CA that signed PuppetDB's certificate. This file is typically found in `/etc/puppetlabs/puppetdb/ssl/ca.pem` on your PuppetDB server. This file should contain only the public certificate, so it is safe to distribute to developer workstations or CI environments. |
| --puppetdb-ssl-client-cert FILENAME | Path to the certificate of the client SSL keypair. You should generate a keypair specifically for this client (or if you are running this on a machine managed by Puppet, you may be able to use the keypair for the client machine). You should **NOT** copy the certificate from your PuppetDB server itself. |
| --puppetdb-ssl-client-key FILENAME | Path to the private key of the client SSL keypair. You should generate a keypair specifically for this client (or if you are running this on a machine managed by Puppet, you may be able to use the keypair for the client machine). You should **NOT** copy the private key from your PuppetDB server itself. |
| --puppetdb-ssl-client-password PASSWORD_STRING | Plain text string containing the password to unlock the private key. For keys generated by the Puppet Master CA, this is not required. |

## Supplying necessary information via the environment

:warning: While this method of configuring octocatalog-diff for use with PuppetDB is currently supported, we recommend that configuration is done via the command line or in configuration files.

Set the environment variable `PUPPETDB_URL` to match the `server_urls` configuration setting as described previously. Please note that only one URL is supported via the environment variable method, so if you have multiple `server_urls` URLs specified, you can only choose one. To use multiple URLs for failover purposes, please configure via configuration files.

Environment variable support is not currently available for SSL client authentication settings.
