## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{f} =} vtk_polycut(@var{t},@var{x},@var{y},@var{z},@var{c},@var{p0},@var{n})
## This function cuts a polygon surface at a plane, leaving only the
## line plot of the surface in that plane.  The plane is defined by the
## point @var{p0} and the normal @var{n}.
##
## This function is a bit rough and likely to change in the future.
##
## @end deftypefn
## @seealso{vtk_trisurf}

## Author: Dragan Tubic

function vtk_polycut( t, x, y, z, c, p0, n )
  
  vtk_init
  %% In this example vtkClipPolyData is used to cut a polygonal model;
  %% of a cow in half. In addition, the open clip is closed by triangulating;
  %% the resulting complex polygons.;

  
  if ( length(x) != length(y) | length(x) != length(z) )
    error('Lengths of all three coordinates have to be the same.');
  end
  
  x = x(:);
  y = y(:);
  z = z(:);

  %% We'll create the building blocks of polydata including data attributes.
  surface = vtkPolyData("New");
  points   = vtkPoints("New");
  polys    = vtkCellArray("New");
  scalars  = vtkFloatArray("New");
  
  %% Load the point, cell, and data attributes.
  %% for (i=0; i<8; i++) points->InsertPoint(i,x[i]);
  coords = vtkFloatArray; 
  coords.SetNumberOfTuples( length(x) );
  coords.SetNumberOfComponents(3);
  pts = [x y z]';
  coords.SetArray( pts(:), 3*length(x), 0 );
  points.SetData(coords);
  
  colors = vtkUnsignedCharArray; 
  colors.SetNumberOfTuples( length(x) );
  colors.SetNumberOfComponents(3);
  c = c'*255;
  colors.SetArray( c(:), 3*length(x), 0 );
  
  %% for (i=0; i<6; i++) polys->InsertNextCell(4,pts[i]);
  [nr nc] = size(t);
  if ( nr < nc )
    t = t';
  end	
  [nr nc] = size(t);
  if ( nc != 3 )
    error('t has to be a Nx3 matrix');
  end	
  no_tris = length(t);
  t = [ones(no_tris,1)*3 t]';
  ptids = vtkIdTypeArray;
  ptids.SetArray( t(:), no_tris*4, 0 );
  polys.SetCells( no_tris, ptids );
  
  %% We now assign the pieces to the vtkPolyData.
  surface.SetPoints(points);
  surface.SetPolys(polys);
  surface.GetPointData().SetScalars(colors);
  
  
  %% We clip with an implicit function. Here we use a plane positioned near;
  %% the center of the cow model and oriented at an arbitrary angle.;
  plane = vtkPlane();
  plane.SetOrigin(p0(1),p0(2),p0(3));
  plane.SetNormal(n(1),n(2),n(3));
  
  %% Here we are cutting the cow. Cutting creates lines where the cut;
  %% function intersects the model. (Clipping removes a portion of the;
  %% model but the dimension of the data does not change.);
  %%;
  %% The reason we are cutting is to generate a closed polygon at the;
  %% boundary of the clipping process. The cutter generates line;
  %% segments, the stripper then puts them together into polylines. We;
  %% then pull a trick and define polygons using the closed line;
  %% segements that the stripper created.;
  cutEdges = vtkCutter();
  cutEdges.SetInput(surface);
  cutEdges.SetCutFunction(plane);
  cutEdges.GenerateCutScalarsOff();
  cutEdges.SetValue(0, 0.5);
  cutStrips = vtkStripper();
  cutStrips.SetInput(cutEdges.GetOutput());
  cutStrips.Update();
  cutPoly = vtkPolyData();
  cutPoly.SetPoints(cutStrips.GetOutput().GetPoints());
  cutPoly.SetPolys(cutStrips.GetOutput().GetLines());
  %%cutPoly.GetPointData().SetScalars( cutStrips.GetOutput().GetScalars() );
  
  f = vtk_figure(0);
  %% Create graphics stuff;
  ren = f.renderer;
  
  contour_mapper = vtkPolyDataMapper();
  contour_mapper.SetInput(cutEdges.GetOutput());
  contour_mapper.SetColorModeToDefault();
  %%contour_mapper.ScalarVisibilityOff();
  contour_actor = vtkActor();
  contour_actor.SetMapper(contour_mapper);
  prop = contour_actor.GetProperty();
  prop.SetInterpolationToGouraud();
  %%		prop.SetDiffuse(0);
  %%		prop.SetAmbient(1);
  ren.AddActor(contour_actor);
  
  vtk_update(f);

endfunction
