## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_scalarbar(@var{string})
## Adds a color scalar bar to the side of a vtk figure.  The input
## @var{string} will be the title of the scalar bar.  This is a work
## in progress.  It doesn't update automatically (although it can be
## called again), and only works on the last actor rendered.
## @end deftypefn
## @seealso{vtk_title,vtk_clear}

## Author: Jonathan Stickel


function vtk_scalarbar(scalarname)

  f=vtk_figure(0);

  ## clear existing scalarbar, if it exists
  nprops = f.renderer.GetProps().GetNumberOfItems();
  for i = 0:nprops-1;
    if ( f.renderer.GetProps().GetItemAsObject(i).IsA("vtkScalarBarActor") )
      f.renderer.RemoveProp( f.renderer.GetProps().GetItemAsObject(i) );
      break
    endif
  endfor 

  scalarBar = vtkScalarBarActor();
  scalarBar.SetLookupTable( f.renderer.GetActors().GetLastActor().GetMapper().GetLookupTable() );
  scalarBar.SetTitle( scalarname );
  scalarBar.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport();
  scalarBar.GetPositionCoordinate().SetValue(0.85, 0.05);
  scalarBar.SetWidth(0.15);
  scalarBar.SetHeight(0.9);
  f.renderer.AddActor2D(scalarBar);

  ## shadow unnecessary, and doesn't export to vector format correctly
  scalarBar.GetTitleTextProperty().ShadowOff()
  scalarBar.GetLabelTextProperty().ShadowOff()

  vtk_update(f);

endfunction
