/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __OCTAVE_UI__
#define __OCTAVE_UI__

// Octave includes 
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include "octave/config.h"
#include "octave/debug.h"
#include "octave/octave.h"
#include "octave/symtab.h"
#include "octave/parse.h"
#include "octave/unwind-prot.h"
#include "octave/toplev.h"
#include "octave/load-path.h"
#include "octave/error.h" 
#include "octave/quit.h"
#include "octave/variables.h"
#include "octave/sighandlers.h"
#include "octave/sysdep.h"
#include "octave/str-vec.h"
#include "octave/cmd-hist.h"
#include "octave/cmd-edit.h"
#include "octave/oct-env.h"
#include "octave/symtab.h"

// GTK includes
#if HAVE_GLRENDERER
#include "gtk-backend.h"
#endif // HAVE_GLRENDERER

#include <gdk/gdk.h>
#include <gtkmm.h>
#include "dock.h"
#include "dock-item.h"
#include <vte/vte.h>
#include "sigc++/sigc++.h"
using namespace sigc;
using namespace Gtk;

// Project includes
#include "VariablesTreeView.h"
#include "HistoryTreeView.h"
#include "mEditor.h"
#include "PathChooser.h"
#include "OctaveDEToolbar.h"

#if HAVE_WEBKIT
#include "HelpWindow.h"
#endif

// Standard library includes
#include <string>
#include <vector>
using std::vector;
using std::string;




/**
 * Main class for the Octave IDE
 */
class OctaveUI : public Gtk::Window
{

private:
  bool initializeComplete;

  bool isRunning;
  int threadEnded;

  // Base widgets
  Gtk::VBox vbox;
  Gtk::HBox hbox;

  Gtk::HPaned rootPane;
  Dock dockPane;

  //Gtk::HBox rightPane;
  //Gtk::HBox menuPane;
  MEditor* meditor;

  // Menu widgets
  Gtk::MenuBar menuBar;
  Gtk::Menu fileMenu;
  Gtk::Menu editMenu;
  Gtk::Menu debugMenu;
  Gtk::Menu windowMenu;
  Gtk::Menu helpMenu;

  // Window menu items
  std::map<string,Gtk::CheckMenuItem*> windowMenuMap;

  // Left panel widgets
  DockItem variablesDock;
  Gtk::ScrolledWindow mVariablesScrollWindow;
  VariablesTreeView mVariablesTreeView;

  DockItem historyDock;
  Gtk::ScrolledWindow mHistoryScrollWindow;
  HistoryTreeView mHistoryTreeView;

  DockItem fileChooserDock;
  Gtk::FileChooserWidget mFileChooserWidget;

  // Toolbar widgets
  OctaveDEToolbar m_toolbar;

  // Center panel widget
  DockItem octaveDock;
  Gtk::HBox mOctaveScrollWindow;
  GtkWidget* vteTerminal;
  Gtk::Widget* vtePanel;

  GdlDockPlaceholder* editorPlaceholder;

  Gtk::VScrollbar vscroll;

  // Threads for running octave and managing the data interaction
  pthread_t octave_thread;
  pthread_t octave_monitor_thread;

  // Variables for managing placement
  std::map<GdlDockObject*,GdlDockObject*> prevChildImmediateParentMap;
  std::map<GdlDockObject*,GdlDockPlacement> prevChildPlacementMap;


public:
  /**
   * Default constructor
   */
  OctaveUI();

  /**
   * Destructor
   */
  ~OctaveUI();

  static void terminal_widget_commit( GtkWidget* widget,
				      gchar*     data,
				      guint      length,
				      void*      parm);
																								
  
  void on_toggle_octave(void) 
  {
    /*
    Gtk::CheckMenuItem* tmp =  windowMenuMap["octave"];
    if( tmp->property_active().get_value() )
      octaveDock.show_all();
    else
      octaveDock.hide();
    */
  };
 
  void on_toggle_variables(void) 
  {
    if (!initializeComplete)
      return;
     Gtk::CheckMenuItem* tmp =  windowMenuMap["variables"];
    if( tmp->property_active().get_value() )
      {
	variablesDock.show_all();
	variablesDock.show();
      }
    else
      variablesDock.hide();
  };
  
  void on_toggle_history(void) 
  {
    if (!initializeComplete)
      return;

     Gtk::CheckMenuItem* tmp =  windowMenuMap["history"];
    if( tmp->property_active().get_value() )
      {
	historyDock.show_all();
	historyDock.show();
      }
    else
      historyDock.hide();
  };
  
  void on_toggle_filechooser(void) 
  {
    if (!initializeComplete)
      return;

     Gtk::CheckMenuItem* tmp =  windowMenuMap["filechooser"];
    if( tmp->property_active().get_value() )
      {
	fileChooserDock.show_all();
	fileChooserDock.show();
      }
    else
      fileChooserDock.hide();
  };


  /**
   * Function called when a file is activated in the file chooser widget.
   */
  void onFileActivated( void );
  
  /**
   * Function called when a directory is change in the file chooser widget.
   */
  void onDirButtonChanged( void );
	
  
  /**
   * Function called when a command(s) is executed from the history widget.
   *
   * @param commands A vector of strings to execute.
   */
  void onCommandExecute( vector<string> commands );

  /**
   * Function called when the VTE widget has changed size.
   *
   * @param alloc Variable containing the VTE widget size and location.
   */
  void onVteSizeChanged( Gtk::Allocation& alloc );

  void onCommandCopy( void );

  // File Menu
  void onNew(void);
  void onOpen(void);
  void onSave(void);
  void onSaveAs(void);
  void onQuit(void);

  // Edit Menu
  void onCut(void);
  void onCopy(void);
  void onPaste(void);
  void onPreferences(void);

  // Help Menu
  void onHelp(void);

  bool onCloseWindow( GdkEventAny* evt );
  bool onKeyPress( GdkEventKey* evt );

  static void* octave_monitor(void *octaveUI);

  void createMenubar(void);
  void createToolbar(void);

  void createFileChooserDockItem(void);
  void createVariablesDockItem(void);
  void createHistoryDockItem(void);

  void createOctaveVteDockItem(void);

  /**
   * Function called when a directory is change in the file chooser widget.
   */
  void onDirChanged( void );
  void onDirUpButton( void );
  void onPathChooserChanged(void);

  void onLayoutChanged(void);
};

#endif // __OCTAVE_UI__
