/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __OCTAVEDE_TOOLBAR_H__
#define __OCTAVEDE_TOOLBAR_H__

#include <gtkmm.h>
#include "PathChooser.h"

/////////////////////////////////////////////////////////////////////////////////////////
class OctaveDEToolbar : public Gtk::Toolbar
{
  friend class OctaveUI;
  friend class MEditor;
  friend class MEditorPanel;

private:
  Gtk::ToolButton m_tool_open;
  Gtk::ToolButton m_tool_new;
  Gtk::ToolButton m_tool_save;

  Gtk::SeparatorToolItem m_tool_separator1;

  Gtk::ToolButton m_tool_cut;
  Gtk::ToolButton m_tool_copy;
  Gtk::ToolButton m_tool_paste;
  Gtk::ToolButton m_tool_undo;
  Gtk::ToolButton m_tool_redo;

  Gtk::SeparatorToolItem m_tool_separator2;

  Gtk::ToolButton m_tool_help;

  Gtk::SeparatorToolItem m_tool_separator3;

  PathChooser m_path_chooser;

  /**
   * A button to move the path up.
   */
  Gtk::ToolButton m_tool_path_up;


public:
  OctaveDEToolbar(bool with_path_chooser=true) 
    : Gtk::Toolbar(),
      m_tool_new(Gtk::Stock::NEW),
      m_tool_open(Gtk::Stock::OPEN),
      m_tool_save(Gtk::Stock::SAVE),
      m_tool_cut(Gtk::Stock::CUT),
      m_tool_copy(Gtk::Stock::COPY),
      m_tool_paste(Gtk::Stock::PASTE),
      m_tool_undo(Gtk::Stock::UNDO),
      m_tool_redo(Gtk::Stock::REDO),
      m_tool_help(Gtk::Stock::HELP),
      m_tool_path_up(Gtk::Stock::GOTO_TOP)
  {
    set_toolbar_style(Gtk::TOOLBAR_ICONS);

    // Add toolbar items to toolbar
    append(m_tool_new);
    append(m_tool_open);
    append(m_tool_save);
    append(m_tool_separator1);
    append(m_tool_cut);
    append(m_tool_copy);
    append(m_tool_paste);
    append(m_tool_undo);
    append(m_tool_redo);
    append(m_tool_separator2);
    append(m_tool_help);
    append(m_tool_separator3);
    if (with_path_chooser)
    {
      append(m_path_chooser);
      append(m_tool_path_up);
    }
  }

};

class OctaveDEEditorToolbar : public OctaveDEToolbar
{
  friend class OctaveUI;
  friend class MEditor;
  friend class MEditorPanel;

 private:
  Gtk::Image m_removeall_img;
  Gtk::ToolButton m_tool_bpadd;

  Gtk::Image m_stepover_img;
  Gtk::Image m_stepinto_img;
  Gtk::Image m_stepreturn_img;
  Gtk::ToolButton m_tool_stepover;
  Gtk::ToolButton m_tool_stepinto;
  Gtk::ToolButton m_tool_stepreturn;

 public:
  OctaveDEEditorToolbar()
    : OctaveDEToolbar(false),
    m_removeall_img("icon_db_terminate_all.png"),
    m_stepover_img("icon_db_stepover.png"),
    m_stepinto_img("icon_db_stepinto.png"),
    m_stepreturn_img("icon_db_stepreturn.png"),
    m_tool_stepover(m_stepover_img),
    m_tool_stepinto(m_stepinto_img),
    m_tool_stepreturn(m_stepreturn_img),
    m_tool_bpadd(m_removeall_img)
  {
    append (m_tool_bpadd);
    append (m_tool_stepover);
    append (m_tool_stepinto);
    append (m_tool_stepreturn);
  }


};

#endif // __OCTAVEDE_TOOLBAR_H__
