/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __GTKSOURCEVIEWUTILITIES_H__
#define __GTKSOURCEVIEWUTILITIES_H__

#include <stdio.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcelanguage.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <gtksourceview/gtksourcestyleschememanager.h>

#include <gtkmm.h>

#define READ_BUFFER_SIZE   4096

GtkSourceBuffer* create_source_buffer (GtkSourceLanguageManager *manager, 
				       GtkSourceLanguage* language=NULL );

void error_dialog (GtkWindow *parent, const gchar *msg, ...);

gboolean gtk_source_buffer_load_with_encoding (GtkSourceBuffer *source_buffer,
					       const gchar     *filename,
					       const gchar     *encoding,
					       GError         **error);

void remove_all_markers (GtkSourceBuffer *buffer);

GtkSourceLanguage* get_language_for_filename (const gchar *filename);

GtkSourceLanguage* get_language_for_mime_type (const gchar *mime);

GtkSourceLanguage* get_language_for_file (const gchar *filename);

GtkSourceLanguage* get_language_by_id (const gchar *id);

GtkSourceLanguage* get_language (GtkTextBuffer *buffer, const gchar *filename);

//void error_dialog (GtkWindow *parent, const gchar *msg, ...);

gboolean gtk_source_buffer_save_file (GtkSourceBuffer *source_buffer, 
				      const gchar *filename, 
				      GError **error);

gboolean gtk_source_buffer_load_file (GtkSourceBuffer *source_buffer,
				      const gchar     *filename,
				      GError         **error);

gboolean open_file (GtkSourceBuffer *buffer, const gchar *filename);

#endif // __GTKSOURCEVIEWUTILITIES_H__
