%%NAME
%%  eimg2shtml  - encode image to secret html-file 
%%
%%SYNOPSIS
%%  checksum=eimg2shtml(imgFilename,htmlFilename,key[,title[,legend]])
%%
%%PARAMETER(S)
%%  imgFilename    string of image-filename (PNG- or JPEG-file)
%%  htmlFilename   string of html-filename
%%  key            vector of unsigned char
%%                 or string
%%  title          title of image
%%  legend         legend under password entry
%%  checksum       checksum of cipher
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010

function checksum=eimg2shtml(imgFilename,htmlFilename,key,title,legend)
  if nargin<3
    eusage('checksum=eimg2shtml(imgFilename,htmlFilename,key[,title[,legend]])');
  end
  if nargin<4
    title='Encoded Image';
  end
  if nargin<5
    legend='Please enter password!';
  end
  if nargout>0
    message=0;
  else
    message=1;
  end
  tmpHtmlFilename=[imgFilename '.html'];
  ehtmlnew(tmpHtmlFilename,[0.95 0.95 0.95]);
  ehtmladdimg(tmpHtmlFilename,imgFilename);
  checksum=etxt2shtml(tmpHtmlFilename,htmlFilename,key,title,legend);
  delete(tmpHtmlFilename);
  if message
    message=sprintf('%s is written',htmlFilename); 
    disp(message);
  end

