/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Player system variables / auxiliary routines
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss040907   Stian Skjelstad <stian@nixia.no>
 *    -minor buffer cleanups.. Let drivers allocate their own memory
 */

#define NO_PLRBASE_IMPORT
#include "config.h"
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "mchasm.h"
#include "player.h"
#include "stuff/imsrtns.h"


int plrRate;
int plrOpt;
int (*plrPlay)(void **buf, int *len);
void (*plrStop)(void);
void (*plrSetOptions)(int rate, int opt);
int (*plrGetBufPos)(void);
int (*plrGetPlayPos)(void);
void (*plrAdvanceTo)(int pos);
long (*plrGetTimer)(void);
void (*plrIdle)(void);
#ifdef PLR_DEBUG
char *(*plrDebug)(void)=0;
#endif

static unsigned char stereo;
static unsigned char bit16;
static unsigned char reversestereo;
static unsigned char signedout;
static unsigned long samprate;

static unsigned char *plrbuf;
static unsigned long buflen;


void plrGetRealMasterVolume(int *l, int *r)
{
	int len=samprate/20;
	int p;
	int pass2;
	mixAddAbsfn fn;
	unsigned long v;
	
	if (len>buflen)
		len=buflen;
	p=plrGetPlayPos()>>(stereo+bit16);
	
	pass2=len-buflen+p;

	if (stereo)
	{
		fn=bit16?(signedout?mixAddAbs16SS:mixAddAbs16S):(signedout?mixAddAbs8SS:mixAddAbs8S);

		if (pass2>0)
			v=fn(plrbuf+(p<<(1+bit16)), len-pass2)+fn(plrbuf, pass2);
		else
			v=fn(plrbuf+(p<<(1+bit16)), len);

		v=v*128/(len*16384);
		*l=(v>255)?255:v;

		if (pass2>0)
			v=fn(plrbuf+(p<<(1+bit16))+(1<<bit16), len-pass2)+fn(plrbuf+(1<<bit16), pass2);
		else
			v=fn(plrbuf+(p<<(1+bit16))+(1<<bit16), len);
		v=v*128/(len*16384);
		*r=(v>255)?255:v;
	} else {
		fn=bit16?(signedout?mixAddAbs16MS:mixAddAbs16M):(signedout?mixAddAbs8MS:mixAddAbs8M);

		if (pass2>0)
			v=fn(plrbuf+(p<<bit16), len-pass2)+fn(plrbuf, pass2);
		else
			v=fn(plrbuf+(p<<bit16), len);
		v=v*128/(len*16384);
		*r=*l=(v>255)?255:v;
	}
	
	if (reversestereo)
	{
		int t=*r;
		*r=*l;
		*l=t;
	}
}

void plrGetMasterSample(short *buf, int len, int rate, int opt)
{
	int step=imuldiv(samprate, 0x10000, rate);
	int maxlen;
	int stereoout;
	unsigned long bp;
	signed long pass2;
	mixGetMasterSamplefn fn;
	
	if (step<0x1000)
		step=0x1000;
	if (step>0x800000)
		step=0x800000;
	
	maxlen=imuldiv(buflen, 0x10000, step);
	stereoout=(opt&plrGetSampleStereo)?1:0;
	if (len>maxlen)
	{
		memset((short*)buf+(maxlen<<stereoout), 0, (len-maxlen)<<(1+stereoout));
		len=maxlen;
	}

	bp=plrGetPlayPos()>>(stereo+bit16);pass2=len-imuldiv(buflen-bp,0x10000,step);

	if (bit16)
		if (stereo)
			if (!stereoout)
				fn=signedout?mixGetMasterSampleSS16M:mixGetMasterSampleSU16M;
			else if (reversestereo)
				fn=signedout?mixGetMasterSampleSS16SR:mixGetMasterSampleSU16SR;
			else
				fn=signedout?mixGetMasterSampleSS16S:mixGetMasterSampleSU16S;
		else if (!stereoout)
			fn=signedout?mixGetMasterSampleMS16M:mixGetMasterSampleMU16M;
		else
			fn=signedout?mixGetMasterSampleMS16S:mixGetMasterSampleMU16S;
	else if (stereo)
		if (!stereoout)
			fn=signedout?mixGetMasterSampleSS8M:mixGetMasterSampleSU8M;
		else
			if (reversestereo)
				fn=signedout?mixGetMasterSampleSS8SR:mixGetMasterSampleSU8SR;
			else
				fn=signedout?mixGetMasterSampleSS8S:mixGetMasterSampleSU8S;
	else if (!stereoout)
		fn=signedout?mixGetMasterSampleMS8M:mixGetMasterSampleMU8M;
	else
		fn=signedout?mixGetMasterSampleMS8S:mixGetMasterSampleMU8S;

	if (pass2>0)
	{
		fn(buf, plrbuf+(bp<<(stereo+bit16)), len-pass2, step);
		fn(buf+((len-pass2)<<stereoout), plrbuf, pass2, step);
	} else
		fn(buf, plrbuf+(bp<<(stereo+bit16)), len, step);
}


int plrOpenPlayer(void **buf, uint32_t *len, uint32_t bufl)
{
	int dmalen;
	
	if (!plrPlay)
		return 0;

	dmalen=umuldiv(plrRate<<(!!(plrOpt&PLR_STEREO)+!!(plrOpt&PLR_16BIT)), bufl, 32500)&~15;

	plrbuf=0;
	if (!plrPlay((void **)((void *)&plrbuf), &dmalen)) /* to remove warning :-) */
		return 0;

	stereo=!!(plrOpt&PLR_STEREO);
	bit16=!!(plrOpt&PLR_16BIT);
	reversestereo=!!(plrOpt&PLR_REVERSESTEREO);
	signedout=!!(plrOpt&PLR_SIGNEDOUT);
	samprate=plrRate;

	buflen=dmalen>>(stereo+bit16);
	*buf=plrbuf;
	*len=buflen;

	return 1;
}

void plrClosePlayer(void)
{
	plrStop();
}
