#ifndef _CONSOLE
#define _CONSOLE 1

extern void (*_vga13)(void);
extern void (*_plSetTextMode)(unsigned char x);
extern void (*_plSetBarFont)(void);

extern void (*_displaystr)(unsigned short y, unsigned short x, unsigned char attr, const char *str, unsigned short len);
extern void (*_displaystrattr)(unsigned short y, unsigned short x, const unsigned short *buf, unsigned short len);
extern void (*_displaystrattrdi)(unsigned short y, unsigned short x, const char *txt, const char *attr, unsigned short len);
extern void (*_displayvoid)(unsigned short y, unsigned short x, unsigned short len);

extern int (*_plSetGraphMode)(int size);
extern int  (*_plSetGraphPage)(unsigned char x);
extern void (*_gdrawchar)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b);
extern void (*_gdrawchart)(unsigned short x, unsigned short y, unsigned char c, unsigned char f);
extern void (*_gdrawcharp)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp);
extern void (*_gdrawchar8)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, unsigned char b);
extern void (*_gdrawchar8t)(unsigned short x, unsigned short y, unsigned char c, unsigned char f);
extern void (*_gdrawchar8p)(unsigned short x, unsigned short y, unsigned char c, unsigned char f, void *picp);
extern void (*_gdrawstr)(unsigned short y, unsigned short x, const char *s, unsigned short len, unsigned char f, unsigned char b);
extern void (*_gupdatestr)(unsigned short y, unsigned short x, const uint16_t *str, unsigned short len, uint16_t *old);
extern void (*_gupdatepal)(unsigned char color, unsigned char red, unsigned char green, unsigned char blue);
extern void (*_gflushpal)(void);

extern int (*_ekbhit)(void);
extern int (*_egetch)(void);

extern void (*_drawbar)(unsigned short x, unsigned short yb, unsigned short yh, unsigned long hgt, unsigned long c);
extern void (*_idrawbar)(unsigned short x, unsigned short yb, unsigned short yh, unsigned long hgt, unsigned long c);

extern void (*_Screenshot)(void);
extern void (*_TextScreenshot)(int scrType);
extern void (*_RefreshScreen)(void);

extern void (*_setcur)(unsigned char y, unsigned char x);
extern void (*_setcurshape)(unsigned short shape);

extern int (*_conRestore)(void);
extern void (*_conSave)(void);

extern void (*_plDosShell)(void);

#endif
