/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Variables for wavetable system
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 */

#include "config.h"
#include "types.h"
#include "mcp.h"

int mcpNChan;

void (*mcpIdle)(void);

int (*mcpLoadSamples)(struct sampleinfo* si, int n);
int (*mcpOpenPlayer)(int, void (*p)(void));
void (*mcpClosePlayer)(void);
void (*mcpSet)(int ch, int opt, int val);
int (*mcpGet)(int ch, int opt);
void (*mcpGetRealVolume)(int ch, int *l, int *r);
void (*mcpGetRealMasterVolume)(int *l, int *r);
void (*mcpGetMasterSample)(int16_t *s, unsigned int len, uint32_t rate, int opt);
int (*mcpGetChanSample)(unsigned int ch, int16_t *s, unsigned int len, uint32_t rate, int opt);
int (*mcpMixChanSamples)(unsigned int *ch, unsigned int n, int16_t *s, unsigned int len, uint32_t rate, int opt);

unsigned int mcpMixMaxRate;
unsigned int mcpMixProcRate;
int mcpMixOpt;
unsigned int mcpMixBufSize;
unsigned int mcpMixMax;
int mcpMixPoll;
