/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * GMDPlay loader for Oktalyzer modules
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 */

#include "config.h"
#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "boot/plinkman.h"
#include "dev/mcp.h"
#include "gmdplay.h"
#include "stuff/err.h"

static inline void putcmd(uint8_t **p, uint8_t c, uint8_t d)
{
	*(*p)++=c;
	*(*p)++=d;
}

static inline unsigned short swapw(uint16_t a)
{
	return ((a&0xFF)<<8)|((a&0xFF00)>>8);
}

static inline unsigned long swapl(uint32_t a)
{
	return ((a&0xFF)<<24)|((a&0xFF00)<<8)|((a&0xFF0000)>>8)|((a&0xFF000000)>>24);
}

int mpLoadOKT(struct gmdmodule *m, FILE *file)
{

	uint8_t sig[8];
	uint32_t blen;
	uint16_t cflags[4];
	uint8_t cflag2[8];
	int i,t;
	uint16_t orgticks;
	uint16_t pn;
	uint16_t ordn;
	uint8_t orders[128];
	struct gmdpattern *pp;
	uint8_t *temptrack;
	uint8_t *buffer;

	mpReset(m);

	fread(sig, 8, 1, file);
	if (memcmp(sig, "OKTASONG", 8))
		return errFormSig;

	*m->name=0;
	m->message=0;

	m->options=MOD_TICK0;

	fread(sig, 4, 1, file);
	if (memcmp(sig, "CMOD", 4))
		return errFormStruc;

	fread(&blen, sizeof(uint32_t), 1, file);
	blen=htonl(blen);
	if (blen!=8)
		return errFormStruc;

	fread(cflags, 8, 1, file);
	t=0;
	for (i=0; i<4; i++)
	{
		cflag2[t]=(htons(cflags[i])&1)|((i+i+i)&2);
		if (cflag2[t++]&1)
			cflag2[t++]=(htons(cflags[i])&1)|((i+i+i)&2);
	}
	m->channum=t;

	fread(sig, 4, 1, file);
	if (memcmp(sig, "SAMP", 4))
		return errFormStruc;

	fread(&blen, sizeof(uint32_t), 1, file);
	blen=htonl(blen);
	if (blen&31)
		return errFormStruc;
	blen>>=5;

	m->modsampnum=m->sampnum=m->instnum=blen;

	if (!mpAllocInstruments(m, m->instnum)||!mpAllocSamples(m, m->sampnum)||!mpAllocModSamples(m, m->modsampnum))
		return errAllocMem;

	for (i=0; i<m->instnum; i++)
	{
		uint32_t length;
		uint32_t loopstart;
		uint32_t looplength;
		struct gmdinstrument *ip;
		struct gmdsample *sp;
		struct sampleinfo *sip;

		struct __attribute__((packed))
		{
			char name[20];
			unsigned long length;
			unsigned short repstart;
			unsigned short replen;
			char pad1;
			unsigned char vol;
			short pad2;
		} mi;
		fread(&mi, sizeof(mi), 1, file);
		length=htonl(mi.length);
		loopstart=htons(mi.repstart);
		looplength=htons(mi.replen);
		if (length<4)
			length=0;
		if (looplength<4)
			looplength=0;
		if (!looplength||(loopstart>=length))
			looplength=0;
		else
			if ((loopstart+looplength)>length)
				looplength=length-loopstart;

		ip=&m->instruments[i];
		sp=&m->modsamples[i];
		sip=&m->samples[i];

		memcpy(ip->name, mi.name, 20);
		ip->name[20]=0;
		if (!length)
			continue;

		for (t=0; t<128; t++)
			ip->samples[t]=i;

		*ip->name=0;
		sp->handle=i;
		sp->normnote=0;
		sp->stdvol=(mi.vol>0x3F)?0xFF:(mi.vol<<2);
		sp->stdpan=-1;
		sp->opt=0;

		sip->length=length;
		sip->loopstart=loopstart;
		sip->loopend=loopstart+looplength;
		sip->samprate=8363;
		sip->type=looplength?mcpSampLoop:0;
	}

	fread(sig, 4, 1, file);
	if (memcmp(sig, "SPEE", 4))
		return errFormStruc;
	
	fread(&blen, sizeof(uint32_t), 1, file);
	blen=htonl(blen);

	if (blen!=2)
		return errFormStruc;

	fread(&orgticks, sizeof(uint16_t), 1, file);
	orgticks=htons(orgticks);

	fread(sig, 4, 1, file);
	if (memcmp(sig, "SLEN", 4))
		return errFormStruc;

	
	fread(&blen, sizeof(uint32_t), 1, file);
	blen=htonl(blen);

	if (blen!=2)
		return errFormStruc;
	
	fread(&pn, sizeof(uint16_t), 1, file);
	pn=htons(pn);


	fread(sig, 4, 1, file);
	if (memcmp(sig, "PLEN", 4))
		return errFormStruc;

	fread(&blen, sizeof(uint32_t), 1, file);
	if (blen!=2)
		return errFormStruc;

	fread(&ordn, sizeof(uint16_t), 1, file);
	ordn=htons(ordn);

	fread(sig, 4, 1, file);
	if (memcmp(sig, "PATT", 4))
		return errFormStruc;

	fread(&blen, sizeof(uint32_t), 1, file);
	blen=htonl(blen);
	if (blen>128)
		return errFormStruc;

	fread(orders, blen, 1, file);
	if (blen<ordn)
		ordn=blen;
	m->loopord=0;

	m->patnum=ordn;
	m->ordnum=ordn;
	m->endord=m->patnum;
	m->tracknum=pn*(m->channum+1);

	if (!mpAllocPatterns(m, m->patnum)||!mpAllocTracks(m, m->tracknum)||!mpAllocOrders(m, m->ordnum))
		return errAllocMem;

	for (i=0; i<m->ordnum; i++)
		m->orders[i]=i;

	for (pp=m->patterns, t=0; t<m->patnum; pp++, t++)
	{
		for (i=0; i<m->channum; i++)
			pp->tracks[i]=orders[t]*(m->channum+1)+i;
		pp->gtrack=orders[t]*(m->channum+1)+m->channum;
	}

	temptrack=malloc(sizeof(uint8_t)*3000);
	buffer=malloc(sizeof(uint8_t)*(1024*m->channum));
	if (!buffer||!temptrack)
		return errAllocMem;

	for (t=0; t<pn; t++)
	{
		uint16_t patlen;
		int16_t q;
		uint8_t *tp;
		uint8_t *buf;
		uint8_t row;
		struct gmdtrack *trk;
		uint16_t len;

		fread(sig, 4, 1, file);
		if (memcmp(sig, "PBOD", 4))
			return errFormStruc;
		fread(&blen, sizeof(uint32_t), 1, file);
		blen=htonl(blen);

		fread(&patlen, sizeof(uint16_t), 1, file);
		patlen=htons(patlen);

		if ((blen!=(2+4*m->channum*patlen))||(patlen>256))
			return errFormStruc;

		for (q=0; q<m->patnum; q++)
			if (t==orders[q])
				m->patterns[q].patlen=patlen;

		fread(buffer, 4*m->channum*patlen, 1, file);
		for (q=0; q<m->channum; q++)
		{
			uint8_t *tp=temptrack;
			uint8_t *buf=buffer+4*q;

			struct gmdtrack *trk;
			uint16_t len;
 
			uint8_t row;
			for (row=0; row<patlen; row++, buf+=m->channum*4)
			{
				uint8_t *cp=tp+2;

				uint8_t command=buf[2];
				uint8_t data=buf[3];
				int16_t nte=buf[0]?(buf[0]+60-17+4):-1;
				int16_t ins=buf[0]?buf[1]:-1;
				int16_t pan=-1;
				int16_t vol=-1;

				if (!row&&(t==orders[0]))
					pan=(cflag2[q]&2)?0xFF:0x00;

				if ((command==31)&&(data<=0x40))
				{
					vol=(data>0x3F)?0xFF:(data<<2);
					command=0;
				}
				if ((ins!=-1)||(nte!=-1)||(vol!=-1)||(pan!=-1))
				{
					unsigned char *act=cp;
					*cp++=cmdPlayNote;
					if (ins!=-1)
					{
						*act|=cmdPlayIns;
						*cp++=ins;
					}
					if (nte!=-1)
					{
						*act|=cmdPlayNte;
						*cp++=nte;
					}
					if (vol!=-1)
					{
						*act|=cmdPlayVol;
						*cp++=vol;
					}
					if (pan!=-1)
					{
						*act|=cmdPlayPan;
						*cp++=pan;
					}
				}
				switch (command)
				{
					case 13: /* note down */
					case 17: /* note up */
					case 21: /* note - */
					case 30: /* note + */
						break;
					case 10: /* LNH */
					case 11: /* NHNL */
					case 12: /* HHNLL */
						break;
					case 31:
						if (data<=0x50)
							putcmd(&cp, cmdVolSlideDown, (data&0xF)<<2);
						else
							if (data<=0x60)
								putcmd(&cp, cmdVolSlideUp, (data&0xF)<<2);
							else
								if (data<=0x70)
									putcmd(&cp, cmdRowVolSlideDown, (data&0xF)<<2);
								else
									if (data<=0x80)
										putcmd(&cp, cmdRowVolSlideUp, (data&0xF)<<2);
						break;
					case 27: /* release!!! */
						putcmd(&cp, cmdSetLoop, 0);
						break;
					case 0x1:
						putcmd(&cp, cmdPitchSlideDown, data);
						break;
					case 0x2:
						putcmd(&cp, cmdPitchSlideUp, data);
						break;
				}

				if (cp!=(tp+2))
				{
					tp[0]=row;
					tp[1]=cp-tp-2;
					tp=cp;
				}
			}
			trk=&m->tracks[t*(m->channum+1)+q];
			len=tp-temptrack;

			if (!len)
				trk->ptr=trk->end=0;
			else {
				trk->ptr=malloc(sizeof(uint8_t)*len);
				trk->end=trk->ptr+len;
				if (!trk->ptr)
					return errAllocMem;
				memcpy(trk->ptr, temptrack, len);
			}
		}

		tp=temptrack;
		buf=buffer;
		for (row=0; row<patlen; row++)
		{
			uint8_t *cp=tp+2;

			if (!row&&(t==orders[0]))
				putcmd(&cp, cmdTempo, orgticks);

			for (q=0; q<m->channum; q++, buf+=4)
			{
				uint8_t command=buf[2];
				uint8_t data=buf[3];

				switch (command)
				{
					case 25:
						putcmd(&cp, cmdGoto, data);
						break;
					case 28:
						if (data)
							putcmd(&cp, cmdTempo, data);
						break;
				}
			}

			if (cp!=(tp+2))
			{
				tp[0]=row;
				tp[1]=cp-tp-2;
				tp=cp;
			}
		}

		trk=&m->tracks[t*(m->channum+1)+m->channum];
		len=tp-temptrack;

		if (!len)
			trk->ptr=trk->end=0;
		else {
			trk->ptr=malloc(sizeof(uint8_t)*len);
			trk->end=trk->ptr+len;
			if (!trk->ptr)
				return errAllocMem;
			memcpy(trk->ptr, temptrack, len);
		}
	}
	free(temptrack);
	free(buffer);

	for (i=0; i<m->instnum; i++)
	{
/*		struct gmdinstrument *ip=&m->instruments[i];  NOT USED */
		struct gmdsample *sp=&m->modsamples[i];
		struct sampleinfo *sip=&m->samples[i];
		if (sp->handle==0xFFFF)
			continue;

		fread(sig, 4, 1, file);
		if (memcmp(sig, "SBOD", 4))
			return errFormStruc;

		fread(&blen, sizeof(uint32_t), 1, file);
		blen=htonl(blen);

		sip->ptr=malloc(sizeof(char)*(blen+8));
		if (!sip->ptr)
			return errAllocMem;

		fread(sip->ptr, blen, 1, file);
		if (sip->length>blen)
			sip->length=blen;
		if (sip->loopend>blen)
			sip->loopend=blen;
		if (sip->loopstart>=sip->loopend)
			sip->type&=~mcpSampLoop;
	}

	return errOk;
}

struct linkinfostruct dllextinfo = {"gmdlokt", "OpenCP Module Loader: *.OKT (c) 1994-04 Niklas Beisert", DLLVERSION, 0};
