#ifndef _DWMIXQ_H
#define _DWMIXQ_H

#define MIXQ_PLAYING 1
#define MIXQ_PAUSED 2
#define MIXQ_LOOPED 4
#define MIXQ_PINGPONGLOOP 8
#define MIXQ_PLAY16BIT 16
#define MIXQ_INTERPOLATE 32
#define MIXQ_INTERPOLATEMAX 64
#define MIXQ_PLAYSTEREO 128

extern void mixqPlayChannel(short *buf, unsigned long len, struct channel *ch, char quiet);
extern void mixqSetupAddresses(const void *voltab, const void *intrtab1, const void *intrtab2);
extern void mixqAmplifyChannel(long *buf, short *src, int len, int vol, int step);
extern void mixqAmplifyChannelUp(long *buf, short *src, int len, int vol, int step);
extern void mixqAmplifyChannelDown(long *buf, short *src, int len, int vol, int step);

/*
extern "C" void mixqPlayChannel(short *buf, unsigned long len, channel &ch, char quiet);
#pragma aux mixqPlayChannel "*_" parm [] caller modify [eax ebx ecx edx esi edi]
extern "C" void mixqSetupAddresses(const void *voltab, const void *intrtab1, const void *intrtab2);
#pragma aux mixqSetupAddresses "*_" parm [eax] [ebx] [ecx] modify [eax]
extern "C" void mixqAmplifyChannel(long *buf, short *src, int len, int vol, int step);
#pragma aux mixqAmplifyChannel "*_" parm [edi] [esi] [ecx] [ebx] [edx] modify [eax]
extern "C" void mixqAmplifyChannelUp(long *buf, short *src, int len, int vol, int step);
#pragma aux mixqAmplifyChannelUp "*_" parm [edi] [esi] [ecx] [ebx] [edx] modify [eax]
extern "C" void mixqAmplifyChannelDown(long *buf, short *src, int len, int vol, int step);
#pragma aux mixqAmplifyChannelDown "*_" parm [edi] [esi] [ecx] [ebx] [edx] modify [eax]
*/

extern void remap_range2_start(void);
extern void remap_range2_stop(void);


#endif
