/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Mixer asm routines for display etc
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss04????   Stian Skjelstad <stian@nixia.no>
 *    -ported to gcc assembler
 *  -ss040908   Stian Skjelstad <stian@nixia.no>
 *    -made assembler optimizesafe
 */

#include "config.h"
#include "mix.h"
#include "mixasm.h"

#ifndef NULL
 #define NULL ((void *)0)
#endif

#if MIX_PLAYING!=1
#error MIX_PLAYING/MCP_PLAYING should be 1
#endif

#if MIX_MUTE!=2
#error MIX_MUTE/MCP_PAUSED should be 2
#endif

#if MIX_LOOPED!=4
#error MIX_LOOPED/MCP_LOOPED should be 4
#endif

#if MIX_PINGPONGLOOP!=8
#error MIX_PINGPONGLOOP/MCP_PINGPONGLOOPED should be 8
#endif

#if MIX_PLAY16BIT!=16
#error MIX_PLAY16BIT/MCP_PLAY16BIT should be 16
#endif

#if MIX_INTERPOLATE!=32
#error MIX_INTERPOLATE/MCP_INTERPOLATE should be 32
#endif

#if MIX_MAX!=64
#error MIX_MAX/MCP_MAX should be 64
#endif

#if MIX_PLAY32BIT!=128
#error MIX_PLAY32BIT/MCP_PLAY32BIT should be 128
#endif

static void __attribute__ ((used)) dummy55 (void)
{
#ifdef __PIC__
__asm__ __volatile__
(
	".local	interpolate\n"
	".comm	interpolate,4,4\n"
	".local	play16bit\n"
	".comm	play16bit,4,4\n"
	".local	play32bit\n"
	".comm	play32bit,4,4\n"
	".local	render16bit\n"
	".comm	render16bit,4,4\n"
	".local voltabs\n"
	".comm  voltabs,8,8\n"
	".comm  mixIntrpolTab,4,4\n"
	".comm  mixIntrpolTab2,4,4\n"
	".local playrout\n"
	".comm playrout,4,4\n"
	".local inloop\n"
	".comm inloop,4,4\n"
);
#endif
__asm__ __volatile__
(
 	".equ MIX_PINGPONGLOOP, %0\n"
	".equ MIX_PLAYING, %1\n"
	".equ MIX_LOOPED, %2\n"
	".equ MIX_PLAY32BIT, %3\n"
	".equ MIX_PLAY16BIT, %4\n"
	".equ MIX_MAX, %5\n"
	".equ MIX_INTERPOLATE, %6\n"
	: :
	  "m" (*(char *)(MIX_PINGPONGLOOP))/*MCP_PINGPONGLOOP*/,        /*   0  */
	  "m" (*(char *)(MIX_PLAYING))/*(MCP_PLAYING)*/,                /*   1  */
	  "m" (*(char *)(MIX_LOOPED))/*(MCP_LOOPED)*/,                  /*   2  */
	  "m" (*(char *)(MIX_PLAY32BIT))/*(MCP_PLAY32BIT)*/,            /*   3  */
	  "m" (*(char *)(MIX_PLAY16BIT))/*(MCP_PLAY16BIT)*/,            /*   4  */
	  "m" (*(char *)(MIX_MAX))/*(MCP_MAX)*/,                        /*   5  */
	  "m" (*(char *)(MIX_INTERPOLATE))/*(MCP_INTERPOLATE)*/         /*   6  */
	  );
}
#ifndef __PIC__
signed char (*mixIntrpolTab)[256][2];
short (*mixIntrpolTab2)[256][2];
static __attribute__((used)) int interpolate=0;
static __attribute__((used)) int play16bit=0;
static __attribute__((used)) int play32bit=0;
static __attribute__((used)) int render16bit=0;
static __attribute__((used)) int voltabs[2]={0,0};
static __attribute__((used)) void (*playrout)(const long *buf, struct mixchannel *ch, int len);
static __attribute__((used)) int inloop;
#endif

void mixasm_remap_start(void){}

#ifdef I386_ASM
void mixPlayChannel(long *buf, unsigned long len, struct mixchannel *ch, char stereo)
{
	int d0;
	
#ifdef __PIC__
	int ebx;
#endif
	__asm__ __volatile__
	(
#ifdef __PIC__
		" movl %%ebx, %14\n"
#endif
		"  movl $0, interpolate\n"
		"  movl $0, play16bit\n"
		"  movl $0, play32bit\n"
		"  movl $0, render16bit\n"

		"  testb $MIX_PLAYING, %8(%%edi)\n"
		                                  /*  %8 = ch->status */
		"  jz pcexit\n"
		"  testb $MIX_INTERPOLATE, %8(%%edi)\n"
		                                  /*  %8 = ch->status */
		"  jz mixPlayChannel_nointr\n"
		"     movl $1, interpolate\n"
		"     testb $MIX_MAX, %8(%%edi)\n"/*  %8 = ch->status */
		"     jz mixPlayChannel_nointr\n"
		"       movl $1, render16bit\n"
		"mixPlayChannel_nointr:\n"
		"  testb $MIX_PLAY16BIT, %8(%%edi)\n"
		                                  /*  %8 = ch->status */
		"  jz mixPlayChannel_no16bit\n"
		"    movl $1, play16bit\n"
		"mixPlayChannel_no16bit:\n"
		"  testb $MIX_PLAY32BIT, %8(%%edi)\n"
		                                  /*  %8= ch->status */
		"  jz mixPlayChannel_no32bit\n"
		"    movl $1, play32bit\n"
		"mixPlayChannel_no32bit:\n"

		"  cmpb $0, %1\n"                 /*  %1 = stereo */
		"  jne mixPlayChannel_pstereo\n"

		"mixPlayChannel_pmono:\n"
		"  movl %12(%%edi), %%eax\n"      /* %12 = ch->vol.voltabs[0] */
		"  movl %%eax, voltabs+0\n"
		"  movl $playmono, playrout\n"
		"  jmp mixPlayChannel_bigloop\n"

		"mixPlayChannel_pstereo:\n"
		"  movl %12(%%edi), %%eax\n"      /* %12 = ch->vol.voltabs[0] */
		"  movl %13(%%edi), %%ebx\n"      /* %13 = ch->vol.voltabs[1] */
		"  movl %%eax, voltabs\n"
		"  movl %%ebx, voltabs+4\n"
		"  movl $playodd, playrout\n"

		"mixPlayChannel_bigloop:\n"
		"  movl %2, %%ecx\n"              /*  %2 = len */
		"  movl %11(%%edi), %%ebx\n"      /* %11 = ch->step */
		"  movl %9(%%edi), %%edx\n"       /*  %9 = ch->pos */
		"  movw %10(%%edi), %%si\n"       /* %10 = ch->->fpos */
		"  movl $0, inloop\n"
		"  cmpl $0, %%ebx\n"

		"  je mixPlayChannel_playecx\n"
		"  jg mixPlayChannel_forward\n"
		"    negl %%ebx\n"
		"    movl %%edx, %%eax\n"
		"    testb $MIX_LOOPED, %8(%%edi)\n"
		                                  /*  %8 = ch->->status */
		"    jz mixPlayChannel_maxplaylen\n"
		"    cmpl %7(%%edi), %%edx\n"     /*  %7 = ch->loopstart */
		"    jb mixPlayChannel_maxplaylen\n"
		"    subl %7(%%edi), %%eax\n"     /*  %7 = ch->loopstart */
		"    movl $1, inloop\n"
		"    jmp mixPlayChannel_maxplaylen\n"
		"mixPlayChannel_forward:\n"
		"    movl %4(%%edi), %%eax\n"     /*  %4 = ch->length */
		"    negw %%si\n"
		"    sbbl %%edx, %%eax\n"
		"    testb $MIX_LOOPED, %8(%%edi)\n"
		                                  /*  %8 = ch->->status */
		"    jz mixPlayChannel_maxplaylen\n"
		"    cmpl %5(%%edi), %%edx\n"     /*  %5 = ch->loopend */
		"    jae mixPlayChannel_maxplaylen\n"
		"    subl %4(%%edi), %%eax\n"     /*  %4 = ch->length */
		"    addl %5(%%edi), %%eax\n"     /*  %5 = ch->loopend */
		"    movl $1, inloop\n"

		"mixPlayChannel_maxplaylen:\n"
		"  xorl %%edx, %%edx\n"
		"  shld $16, %%eax, %%edx\n"
		"  shll $16, %%esi\n"
		"  shld $16, %%esi, %%eax\n"
		"  addl %%ebx, %%eax\n"
		"  adcl $0, %%edx\n"
		"  subl $1, %%eax\n"
		"  sbbl $0, %%edx\n"
		"  cmpl %%ebx, %%edx\n"
		"  jae mixPlayChannel_playecx\n"
		"  divl %%ebx\n"
		"  cmpl %%eax, %%ecx\n"
		"  jb mixPlayChannel_playecx\n"
		"    movl %%eax, %%ecx\n"
		"    cmpl $0, inloop\n"
		"    jnz mixPlayChannel_playecx\n"
		"      andb $254, %8(%%edi)\n"    /*** 254 = MCP_PLAYING^255   no parameters left  ***
		                                   *  %8 = ch->status */
		"      movl %%ecx, %2\n"          /*  %2 = len */

		"mixPlayChannel_playecx:\n"
		"  pushl %%ebp\n"
		"  pushl %%edi\n"
		"  pushl %%ecx\n"
		"  movl %%ecx, %%eax\n"
		"  movl %3, %%ecx\n"              /*  %3 = buf */
		"  movl %%eax, %%ebp\n"

		"  call *playrout\n"

		"  popl %%ecx\n"
		"  popl %%edi\n"
		"  popl %%ebp\n"

		"  movl %%ecx, %%eax\n"
		"  shll $2, %%eax\n"
		"  cmpl $0, %1\n"                 /*  %1 = stereo */
		"  je mixPlayChannel_m2\n"
		"  shll $1, %%eax\n"
		"mixPlayChannel_m2:\n"
		"  addl %%eax, %3\n"              /*  %3 = buf */
		"  subl %%ecx, %2\n"              /*  %2 = len */

		"  movl %11(%%edi), %%eax\n"      /* %11 = ch->step */
		"  imul %%ecx\n"
		"  shld $16, %%eax, %%edx\n"
		"  addw %%ax, %10(%%edi)\n"       /* %10 = ch->->fpos */
		"  adcl %%edx, %9(%%edi)\n"       /*  %9 = ch->pos */
		"  movl %9(%%edi), %%eax\n"       /*  %9 = ch->pos */

		"  cmpl $0, inloop\n"
		"  jz pcexit\n"

		"  cmpl $0, %11(%%edi)\n"         /* %11 = ch->step */
		"  jge mixPlayChannel_forward2\n"
		"    cmpl %7(%%edi), %%eax\n"     /*  %7 = ch->->loopstart */
		"    jge pcexit\n"
		"    testb $MIX_PINGPONGLOOP, %8(%%edi)\n"
		                                  /*  %8 = ch->status */
		"    jnz mixPlayChannel_pong\n"
		"      addl %6(%%edi), %%eax\n"   /*  %6 = ch->replen */
		"      jmp mixPlayChannel_loopiflen\n"
		"mixPlayChannel_pong:\n"
		"      negl %11(%%edi)\n"         /* %11 = ch->step */
		"      negw %10(%%edi)\n"         /* %10 = ch->->fpos */
		"      adcl $0, %%eax\n"
		"      negl %%eax\n"
		"      addl %7(%%edi), %%eax\n"   /*  %7 = ch->->loopstart */
		"      addl %7(%%edi), %%eax\n"   /*  %7 = ch->->loopstart */
		"      jmp mixPlayChannel_loopiflen\n"
		"mixPlayChannel_forward2:\n"
		"    cmpl %5(%%edi), %%eax\n"     /*  %5 = ch->->loopend */
		"    jb pcexit\n"
		"    testb $MIX_PINGPONGLOOP, %8(%%edi)\n"
		                                  /*  %8 = ch->status */
		"    jnz mixPlayChannel_ping\n"
		"      sub %6(%%edi), %%eax\n"    /*  %6 = ch->replen */
		"      jmp mixPlayChannel_loopiflen\n"
		"mixPlayChannel_ping:\n"
		"      negl %11(%%edi)\n"         /* %11 = ch->step */
		"      negw %10(%%edi)\n"         /* %10 = ch->->fpos */
		"      adcl $0, %%eax\n"
		"      negl %%eax\n"
		"      addl %5(%%edi), %%eax\n"   /*  %5 = ch->->loopend */
		"      addl %5(%%edi), %%eax\n"   /*  %5 = ch->->loopend */

		"mixPlayChannel_loopiflen:\n"
		"  movl %%eax, %9(%%edi)\n"       /*  %9 = ch->pos */
		"  cmpl $0, %2\n"                 /*  %2 = len */
		"  jne mixPlayChannel_bigloop\n"

		"pcexit:\n"
#ifdef __PIC__
		"  movl %14, %%ebx\n"
#endif
	
		: "=&D" (d0)                                         /*   0  */
		: "m" (stereo),                                      /*   1  */
		  "m" (len),                                         /*   2  */
		  "m" (buf),                                         /*   3  */
		  "m" (((struct mixchannel *)NULL)->length),         /*   4  */
		  "m" (((struct mixchannel *)NULL)->loopend),        /*   5  */
		  "m" (((struct mixchannel *)NULL)->replen),         /*   6  */
		  "m" (((struct mixchannel *)NULL)->loopstart),      /*   7  */
		  "m" (((struct mixchannel *)NULL)->status),         /*   8  */
		  "m" (((struct mixchannel *)NULL)->pos),            /*   9  */
		  "m" (((struct mixchannel *)NULL)->fpos),           /*  10  */
		  "m" (((struct mixchannel *)NULL)->step),           /*  11  */
		  "m" (((struct mixchannel *)NULL)->vol.voltabs[0]), /*  12  */
		  "m" (((struct mixchannel *)NULL)->vol.voltabs[1]), /*  13  */
#ifdef __PIC__
		  "m" ((ebx)),                                       /*  14  */
#endif
		  "0" (ch)
		: "memory", "eax", "ecx", "edx", "esi"
	);	    
}

static void __attribute__ ((used)) dummy54 (void)
{
	__asm__ __volatile__
	(
		 "playmono:\n"
		 "  cmpl $0, interpolate\n"
		 "  jnz playmonoi\n"

		 "  cmpl $0, play16bit\n"
		 "  jnz playmono16\n"

		 "  cmpl $0, play32bit\n"
		 "  jnz playmono32\n"

		 "  cmp $0, %%ebp\n"
		 "  je done1\n"

		 "  movl voltabs+0, %%eax\n"
		 "  movl %%eax, (vol11-4)\n"
		 "  movl %0(%%edi), %%eax\n"      /*  %0 = ch->step */
		 "  shll $16, %%eax\n"
		 "  movl %%eax, (edx1-4)\n"
		 "  movl %0(%%edi), %%eax\n"      /*  %0 = ch->step */
		 "  sarl $16, %%eax\n"
		 "  movl %%eax, (ebp1-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp1:\n"
		"    movb (%%esi), %%bl\n"
		"    addl $1234, %%edx\n"
		"edx1:\n"
		"    movl 1234(,%%ebx,4), %%eax\n"
		"vol11:\n"
		"    adcl $1234, %%esi\n"
		"ebp1:\n"
		"    addl %%eax, (%%edi)\n"
		"    addl $4, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp1\n"

		"done1:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /* 0 */
		  "m" (((struct mixchannel *)NULL)->fpos), /* 1 */
		  "m" (((struct mixchannel *)NULL)->pos),  /* 2 */
		  "m" (((struct mixchannel *)NULL)->samp)  /* 3 */
	);

	__asm__ __volatile__
	(
		"playmono16:"
		"  cmp $0, %%ebp\n"
		"  je done2\n"

		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol2-4)\n"
		"  movl %1(%%edi), %%eax\n"       /*  %1 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx2-4)\n"
		"  movl %1(%%edi), %%eax\n"       /*  %1 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp2-4)\n"

		"  movw %2(%%edi), %%dx\n"        /*  %2 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %3(%%edi), %%esi\n"       /*  %3 = ch->pos */
		"  addl %0(%%edi), %%esi\n"       /*  %0 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp2:\n"
		"    movb 1(%%esi,%%esi), %%bl\n"
		"    addl $1234, %%edx\n"
		"edx2:\n"
		"    movl 1234(,%%ebx,4), %%eax\n"
		"vol2:\n"
		"    adcl $1234, %%esi\n"
		"ebp2:\n"
		"    addl %%eax, (%%edi)\n"
		"    addl $4, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp2\n"

		"done2:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->samp), /*  0  */
		  "m" (((struct mixchannel *)NULL)->step), /*  1  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  2  */
		  "m" (((struct mixchannel *)NULL)->pos)   /*  3  */
	);
  
	  __asm__ __volatile__
	(
		"playmono32:"
		"  cmp $0, %%ebp\n"
		"  je done3\n"

		"  flds %0(%%edi)\n"              /*  %0 = ch->vol.voltabs[0] */
		"  fmuls gscale\n"
		"  fstps scale\n"

		"  movl %1(%%edi), %%eax\n"       /*  %1 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx3-4)\n"
		"  movl %1(%%edi), %%eax\n"       /*  %1 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp3-4)\n"

		"  movw %2(%%edi), %%dx\n"        /*  %2 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %3(%%edi), %%esi\n"       /*  %3 = ch->pos */
		"  addl %4(%%edi), %%esi\n"       /*  %4 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp3:\n"
		"    flds (,%%esi,4)\n"
		"    fmuls scale\n"
		"    fistpl integer\n"
		"    movl integer, %%eax\n"
		
		"    addl $1234, %%edx\n"
		"edx3:\n"
		"    adcl $1234, %%esi\n"
		"ebp3:\n"
		"    addl %%eax, (%%edi)\n"
		"    addl $4, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp3\n"

		"done3:\n"
		"  ret\n"

		".data\n"
		"integer: .long 0\n"
		"scale: .float 0.0\n"
		"gscale: .float 64.0\n"
		".previous\n"
		:
		: "m" (((struct mixchannel *)NULL)->vol.voltabs[0]), /*  0  */
		  "m" (((struct mixchannel *)NULL)->step),           /*  1  */
		  "m" (((struct mixchannel *)NULL)->fpos),           /*  2  */
		  "m" (((struct mixchannel *)NULL)->pos),            /*  3  */
		  "m" (((struct mixchannel *)NULL)->samp)            /*  4  */
	);

	__asm__ __volatile__
	(
		"playmonoi:\n"
		"  cmpl $0, render16bit\n"
		"  jnz playmonoir\n"

		"  cmpl $0, play16bit\n"
		"  jnz playmonoi16\n"

		"  cmpl $0, play32bit\n" 
		"  jnz playmono32\n"   /* !! */

		"  cmpl $0, %%ebp\n"
		"  je done4\n"

		"  movl mixIntrpolTab, %%eax\n"
		"  movl %%eax, (int04-4)\n"
		"  incl %%eax\n"
		"  movl %%eax, (int14-4)\n"
		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol14-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx4-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp4-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp4:\n"
		"    movl %%edx, %%ecx\n"
		"    shrl $20, %%ecx\n"
		"    movb (%%esi), %%cl\n"
		"    movb 1234(%%ecx,%%ecx), %%bl\n"
		"int04:\n"
		"    movb 1(%%esi), %%cl\n"
		"    addb 1234(%%ecx,%%ecx), %%bl\n"
		"int14:\n"

		"    addl $1234, %%edx\n"
		"edx4:\n"
		"    movl 1234(,%%ebx,4), %%eax\n"
		"vol14:\n"
		"    adcl $1234, %%esi\n"
		"ebp4:\n"
		"    addl %%eax, (%%edi)\n"
		"    addl $4, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp4\n"

		"done4:\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playmonoi16:\n"
		"   cmpl $0, %%ebp\n"
		"   je done5\n"

		"  movl mixIntrpolTab, %%eax\n"
		"  movl %%eax, (int05-4)\n"
		"  incl %%eax\n"
		"  movl %%eax, (int15-4)\n"
		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol15-4)\n"
		"  movl %2(%%edi), %%eax\n"
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx5-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp5-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp5:\n"
		"    movl %%edx, %%ecx\n"
		"    shrl $20, %%ecx\n"
		"    movb 1(%%esi,%%esi), %%cl\n"
		"    movb 1234(%%ecx,%%ecx), %%bl\n"
		"int05:\n"
		"    movb 3(%%esi, %%esi), %%cl\n"
		"    addb 1234(%%ecx,%%ecx), %%bl\n"
		"int15:\n"

		"    addl $1234, %%edx\n"
		"edx5:\n"
		"    movl 1234(,%%ebx,4), %%eax\n"
		"vol15:\n"
		"    adcl $1234, %%esi\n"
		"ebp5:\n"
		"    addl %%eax, (%%edi)\n"
		"    addl $4, %%edi\n"
		"  dec %%ebp\n"
		"  jnz lp5\n"

		"done5:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playmonoir:\n"
		"  cmpl $0, play16bit\n"
		"  jne playmonoi16r\n"

		"  cmpl $0, play32bit\n"
		"  jne playmono32\n" /* !! */

		"  cmpl $0, %%ebp\n"
		"  je done6\n"

		"  movl mixIntrpolTab2, %%eax\n"
		"  movl %%eax, (int06-4)\n"
		"  addl $2, %%eax\n"
		"  movl %%eax, (int16-4)\n"

		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol16-4)\n"
		"  addl $1024, %%eax\n"
		"  movl %%eax, (vol26-4)\n"

		"  movl %0(%%edi),%%eax\n"        /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx6-4)\n"
		"  movl %0(%%edi),%%eax\n"        /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp6-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp6:\n"
		"    movl %%edx, %%ecx\n"
		"    shrl $19, %%ecx\n"
		"    movb (%%esi), %%cl\n"
		"    movl 1234(,%%ecx,4), %%ebx\n"
		"int06:\n"
		"    movb 1(%%esi), %%cl\n"
		"    addl 1234(,%%ecx,4), %%ebx\n"
		"int16:\n"
		"    movzbl %%bh, %%ecx\n"
		"    movzbl %%bl, %%ebx\n"

		"    addl $1234, %%edx\n"
		"edx6:\n"
		"    movl 1234(,%%ecx,4), %%eax\n"
		"vol16:\n"
		"    adcl $1234, %%esi\n"
		"ebp6:\n"
		"    addl 1234(,%%ebx,4), %%eax\n"
		"vol26:\n"
		"    addl %%eax, (%%edi)\n"
		"    addl $4, %%edi\n"
		"  dec %%ebp\n"
		"  jnz lp6\n"

		"done6:\n"
		"  ret\n"

		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playmonoi16r:\n"
		"  cmpl $0, %%ebp\n"
		"  je done7\n"

		"  movl mixIntrpolTab2, %%eax\n"
		"  movl %%eax, (int07-4)\n"
		"  addl $2, %%eax\n"
		"  movl %%eax, (int17-4)\n"

		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol17-4)\n"
		"  addl $1024, %%eax\n"
		"  movl %%eax, (vol27-4)\n"

		"  movl %0(%%edi),%%eax\n"        /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx7-4)\n"
		"  movl %0(%%edi),%%eax\n"        /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp7-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch ->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp7:\n"
		"    movl %%edx, %%ecx\n"
		"    shrl $19, %%ecx\n"
		"    movb 1(%%esi,%%esi), %%cl\n"
		"    movl 1234(,%%ecx,4), %%ebx\n"
		"int07:\n"
		"    movb 3(%%esi,%%esi), %%cl\n"
		"    addl 1234(,%%ecx,4), %%ebx\n"
		"int17:\n"
		"    movzbl %%bh, %%ecx\n"
		"    movzbl %%bl, %%ebx\n"

		"    addl $1234, %%edx\n"
		"edx7:\n"
		"    movl 1234(,%%ecx,4), %%eax\n"
		"vol17:\n"
		"    adcl $1234, %%esi\n"
		"ebp7:\n"
		"    addl 1234(,%%ebx,4), %%eax\n"
		"vol27:\n"
		"    addl %%eax, (%%edi)\n"
		"    addl $4, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp7\n"

		"done7:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playodd:\n"
		"  cmpl $0, interpolate\n"
		"  jnz playoddi\n"

		"  cmpl $0, play16bit\n"
		"  jnz playodd16\n"

		"  cmpl $0, play32bit\n"
		"  jnz done8\n" /* !! */

		"  cmpl $0, %%ebp\n"
		"  je done8\n"

		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol18-4)\n"
		"  movl voltabs+4, %%eax\n"
		"  movl %%eax, (vol28-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx8-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp8-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi),%%esi\n"        /*  %2 = ch->pos */
		"  addl %3(%%edi),%%esi\n"        /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp8:\n"
		"  movb (%%esi), %%bl\n"
		"  addl $1234, %%edx\n"
		"edx8:\n"
		"  movw 1234(,%%ebx,4), %%ax\n"
		"vol18:\n"
		"  adcl $1234, %%esi\n"
		"ebp8:\n"
		"  addl %%eax, (%%edi)\n"
		"  movw 1234(,%%ebx,4), %%ax\n"
		"vol28:\n"
		"  addl %%eax, 4(%%edi)\n"
		"  addl $8, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp8\n"

		"done8:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playodd16:\n"
		"  cmpl $0, %%ebp\n"
		"  je done9\n"

		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol19-4)\n"
		"  movl voltabs+4, %%eax\n"
		"  movl %%eax, (vol29-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx9-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp9-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp9:\n"
		"  movb 1(%%esi,%%esi), %%bl\n"
		"  addl $1234, %%edx\n"
		"edx9:\n"
		"  movl 1234(,%%ebx,4), %%eax\n"
		"vol19:\n"
		"  adcl $1234, %%esi\n"
		"ebp9:\n"
		"  addl %%eax, (%%edi)\n"
		"  movw 1234(,%%ebx,4), %%ax\n"
		"vol29:\n"
		"  addl %%eax, 4(%%edi)\n"
		"  addl $8, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp9\n"

		"done9:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */

	);

	__asm__ __volatile__
	(
		"playoddi:\n"
		"  cmpl $0, render16bit\n"
		"  jnz playoddir\n"

		"  cmpl $0, play16bit\n"
		"  jnz playoddi16\n"

		"  cmpl $0, play32bit\n"
		"  jnz done10\n"  /* !! */

		"  cmpl $0, %%ebp\n"
		"  je done10\n"

		"  movl mixIntrpolTab, %%eax\n"
		"  movl %%eax, (int010-4)\n"
		"  incl %%eax\n"
		"  movl %%eax, (int110-4)\n"
		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol110-4)\n"
		"  movl voltabs+4, %%eax\n"
		"  movl %%eax, (vol210-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx10-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp10-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp10:\n"
		"  movl %%edx, %%ecx\n"
		"  shrl $20, %%ecx\n"
		"  movb (%%esi), %%cl\n"
		"  movb 1234(%%ecx,%%ecx),%%bl\n"
		"int010:\n"
		"  movb 1(%%esi), %%cl\n"
		"  addb 1234(%%ecx,%%ecx),%%bl\n"
		"int110:\n"

		"  addl $1234, %%edx\n"
		"edx10:\n"
		"  movl 1234(,%%ebx,4), %%eax\n"
		"vol110:\n"
		"  adc $1234, %%esi\n"
		"ebp10:\n"
		"  addl %%eax, (%%edi)\n"
		"  movl 1234(,%%ebx,4), %%eax\n"
		"vol210:\n"
		"  addl %%eax, 4(%%edi)\n"
		"  addl $8, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp10\n"

		"done10:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playoddi16:\n"
		"  cmpl $0, %%ebp\n"
		"  je done11\n"

		"  movl mixIntrpolTab, %%eax\n"
		"  movl %%eax, (int011-4)\n"
		"  incl %%eax\n"
		"  movl %%eax, (int111-4)\n"
		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol111-4)\n"
		"  movl voltabs+4, %%eax\n"
		"  movl %%eax, (vol211-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx11-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp11-4)\n"

		"  movw %1(%%edi),%%dx\n"         /*  %1 = ch->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp11:\n"
		"  movl %%edx, %%ecx\n"
		"  shrl $20, %%ecx\n"
		"  movb 1(%%esi,%%esi), %%cl\n"
		"  movb 1234(%%ecx, %%ecx), %%bl\n"
		"int011:\n"
		"  movb 3(%%esi,%%esi), %%cl\n"
		"  addb 1234(%%ecx, %%ecx), %%bl\n"
		"int111:\n"

		"  addl $1234, %%edx\n"
		"edx11:\n"
		"  movl 1234(,%%ebx,4), %%eax\n"
		"vol111:\n"
		"  adcl $1234, %%esi\n"
		"ebp11:\n"
		"  addl %%eax, (%%edi)\n"
		"  movl 1234(,%%ebx,4), %%eax\n"
		"vol211:\n"
		"  addl %%eax, 4(%%edi)\n"
		"  addl $8, %%edi\n"
		"  decl %%ebp\n"
		"  jnz lp11\n"

		"done11:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playoddir:"
		"  cmpl $0, play16bit\n"
		"  jne playoddi16r\n"

		"  cmpl $0, play32bit\n"
		"  jne done12\n"

		"  cmpl $0, %%ebp\n"
		"  je done12\n"

		"  movl mixIntrpolTab2, %%eax\n"
		"  movl %%eax, (int012-4)\n"
		"  addl $2, %%eax\n"
		"  movl %%eax, (int112-4)\n"
		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol112-4)\n"
		"  addl $1024, %%eax\n"
		"  movl %%eax, (vol1b12-4)\n"
		"  movl voltabs+4, %%eax\n"
		"  movl %%eax, (vol212-4)\n"
		"  addl $1024, %%eax\n"
		"  movl %%eax, (vol2b12-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx12-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp12-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->->fpos */
		"  shll $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ecx, %%ebx\n"

		"lp12:"
		"  movl %%edx, %%ecx\n"
		"  shrl $19, %%ecx\n"
		"  movb (%%esi), %%cl\n"
		"  movl 1234(,%%ecx, 4), %%ebx\n"
		"int012:\n"
		"  movb 1(%%esi), %%cl\n"
		"  addl 1234(,%%ecx,4), %%ebx\n"
		"int112:\n"
		"  movzbl %%bh, %%ecx\n"
		"  movzbl %%bl, %%ebx\n"

		"  addl $1234, %%edx\n"
		"edx12:\n"
		"  movl 1234(,%%ecx,4), %%eax\n"
		"vol112:\n"
		"  adcl $1234, %%esi\n"
		"ebp12:\n"
		"  addl 1234(,%%ebx,4),%%eax\n"
		"vol1b12:\n"
		"  addl %%eax, (%%edi)\n"
		"  movl 1234(,%%ecx, 4), %%eax\n"
		"vol212:\n"
		"  addl 1234(,%%ebx,4), %%eax\n"
		"vol2b12:\n"
		"  addl %%eax, 4(%%edi)\n"
		"  addl $8, %%edi\n"
		"  decl %%ebp\n"
		"  jne lp12\n"

		"done12:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0  */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

	__asm__ __volatile__
	(
		"playoddi16r:\n"
		"  cmp $0, %%ebp\n"
		"  je done13\n"

		"  movl mixIntrpolTab2, %%eax\n"
		"  movl %%eax, (int013-4)\n"
		"  addl $2, %%eax\n"
		"  movl %%eax, (int113-4)\n"
		"  movl voltabs+0, %%eax\n"
		"  movl %%eax, (vol113-4)\n"
		"  addl $1024, %%eax\n"
		"  movl %%eax, (vol1b13-4)\n"
		"  movl voltabs+4, %%eax\n"
		"  movl %%eax, (vol213-4)\n"
		"  addl $1024, %%eax\n"
		"  movl %%eax, (vol2b13-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  shll $16, %%eax\n"
		"  movl %%eax, (edx13-4)\n"
		"  movl %0(%%edi), %%eax\n"       /*  %0 = ch->step */
		"  sarl $16, %%eax\n"
		"  movl %%eax, (ebp13-4)\n"

		"  movw %1(%%edi), %%dx\n"        /*  %1 = ch->fpos */
		"  shl $16, %%edx\n"
		"  movl %2(%%edi), %%esi\n"       /*  %2 = ch->pos */
		"  addl %3(%%edi), %%esi\n"       /*  %3 = ch->samp */
		"  movl %%ecx, %%edi\n"
		"  xorl %%ebx, %%ebx\n"

		"lp13:\n"
		"  movl %%edx, %%ecx\n"
		"  shrl $19, %%ecx\n"
		"  movb 1(%%esi,%%esi), %%cl\n"
		"  movl 1234(,%%ecx,4), %%ebx\n"
		"int013:\n"
		"  movb 3(%%esi,%%esi), %%cl\n"
		"  add 1234(,%%ecx,4), %%ebx\n"
		"int113:\n"
		"  movzbl %%bh, %%ecx\n"
		"  movzbl %%bl, %%ebx\n"

		"  addl $1234, %%edx\n"
		"edx13:\n"
		"  movl 1234(,%%ecx,4), %%eax\n"
		"vol113:\n"
		"  adcl $1234, %%esi\n"
		"ebp13:\n"
		"  addl 1234(,%%ecx,4), %%eax\n"
		"vol1b13:\n"
		"  add %%eax, (%%edi)\n"
		"  movl 1234(,%%ecx,4), %%eax\n"
		"vol213:\n"
		"  addl 1234(,%%ecx,4), %%eax\n"
		"vol2b13:\n"
		"  add %%eax, 4(%%edi)\n"
		"  add $8, %%edi\n"
		"  dec %%ebp\n"
		"  jnz lp13\n"

		"done13:\n"
		"  ret\n"
		:
		: "m" (((struct mixchannel *)NULL)->step), /*  0 */
		  "m" (((struct mixchannel *)NULL)->fpos), /*  1  */
		  "m" (((struct mixchannel *)NULL)->pos),  /*  2  */
		  "m" (((struct mixchannel *)NULL)->samp)  /*  3  */
	);

}

unsigned long mixAddAbs(const struct mixchannel *ch, unsigned long len)
{
	int d0, d1;
#ifdef __PIC__
	int ebx;
#endif
	register unsigned long retval;
	__asm__ __volatile__
	(
#ifdef __PIC__
	 	"movl %%ebx, %10\n"
#endif
		"  testb $MIX_PLAY16BIT, %3(%%eax)\n"
		                                  /*  %3 = ch->status */
		"  jnz mixAddAbs_16bit\n"
		"  testb $MIX_PLAY32BIT, %3(%%eax)\n"
		                                  /*  %3 = ch->status */
		"  jnz mixAddAbs_32bit\n"

		"  movl %4(%%eax), %%edx\n"       /*  %4 = ch->replen */
		"  movl %5(%%eax), %%esi\n"       /*  %5 = ch->pos */
		"  addl %6(%%eax), %%esi\n"       /*  %6 = ch->samp */
		"  movl %7(%%eax), %%ebx\n"       /*  %7 = ch->length */
		"  addl %6(%%eax), %%ebx\n"       /*  %6 = ch->samp */
/* eax = ch
 * edi = target len
 * 
 * edx = replen
 * esi = current pos in sample (effecient pointer)
 * ebx = end (effecient pointer)
 */
		"  addl %%esi, %%edi\n"
/* edi = ETA end (effecient pointer)
 * 
 * eax = ch
 * edx = replen
 * esi = current pos in sample (effecient pointer)
 * ebx = end (effecient pointer)
 */
		"  xorl %%ecx, %%ecx\n"
/* ecx/retval = 0
 *
 * edi = ETA end (effecient pointer)
 * ebx = end (effecient pointer)
 * eax = ch
 * edx = replen
 * esi = current pos in sample (effecient pointer)
 */
		"mixAddAbs_bigloop:\n"

		"    pushl %%edi\n"
/* store edi for later */

		"    cmpl %%ebx, %%edi\n"
		"    ja mixAddAbs_less\n"
/* do we hit end before eta? */
		"      xorl %%edx, %%edx\n"


/* remove replen if so*/
		"    jmp mixAddAbs_loop\n"
		"  mixAddAbs_less:\n"
		"    movl %%ebx, %%edi\n"
/* set eta to end (so we don't go past end) */
		"  jmp mixAddAbs_loop\n"

/* Entering loop:
 *
 * edx = 0 if ETA > end, else edx = replen
 * edi = ETA (pushed up the end if underrun), efficent pointer

 * ecx/retval = 0
 * ebx = end (effecient pointer)
 * eax = ch
 * esi = current pos in sample (effecient pointer)
 */
		"  mixAddAbs_neg:\n"
		"    subl %%eax, %%ecx\n"
		"    cmpl %%edi, %%esi\n"
		"    jae mixAddAbs_loopend\n"
		"  mixAddAbs_loop:\n"
		"      movsbl (%%esi), %%eax\n"
		"      incl %%esi\n"
		"      xorl $0xffffff80, %%eax\n"
		"      js mixAddAbs_neg\n"
		"      addl %%eax, %%ecx\n"
		"    cmpl %%edi, %%esi\n"
		"    jb mixAddAbs_loop\n"
		"  mixAddAbs_loopend:\n"
		"    popl %%edi\n"
		"    cmpl $0, %%edx\n"
		"    je mixAddAbs_exit\n"
		"    subl %%edx, %%edi\n"
		"    subl %%edx, %%esi\n"
		"  jmp mixAddAbs_bigloop\n"

		"mixAddAbs_16bit:\n"
		"  movl %4(%%eax), %%edx\n"       /*  %4 = ch->replen */
		"  movl %5(%%eax), %%esi\n"       /*  %5 = ch->pos */
		"  addl %6(%%eax), %%esi\n"       /*  %6 = ch->samp */
		"  movl %7(%%eax), %%ebx\n"       /*  %7 = ch->length */
		"  addl %6(%%eax), %%ebx\n"       /*  %6 = ch->samp */
		"  addl %%esi, %%edi\n"
		"  xorl %%ecx, %%ecx\n"
		"mixAddAbs_16bigloop:\n"
		"    pushl %%edi\n"
		"    cmpl %%ebx, %%edi\n"
		"    ja mixAddAbs_16less\n"
		"      xorl %%edx, %%edx\n"
		"    jmp mixAddAbs_16loop\n"
		"  mixAddAbs_16less:\n"
		"    movl %%ebx, %%edi\n"
		"  jmp mixAddAbs_16loop\n"

		"  mixAddAbs_16neg:\n"
		"      subl %%eax, %%ecx\n"
		"    cmpl %%edi, %%esi\n"
		"    jae mixAddAbs_16loopend\n"
		"  mixAddAbs_16loop:\n"
		"      movsbl 1(%%esi,%%esi), %%eax\n"
		"      incl %%esi\n"
		"      xorl $0xffffff80, %%eax\n"
		"      js mixAddAbs_16neg\n"
		"      addl %%eax, %%ecx\n"
		"    cmpl %%edi, %%esi\n"
		"    jb mixAddAbs_16loop\n"
		"  mixAddAbs_16loopend:\n"
		"    popl %%edi\n"
		"    cmpl $0, %%edx\n"
		"    je mixAddAbs_exit\n"
		"    subl %%edx, %%edi\n"
		"    subl %%edx, %%esi\n"
		"  jmp mixAddAbs_16bigloop\n"

		"mixAddAbs_32bit:\n"
		"  movl %4(%%eax), %%edx\n"       /*  %4 = ch->replen*/
		"  movl %5(%%eax), %%esi\n"       /*  %5 = ch->pos */
		"  addl %6(%%eax), %%esi\n"       /*  %6 = ch->samp */
		"  movl %7(%%eax), %%ebx\n"       /*  %7 = ch->length */
		"  addl %6(%%eax), %%ebx\n"       /*  %6 = ch->samp */
		"  addl %%esi, %%edi\n"
		"  xorl %%ecx, %%ecx\n"
		"mixAddAbs_32bigloop:\n"
		"    pushl %%edi\n"
		"    cmpl %%ebx, %%edi\n"
		"    ja mixAddAbs_32less\n"
		"      xorl %%edx, %%edx\n"
		"    jmp mixAddAbs_32loop\n"
		"  mixAddAbs_32less:\n"
		"    movl %%ebx, %%edi\n"
		"  jmp mixAddAbs_32loop\n"

		"  mixAddAbs_32neg:\n"
		"    subl %%eax, %%ecx\n"
		"    cmpl %%edi, %%esi\n"
		"    jae mixAddAbs_32loopend\n"
		"  mixAddAbs_32loop:\n"
		"      flds (,%%esi,4)\n"
		"      fistps integer\n"
		"      movl integer, %%eax\n"
		"      incl %%esi\n"
		"      xorl $0xffffff80, %%eax\n"
		"      js mixAddAbs_32neg\n"
		"      addl %%eax, %%ecx\n"
		"    cmpl %%edi, %%esi\n"
		"    jb mixAddAbs_32loop\n"
		"  mixAddAbs_32loopend:\n"
		"    popl %%edi\n"
		"    cmpl $0, %%edx\n"
		"    je mixAddAbs_exit\n"
		"    subl %%edx, %%edi\n"
		"    subl %%edx, %%esi\n"
		"  jmp mixAddAbs_32bigloop\n"

		"mixAddAbs_exit:\n"
#ifdef __PIC__
	 	"movl %10, %%ebx\n"

#endif
		: "=c"  (retval),                            /*   0  */
		  "=&a" (d0),                                /*   1  */
		  "=&D" (d1)                                 /*   2  */
		: "m" (((struct mixchannel *)NULL)->status), /*   3  */
		  "m" (((struct mixchannel *)NULL)->replen), /*   4  */
		  "m" (((struct mixchannel *)NULL)->pos),    /*   5  */
		  "m" (((struct mixchannel *)NULL)->samp),   /*   6  */
		  "m" (((struct mixchannel *)NULL)->length), /*   7  */
		  "1" (ch),
		  "2" (len)
#ifdef __PIC__
		  ,"m"(ebx)
#endif

		: "memory", "edx", "esi"
	);
	return retval;
}

void mixClip(void *dst, const long *src, unsigned long len, short (*tab)[256], long max)
{ /* does saturation of some sort.. needs to read the code when I'm not sleepy */
	int d0, d1, d2, d3, d4;
	__asm__ __volatile__
	(
#ifdef __PIC__
	 	"  pushl %%ebx\n" /* EBX is pic register */
#endif
		"  movl %%eax, %%ebx\n"
		
		"  movl %%ebx, (amp1-4)\n"
		"  addl $512, %%ebx\n"
		"  movl %%ebx, (amp2-4)\n"
		"  addl $512, %%ebx\n"
		"  movl %%ebx, (amp3-4)\n"
		"  subl $1024, %%ebx\n"
		"  movl %%edx, (max-4)\n"
		"  negl %%edx\n"
		"  movl %%edx, (min-4)\n"

		"  xorl %%edx, %%edx\n"
		"  movb (min-4), %%dl\n"
		"  movl (%%ebx,%%edx,2), %%eax\n"
		"  movb (min-3), %%dl\n"
		"  addl 512(%%ebx,%%edx,2), %%eax\n"
		"  movb (min-2), %%dl\n"
		"  addl 1024(%%ebx,%%edx,2), %%eax\n"
		"  movw %%ax, (minv-2)\n"
		"  movb (max-4), %%dl\n"
		"  movl (%%ebx,%%edx,2), %%eax\n"
		"  movb (max-3), %%dl\n"
		"  addl 512(%%ebx,%%edx,2), %%eax\n"
		"  movb (max-2), %%dl\n"
		"  addl 1024(%%ebx,%%edx,2), %%eax\n"
		"  movw %%ax, (maxv-2)\n"
		"  leal (%%edi,%%ecx,2), %%ecx\n"
		"  movl %%ecx,(endp1-4)\n"
		"  movl %%ecx,(endp2-4)\n"
		"  movl %%ecx,(endp3-4)\n"
		"  xorl %%ebx, %%ebx\n"
		"  xorl %%ecx, %%ecx\n"
		"  xorl %%edx, %%edx\n"

		"mixlp:\n"
		"  cmpl $1234, (%%esi)\n"
		"min:\n"
		"  jl low\n"
		"  cmpl $1234, (%%esi)\n"
		"max:\n"
		"  jg high\n"

		"  movb (%%esi), %%bl\n"
		"  movb 1(%%esi), %%cl\n"
		"  movb 2(%%esi), %%dl\n"
		"  movl 1234(,%%ebx,2), %%eax\n"
		"amp1:\n"
		"  addl 1234(,%%ecx,2), %%eax\n"
		"amp2:\n"
		"  addl 1234(,%%edx,2), %%eax\n"
		"amp3:\n"
		"  movw %%ax, (%%edi)\n"
		"  addl $2, %%edi\n"
		"  addl $4, %%esi\n"
		"  cmpl $1234, %%edi\n"
		"endp1:\n"
		"  jb mixlp\n"
		"  jmp done\n" /* done: ret pair used to be close here.. but we might need frame-adjust and shit like that */

		"low:\n"
		"  movw $1234, (%%edi)\n"
		"minv:\n"
		"  addl $2, %%edi\n"
		"  addl $4, %%esi\n"
		"  cmpl $1234, %%edi\n"
		"endp2:\n"
		"  jb mixlp\n"
		"  jmp done\n"

		"high:\n"
		"  movw $1234, (%%edi)\n"
		"maxv:\n"
		"  addl $2, %%edi\n"
		"  addl $4, %%esi\n"
		"  cmpl $1234, %%edi\n"
		"endp3:\n"
		"  jb mixlp\n"
/*		"  jmp done\n" */

		"done:\n"
#ifdef __PIC__
		"popl %%ebx\n"
#endif
		: "=&D"(d0),
		  "=&S"(d1),
		  "=&c"(d2),
		  "=&a"(d3),
		  "=&d"(d4)
		: "0" (dst),
		  "1" (src),
		  "2" (len),
		  "3" (tab),
		  "4" (max)
#ifdef __PIC__
		: "memory"
#else
		: "memory", "ebx"
#endif
		
	);
}

void mixasm_remap_stop(void){}

#else

static void playmono16(uint32_t len, struct channel *ch)
{
	if (!len)
		return;
}

static void playmono32(uint32_t len, struct channel *ch)
{
	if (!len)
		return;
}

static void playmonoi16r(uint32_t len, struct channel *ch)
{
	if (!len)
		return;
}

static void playmonoir(uint32_t len, struct channel *ch)
{
	if (play16bit)
	{
		playmonoi16r(len, ch);
		return;
	}
	if (play32bit)
	{
		playmono32(len, ch);
		return;
	}
	if (!len)
		return;
}

static void playmonoi16(uint32_t len, struct channel *ch)
{
	if (!len)
		return;
}

static void playmonoi(uint32_t len, struct channel *ch)
{
	if (render16bit)
	{
		playmonoir(len, ch);
		return;
	}
	if (play16bit)
	{
		playmonoi16(len, ch);
		return;
	}
	if (play32bit)
	{
		playmono32(len, ch);
		return;
	}
	if (!len)
		return;
}
static void playmono(uint32_t len, struct channel *ch)
{
	if (interpolate)
	{
		playmonoi(len, ch);
		return;
	}
	if (play16bit)
	{
		playmono16(len, ch);
		return;
	}
	if (play32bit)
	{
		playmono32(len, ch);
		return;
	}
	if (!len)
		return;
}



/* PLAYODD IS NEXT TODO TODO TODO TODO TODO_ASM */





/*#pragma aux mixPlayChannel parm [] caller modify [eax ebx ecx edx esi edi]*/
void mixPlayChannel(long *buf, unsigned long len, struct mixchannel *ch, char stereo)
{
	char inloop;
	interpolate=0;
	play16bit=0;
	play32bit=0;
	render16bit=0;
/*
public mixPlayChannel_
mixPlayChannel_ proc buf:dword, len:dword, chan:dword, stereo:dword
local inloop:byte
  mov interpolate,0
  mov play16bit,0
  mov play32bit,0
  mov render16bit,0
*/
	if (!(chan->status&MCP_PLAYING))
		goto exit;
	if (chan->status&MCP_INTERPOLATE)
	{
		interpolate=1;
		if (chan->MCP_MAX)
			render16bit=1;
	}
/*
  mov edi,chan
  test [edi].chstatus,MCP_PLAYING
  jz @@exit
  test [edi].chstatus,MCP_INTERPOLATE
  jz @@nointr
    mov interpolate,1
    test [edi].chstatus,MCP_MAX
    jz @@nointr
      mov render16bit,1
@@nointr:
*/
	if (chan->status&MCP_PLAY16BIT)
		play16bit=1;
	if (chan->status&MCP_PLAY32BIT)
		play32bit=1;
/*	
  test [edi].chstatus,MCP_PLAY16BIT
  jz @@no16bit
    mov play16bit,1
@@no16bit:
  test [edi].chstatus,MCP_PLAY32BIT
  jz @@no32bit
    mov play32bit,1
@@no32bit:
*/
	if (stereo)
	{
		voltabs[0]=chan->vol.tabs[0];
		voltabs[1]=chan->vol.tabs[1];
		playrout=playodd;
	} else {
		voltabs[0]=chan->vol.tabs[0];
		playrout=playmono;
	}
/*
  cmp stereo,0
  jne @@pstereo

@@pmono:
  mov eax,[edi].chvoltabs[0]
  mov voltabs[0],eax
  mov playrout,offset playmono
  jmp @@bigloop

@@pstereo:
  mov eax,[edi].chvoltabs[0]
  mov ebx,[edi].chvoltabs[4]
  mov voltabs[0],eax
  mov voltabs[4],ebx
  mov playrout,offset playodd
*/
	while(len)
	{
		signed long step=chan->step;
		unsigned long pos=chan->pos;
		unsigned short fpos=chan->fpos;

		signed long eax, ecx; /* RENAME RENAME RENAME */
		/* ebx=chan->step*/
		/* edx=chan->pos*/
		/* si=chan->fpos*/
		ecx=len;
		inloop=0;
		if (!step)
			goto playecx;
		else (step>0)
			goto forward;
/*
@@bigloop:
  mov ecx,len
  mov ebx,[edi].chstep
  mov edx,[edi].chpos
  mov si,[edi].chfpos
  mov inloop,0
  cmp ebx,0

  je @@playecx
  jg @@forward
*/		
		step^=(signed long)0xffffffff;
		eax=pos;
		if (!chan->status&MCP_LOOPED)
			goto maxplaylen;
		if (chan->pos<chan-loopstart)
			goto maxplaylen;
		eax-=chan->loopstart;
		inloop=1;
		goto maxplaylen;
/*		
    neg ebx
    mov eax,edx
    test [edi].chstatus,MCP_LOOPED
    jz @@maxplaylen
    cmp edx,[edi].chloopstart
    jb @@maxplaylen
    sub eax,[edi].chloopstart
    mov inloop,1
    jmp @@maxplaylen*/
forward:
		eax=chan->length;
		fpos^=(unsigned short)0xffff;
		eax-=chan->pos;
		if (!chan->status&MCP_LOOPED)
			goto maxplaylen;
		if (pos>=chan->loopend)
			goto maxplaylen;
		eax-=chan->length;
		eax+=chan->loopend;
		inloop=1;
/*
@@forward:
    mov eax,[edi].chlength
    neg si
    sbb eax,edx
    test [edi].chstatus,MCP_LOOPED
    jz @@maxplaylen
    cmp edx,[edi].chloopend
    jae @@maxplaylen
    sub eax,[edi].chlength
    add eax,[edi].chloopend
    mov inloop,1
*/
maxplaylen:
		{
			long long _bigcalc=((eax<<16)&fpos)+step-1;
			if ((_bigcalc>>32)>step)
				_bigcalc/=step;
			if (_bigcalc&0xffffffff<ecx)
				goto playecx;
			if (inloop)
			{
				ecx=_bigcalc&0xffffffff;
				chan->status&=(0xffffffff^MCP_PLAYING);
			}
/*
@@maxplaylen:
  xor edx,edx
  shld edx,eax,16
  shl esi,16
  shld eax,esi,16
  add eax,ebx
  adc edx,0
  sub eax,1
  sbb edx,0
  cmp edx,ebx
  
  jae @@playecx
  div ebx
  cmp ecx,eax
  jb @@playecx
    mov ecx,eax
    cmp inloop,0
    jnz @@playecx
      and [edi].chstatus,not MCP_PLAYING
      mov len,ecx
*/
playecx:
			playrout(buf, chan, &len);
/*			
@@playecx:
  push ebp
  push edi
  push ecx
  mov eax,ecx
  mov ecx,buf
  mov ebp,eax

  call playrout

  pop ecx
  pop edi
  pop ebp
*/
			eax=len<<2;
			if (stereo)
				eax<<1;
/*			
  mov eax,ecx
  shl eax,2
  cmp stereo,0
  je @@m2
    shl eax,1
@@m2:*/
			buf+=eax;
			len-=
  add buf,eax
  sub len,ecx

  mov eax,[edi].chstep
  imul ecx
  shld edx,eax,16
  add [edi].chfpos,ax
  adc [edi].chpos,edx
  mov eax,[edi].chpos

  cmp inloop,0
  jz @@exit

  cmp [edi].chstep,0
  jge @@forward2
    cmp eax,[edi].chloopstart
    jge @@exit
    test [edi].chstatus,MCP_PINGPONGLOOP
    jnz @@pong
      add eax,[edi].chreplen
      jmp @@loopiflen
    @@pong:
      neg [edi].chstep
      neg [edi].chfpos
      adc eax,0
      neg eax
      add eax,[edi].chloopstart
      add eax,[edi].chloopstart
      jmp @@loopiflen
@@forward2:
    cmp eax,[edi].chloopend
    jb @@exit
    test [edi].chstatus,MCP_PINGPONGLOOP
    jnz @@ping
      sub eax,[edi].chreplen
      jmp @@loopiflen
    @@ping:
      neg [edi].chstep
      neg [edi].chfpos
      adc eax,0
      neg eax
      add eax,[edi].chloopend
      add eax,[edi].chloopend

@@loopiflen:
  mov [edi].chpos,eax
  cmp len,0
  jne @@bigloop

exit:
/*
@@exit:
  ret
endp
*/
}

;//*************************************************************************

void mixClip(void *dst, const long *src, unsigned long len, short (*tab)[256], long max)
{
/*#pragma aux mixClip parm [edi] [esi] [ecx] [ebx] [edx] modify [eax]*/

public mixClip_
mixClip_ proc ;//esi=src, edi=dst, ebx=tab, ecx=len, edx=max
  mov @@amp1,ebx
  add ebx,512
  mov @@amp2,ebx
  add ebx,512
  mov @@amp3,ebx
  sub ebx,1024
  mov @@max,edx
  neg edx
  mov @@min,edx

  xor edx,edx
  mov dl,byte ptr @@min
  mov eax,[ebx+2*edx]
  mov dl,byte ptr @@min+1
  add eax,[ebx+512+2*edx]
  mov dl,byte ptr @@min+2
  add eax,[ebx+1024+2*edx]
  mov @@minv,ax
  mov dl,byte ptr @@max
  mov eax,[ebx+2*edx]
  mov dl,byte ptr @@max+1
  add eax,[ebx+512+2*edx]
  mov dl,byte ptr @@max+2
  add eax,[ebx+1024+2*edx]
  mov @@maxv,ax
  lea ecx,[2*ecx+edi]
  mov @@endp1,ecx
  mov @@endp2,ecx
  mov @@endp3,ecx
  xor ebx,ebx
  xor ecx,ecx
  xor edx,edx

@@lp:
    cmp dword ptr [esi],1234
      argdd @@min
    jl @@low
    cmp dword ptr [esi],1234
      argdd @@max
    jg @@high

    mov bl,[esi]
    mov cl,[esi+1]
    mov dl,[esi+2]
    mov eax,[2*ebx+1234]
      argdd @@amp1
    add eax,[2*ecx+1234]
      argdd @@amp2
    add eax,[2*edx+1234]
      argdd @@amp3
    mov [edi],ax
    add edi,2
    add esi,4
  cmp edi,1234
    argdd @@endp1
  jb @@lp
@@done:
  ret

@@low:
    mov word ptr [edi],1234
      argdw @@minv
    add edi,2
    add esi,4
  cmp edi,1234
    argdd @@endp2
  jb @@lp
  jmp @@done
@@high:
    mov word ptr [edi],1234
      argdw @@maxv
    add edi,2
    add esi,4
  cmp edi,1234
    argdd @@endp3
  jb @@lp
  jmp @@done
endp


;//*************************************************************************

unsigned long mixAddAbs(const struct mixchannel *ch, unsigned long len)
{
	unsigned long retval=0; /* ecx */
	
	if (chan->status&MCP_PLAY16BIT)
	{
		int replen=chan->replen;
		short *pos=chan->samp+chan->chpos; /* actual position */
		short *end=chan->samp+chan->length; /* actual EOS */
		short *target=pos+len; /* target EOS */
		while(1)
		{
			signed short *_temptarget=target;
			if (_temptarget>end)
			{
				replen=0;
			} else {
				_temptarget=end;
			}
			do {
				signed int sample;
				sample=*pos++;
				if (sample<0)
				{
					sample=0-sample;
				}
				retval+=sample;
			} while (pos<_temptarget);

			if (!replen)
				goto exit;
			target-=replen;
			pos-=replen;
		}
	
	} else if (chan->status&MCP_PLAY32BIT)
	{
		int replen=chan->replen;
		int *pos=chan->samp+chan->chpos; /* actual position */
		int *end=chan->samp+chan->length; /* actual EOS */
		int *target=pos+len; /* target EOS */
		while(1)
		{
			char *_temptarget=target;
			if (_temptarget>end)
			{
				replen=0;
			} else {
				_temptarget=end;
			}
			do {
				signed int sample;
				sample=*pos++;
				if (sample<0)
				{
					sample=0-sample;
				}
				retval+=sample;
			} while (pos<_temptarget);

			if (!replen)
				goto exit;
			target-=replen;
			pos-=replen;
		}

	} else { /* 8 bit*/
		int replen=chan->replen;
		char *pos=chan->samp+chan->chpos; /* actual position */
		char *end=chan->samp+chan->length; /* actual EOS */
		char *target=pos+len; /* target EOS */
		while(1)
		{
			char *_temptarget=target;
			if (_temptarget>end)
			{
				replen=0;
			} else {
				_temptarget=end;
			}
			do {
				signed int sample;
				sample=*pos++;
				if (sample<0)
				{
					sample=0-sample;
				}
				retval+=sample;
			} while (pos<_temptarget);

			if (!replen)
				goto exit;
			target-=replen;
			pos-=replen;
		}
	}
exit:
	return;
}

.data
integer dd ?
scale   dd ?
gscale  dd 64.0
minuseins dd -1.9
end


#endif
