// Created on: 1997-02-10
// Created by: Odile Olivier
// Copyright (c) 1997-1999 Matra Datavision
// Copyright (c) 1999-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.


#include <DsgPrs_XYZPlanePresentation.ixx>
#include <Prs3d_Root.hxx>
#include <Prs3d_PlaneAspect.hxx>
#include <Prs3d_LineAspect.hxx>
#include <Graphic3d_Group.hxx>
#include <Graphic3d_Array1OfVertex.hxx>


//=======================================================================
//function : Add
//purpose  : 
//=======================================================================

void DsgPrs_XYZPlanePresentation::Add(
		       const Handle(Prs3d_Presentation)& aPresentation,
		       const Handle(Prs3d_Drawer)& aDrawer,	     
		       const gp_Pnt& aPt1, 
		       const gp_Pnt& aPt2,
		       const gp_Pnt& aPt3)
{


 Handle(Graphic3d_Group) TheGroup = Prs3d_Root::CurrentGroup(aPresentation);
 TheGroup->SetPrimitivesAspect(aDrawer->PlaneAspect()->EdgesAspect()->Aspect());

 Quantity_Length x1,y1,z1,x2,y2,z2,x3,y3,z3;
  
 aPt1.Coord(x1,y1,z1);
 aPt2.Coord(x2,y2,z2);
 aPt3.Coord(x3,y3,z3);
 
 Graphic3d_Array1OfVertex A(1,4);
 A(1).SetCoord(x1,y1,z1);
 A(2).SetCoord(x2,y2,z2);
 A(3).SetCoord(x3,y3,z3);
 A(4).SetCoord(x1,y1,z1);
 
 TheGroup->Polyline(A);

}
