// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Xw_Window_HeaderFile
#define _Xw_Window_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Xw_Window_HeaderFile
#include <Handle_Xw_Window.hxx>
#endif

#ifndef _Xw_WindowQuality_HeaderFile
#include <Xw_WindowQuality.hxx>
#endif
#ifndef _Handle_Xw_ColorMap_HeaderFile
#include <Handle_Xw_ColorMap.hxx>
#endif
#ifndef _Handle_Xw_TypeMap_HeaderFile
#include <Handle_Xw_TypeMap.hxx>
#endif
#ifndef _Handle_Xw_WidthMap_HeaderFile
#include <Handle_Xw_WidthMap.hxx>
#endif
#ifndef _Handle_Xw_FontMap_HeaderFile
#include <Handle_Xw_FontMap.hxx>
#endif
#ifndef _Handle_Xw_MarkMap_HeaderFile
#include <Handle_Xw_MarkMap.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
#ifndef _Xw_TypeOfVisual_HeaderFile
#include <Xw_TypeOfVisual.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Aspect_Window_HeaderFile
#include <Aspect_Window.hxx>
#endif
#ifndef _Handle_Xw_GraphicDevice_HeaderFile
#include <Handle_Xw_GraphicDevice.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Aspect_FillMethod_HeaderFile
#include <Aspect_FillMethod.hxx>
#endif
#ifndef _Aspect_GradientFillMethod_HeaderFile
#include <Aspect_GradientFillMethod.hxx>
#endif
#ifndef _Aspect_TypeOfResize_HeaderFile
#include <Aspect_TypeOfResize.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Image_PixMap_HeaderFile
#include <Image_PixMap.hxx>
#endif
#ifndef _Quantity_Ratio_HeaderFile
#include <Quantity_Ratio.hxx>
#endif
class Xw_ColorMap;
class Xw_TypeMap;
class Xw_WidthMap;
class Xw_FontMap;
class Xw_MarkMap;
class Aspect_WindowDefinitionError;
class Aspect_WindowError;
class Xw_Driver;
class Xw_IconBox;
class Xw_GraphicDevice;
class Aspect_Background;
class Quantity_Color;
class Aspect_GradientBackground;


//! This class defines a X11 window <br>
//!  Warning: The position and size for the creation of the window <br>
//!      are defined in Device Screen Unit (DSU) <br>
//!      floating [0,1] space. <br>
class Xw_Window : public Aspect_Window {

public:

  
  Standard_EXPORT   Xw_Window(const Handle(Xw_GraphicDevice)& Device);
  //! Creates a Window from an X Window defined by his ID <br>
//!      This Xid equals (aPart1 << 16) + aPart2. <br>
//!      A child of this Window is created when the WindowQuality <br>
//!      isn't the same than the parent Window <br>
//!  Trigger: Raises WindowDefinitionError if the connection failed <br>
//!      or if the Position out of the Screen Space <br>
  Standard_EXPORT   Xw_Window(const Handle(Xw_GraphicDevice)& Device,const Standard_Integer aPart1,const Standard_Integer aPart2,const Xw_WindowQuality aQuality = Xw_WQ_SAMEQUALITY,const Quantity_NameOfColor BackColor = Quantity_NOC_MATRAGRAY);
  //! Creates a Window from an X Window defined by his Xid <br>
//!      A child of this Window is created when the WindowQuality <br>
//!      isn't the same than the parent Window <br>
//!  Trigger: Raises WindowDefinitionError if the connection failed <br>
//!      or if the Position out of the Screen Space <br>
  Standard_EXPORT   Xw_Window(const Handle(Xw_GraphicDevice)& Device,const Aspect_Handle aWindow,const Xw_WindowQuality aQuality = Xw_WQ_SAMEQUALITY,const Quantity_NameOfColor BackColor = Quantity_NOC_MATRAGRAY);
  //! Creates a Window defined by his Center and his Size <br>
//!      in DSU from the Parent Window. <br>
//!      NOTE than if Parent is 0 the window is created from the <br>
//!      ROOT Window. <br>
//!      Connects it to the X server at the first call <br>
//!      depending of the GraphicDevice Visual and <br>
//!      Display parameters. <br>
//!      Quality defined a 2D or 3D Graphics oriented Window and <br>
//!      must be one of : <br>
//!      Xw_WQ_DRAWINGQUALITY for 2D Wireframe. <br>
//!      Xw_WQ_PICTUREQUALITY for Picture. <br>
//!      Xw_WQ_3DQUALITY for 3D Shading, HiddenLines, Wireframe. <br>
  Standard_EXPORT   Xw_Window(const Handle(Xw_GraphicDevice)& Device,const Standard_CString Title,const Quantity_Parameter Xc = 0.5,const Quantity_Parameter Yc = 0.5,const Quantity_Parameter Width = 0.5,const Quantity_Parameter Height = 0.5,const Xw_WindowQuality Quality = Xw_WQ_DRAWINGQUALITY,const Quantity_NameOfColor BackColor = Quantity_NOC_MATRAGRAY,const Aspect_Handle Parent = 0);
  //! Creates a Window defined by his position and size <br>
//!      in pixels from the Parent Window. <br>
//!  Trigger: Raises WindowDefinitionError if the connection failed <br>
//!      or if the Position out of the Screen Space <br>
  Standard_EXPORT   Xw_Window(const Handle(Xw_GraphicDevice)& theDevice,const Standard_CString theTitle,const Standard_Integer thePxLeft,const Standard_Integer thePxTop,const Standard_Integer thePxWidth,const Standard_Integer thePxHeight,const Xw_WindowQuality theQuality = Xw_WQ_DRAWINGQUALITY,const Quantity_NameOfColor theBackColor = Quantity_NOC_MATRAGRAY,const Aspect_Handle theParent = 0);
  //! Modifies the window background. <br>
//!  Warning: the background color is ignored when the quality <br>
//!     of this window is TRANSPARENT. <br>
  Standard_EXPORT   virtual  void SetBackground(const Aspect_Background& Background) ;
  //! Modifies the window background from a Named Color. <br>
//!  Warning: the background color is ignored when the quality <br>
//!     of this window is TRANSPARENT. <br>
  Standard_EXPORT   virtual  void SetBackground(const Quantity_NameOfColor BackColor) ;
  //! Modifies the window background from a Named Color. <br>
//!  Warning: the background color is ignored when the quality <br>
//!     of this window is TRANSPARENT. <br>
  Standard_EXPORT   virtual  void SetBackground(const Quantity_Color& color) ;
  //! Defines the window background directly from a bitmap. <br>
//!  Warning: the bitmap and window must have the same depth. <br>
  Standard_EXPORT     void SetBackground(const Aspect_Handle aPixmap) ;
  //! Loads the window background from an image file <aName> <br>
//! defined with a supported format XWD,GIF or BMP <br>
//! and returns TRUE if the operation is successfull. <br>
  Standard_EXPORT     Standard_Boolean SetBackground(const Standard_CString aName,const Aspect_FillMethod aMethod = Aspect_FM_CENTERED) ;
  //! Modifies the window gradient background. <br>
//!  Warning: the gradient background colours are ignored when the quality <br>
//!     of this window is TRANSPARENT. <br>
  Standard_EXPORT   virtual  void SetBackground(const Aspect_GradientBackground& Background) ;
  //! Modifies the window gradient background. <br>
//!  Warning: the gradient background colours are ignored when the quality <br>
//!     of this window is TRANSPARENT. <br>
  Standard_EXPORT     void SetBackground(const Quantity_Color& aCol1,const Quantity_Color& aCol2,const Aspect_GradientFillMethod aMethod = Aspect_GFM_HOR) ;
  //! Activates/Deactivates the Double Buffering capability <br>
//!      for this window. <br>
//!  Warning: Double Buffering is always DISABLE by default <br>
//!      If there is not enought ressources to activate the <br>
//!      double-buffering the DB mode flag can be set to FALSE. <br>
  Standard_EXPORT   virtual  void SetDoubleBuffer(const Standard_Boolean DBmode) ;
  //! Flushs all graphics to the screen and Swap the Double <br>
//!      buffer if Enable <br>
//!  Category: Methods to modify the class definition <br>
//!  Trigger: Raises if Something is WRONG at Drawing Time. <br>
  Standard_EXPORT   virtual  void Flush() const;
  //! Opens the window <me>. <br>
  Standard_EXPORT   virtual  void Map() const;
  //! Closes the window <me>. <br>
  Standard_EXPORT   virtual  void Unmap() const;
  //! Applies the resizing to the window <me>. <br>
  Standard_EXPORT   virtual  Aspect_TypeOfResize DoResize() const;
  //! Apply the mapping change to the window <me> <br>
//! and returns TRUE if the window is mapped at screen. <br>
  Standard_EXPORT   virtual  Standard_Boolean DoMapping() const;
  //! Destroies the Window <br>
//!  C++: alias ~ <br>
//!  Category: Methods to modify the class definition <br>
//!  Trigger: Raises if Window is not defined properly <br>
  Standard_EXPORT   virtual  void Destroy() ;
  //! Clears the Window in the Background color <br>
  Standard_EXPORT   virtual  void Clear() const;
  //! Clears the Window Area defined by his center and PIXEL size <br>
//!      in the Background color <br>
//!  Category: Methods to modify the class definition <br>
//!  Trigger: Raises if Window is not defined properly <br>
  Standard_EXPORT   virtual  void ClearArea(const Standard_Integer Xc,const Standard_Integer Yc,const Standard_Integer Width,const Standard_Integer Height) const;
  //! Restores The Window from the BackingStored Window <br>
//!      See BackingStore () method. <br>
  Standard_EXPORT   virtual  void Restore() const;
  //! Restores The Window Area defined by his center <br>
//!      and PIXEL size from the BackingStored Window <br>
//!      See BackingStore () method. <br>
  Standard_EXPORT   virtual  void RestoreArea(const Standard_Integer Xc,const Standard_Integer Yc,const Standard_Integer Width,const Standard_Integer Height) const;
  //! Dumps the Window to an XWD,GIF or BMP file with <br>
//! an optional gamma correction value according to the graphic system. <br>
//!  and returns TRUE if the dump occurs normaly. <br>
//!  Category: Methods to modify the class definition <br>
//!  Trigger: Raises if Window is not defined properly <br>
  Standard_EXPORT   virtual  Standard_Boolean Dump(const Standard_CString aFilename,const Standard_Real aGammaValue = 1.0) const;
  //! Dumps the Window Area defined by his center and PIXEL size <br>
//! to an XWD,GIF or BMP file with <br>
//! an optional gamma correction value according to the graphic system. <br>
//!  and returns TRUE if the dump occurs normaly. <br>
//!  Category: Methods to modify the class definition <br>
//!  Trigger: Raises if Window is not defined properly <br>
//!      or the area is out of the Window. <br>
  Standard_EXPORT   virtual  Standard_Boolean DumpArea(const Standard_CString aFilename,const Standard_Integer Xc,const Standard_Integer Yc,const Standard_Integer Width,const Standard_Integer Height,const Standard_Real aGammaValue = 1.0) const;
  //! dump the full contents of the window to a pixmap. <br>
  Standard_EXPORT   virtual  Standard_Boolean ToPixMap(Image_PixMap& theImage) const;
  //! Loads the XWD file to this Window. <br>
//! Returns TRUE if the loading occurs normaly. <br>
//!  Warning: Note that the Window is enlarged automatically <br>
//!  when the image size is too large for this window. <br>
//!  Category: Methods to modify the class definition <br>
//!  Trigger: Raises if Window is not defined properly <br>
  Standard_EXPORT   virtual  Standard_Boolean Load(const Standard_CString aFilename) const;
  //! Loads the XWD file to Window Area defined by his center <br>
//!  and PIXEL size. <br>
//! Returns TRUE if the loading occurs normaly. <br>
//!  Warning: Note that the Image is zoomed automatically <br>
//!  when the image size is too large for this window area. <br>
//!  Category: Methods to modify the class definition <br>
//!  Trigger: Raises if Window is not defined properly <br>
//!          or the area is out of the Window. <br>
  Standard_EXPORT   virtual  Standard_Boolean LoadArea(const Standard_CString aFilename,const Standard_Integer Xc,const Standard_Integer Yc,const Standard_Integer Width,const Standard_Integer Height) const;
  //! Changes the current window cursor by anId cursor <br>
//!      in the specified color. <br>
//!      NOTE than anId must be one of /usr/include/X11/cursorfont.h <br>
//!      or 0 for Deactivate the cursor <br>
  Standard_EXPORT   virtual  void SetCursor(const Standard_Integer anId,const Quantity_NameOfColor aColor = Quantity_NOC_YELLOW) const;
  //! Returns the BackingStore capability for this Window. <br>
//!      If Answer is True Exposure can be recovered by <br>
//!      Restore RestoreArea methods. <br>
//!      If Answer is False, Application must Redraw the <br>
//!          exposed area. <br>
  Standard_EXPORT   virtual  Standard_Boolean BackingStore() const;
  //! Returns the DoubleBuffer state. <br>
  Standard_EXPORT   virtual  Standard_Boolean DoubleBuffer() const;
  //! Returns True if the window <me> is opened <br>
//!      and False if the window is closed. <br>
  Standard_EXPORT   virtual  Standard_Boolean IsMapped() const;
  //! Returns The Window RATIO equal to the physical <br>
//!      WIDTH/HEIGHT dimensions <br>
  Standard_EXPORT   virtual  Quantity_Ratio Ratio() const;
  //! Returns The Window POSITION in DSU <br>
  Standard_EXPORT   virtual  void Position(Quantity_Parameter& X1,Quantity_Parameter& Y1,Quantity_Parameter& X2,Quantity_Parameter& Y2) const;
  //! Returns The Window POSITION in PIXEL <br>
  Standard_EXPORT   virtual  void Position(Standard_Integer& X1,Standard_Integer& Y1,Standard_Integer& X2,Standard_Integer& Y2) const;
  //! Returns The Window SIZE in DSU <br>
  Standard_EXPORT   virtual  void Size(Quantity_Parameter& Width,Quantity_Parameter& Height) const;
  //! Returns The Window SIZE in PIXEL <br>
  Standard_EXPORT   virtual  void Size(Standard_Integer& Width,Standard_Integer& Height) const;
  //! Returns The Window SIZE in MM <br>
  Standard_EXPORT   virtual  void MMSize(Standard_Real& Width,Standard_Real& Height) const;
  //! Returns the DSU value depending of the PIXEL value. <br>
  Standard_EXPORT   virtual  Quantity_Parameter Convert(const Standard_Integer PV) const;
  //! Returns the PIXEL value depending of the DSU value. <br>
  Standard_EXPORT   virtual  Standard_Integer Convert(const Quantity_Parameter DV) const;
  //! Returns the DSU position depending of the PIXEL position. <br>
  Standard_EXPORT   virtual  void Convert(const Standard_Integer PX,const Standard_Integer PY,Quantity_Parameter& DX,Quantity_Parameter& DY) const;
  //! Returns the PIXEL position depending of the DSU position. <br>
  Standard_EXPORT   virtual  void Convert(const Quantity_Parameter DX,const Quantity_Parameter DY,Standard_Integer& PX,Standard_Integer& PY) const;
  //! Returns the X window ID of the created window <me>. <br>
  Standard_EXPORT     Aspect_Handle XWindow() const;
  //! Returns the X window ID of the created window <me>. <br>
//!      This Xid equals (aPart1 << 16) + aPart2. <br>
  Standard_EXPORT     void XWindow(Standard_Integer& aPart1,Standard_Integer& aPart2) const;
  //! Returns the X window ID parent of the created window <me>. <br>
  Standard_EXPORT     Aspect_Handle XParentWindow() const;
  //! Returns the X window ID parent of the created window <me>. <br>
//!      This Xid equals (aPart1 << 16) + aPart2. <br>
  Standard_EXPORT     void XParentWindow(Standard_Integer& aPart1,Standard_Integer& aPart2) const;
  //! Returns the X pixmap ID of the created window <me>. <br>
//!      If BackingStore () is permitted. <br>
  Standard_EXPORT     Aspect_Handle XPixmap() const;
  //! Returns the Pointer position relatively to the Window <me> <br>
//!      and FALSE if the pointer is outside of the window <br>
  Standard_EXPORT   virtual  Standard_Boolean PointerPosition(Standard_Integer& X,Standard_Integer& Y) const;
  //! Returns the Colormap attached to this Window <br>
  Standard_EXPORT     Handle_Xw_ColorMap ColorMap() const;
  //! Returns the Typemap attached to this Window <br>
  Standard_EXPORT     Handle_Xw_TypeMap TypeMap() const;
  //! Returns the Widthmap attached to this Window <br>
  Standard_EXPORT     Handle_Xw_WidthMap WidthMap() const;
  //! Returns the Fontmap attached to this Window <br>
  Standard_EXPORT     Handle_Xw_FontMap FontMap() const;
  //! Returns the Markmap attached to this Window <br>
  Standard_EXPORT     Handle_Xw_MarkMap MarkMap() const;
  //! Returns the Colormap XId attached to this Window <br>
//!      depending of the HardWare and Visual class <br>
//!  Trigger: Raises if Window is not defined properly <br>
  Standard_EXPORT     Aspect_Handle XColorMap() const;
  //! Returns the Visual address attached to this Window <br>
//!      depending of the HardWare <br>
//!  Trigger: Raises if Window is not defined properly <br>
  Standard_EXPORT     Standard_Address XVisual() const;
  //! Returns the X window Visual class of the created window <me> <br>
  Standard_EXPORT     Xw_TypeOfVisual VisualClass() const;
  //! Returns the X window Visual depth of the created window <me> <br>
  Standard_EXPORT     Standard_Integer VisualDepth() const;
  //! Returns the Visual ID of the Window <br>
  Standard_EXPORT     Standard_Integer VisualID() const;
  //! Returns the Quality of this window <br>
  Standard_EXPORT     Xw_WindowQuality Quality() const;
  //! Returns FALSE when the returned pixel value <aPixel> <br>
//!     of an RGB color <aColor> is exact or TRUE <br>
//!     when the pixel value is approximated. <br>
  Standard_EXPORT     Standard_Boolean PixelOfColor(const Quantity_NameOfColor aColor,Standard_Integer& aPixel) const;
  //! Returns FALSE when the returned pixel value <aPixel> <br>
//!     of an RGB color <aColor> is exact or TRUE <br>
//!     when the pixel value is approximated. <br>
//!  Warning: <br>
//! make becarefull about the number of different pixel <br>
//! of colors reserved in the colormap in PseudoColor mode !!! <br>
  Standard_EXPORT     Standard_Boolean PixelOfColor(const Quantity_Color& aColor,Standard_Integer& aPixel) const;
  //! Returns FALSE when the returned background pixel <br>
//!     value <aPixel> is not defined <br>
  Standard_EXPORT     Standard_Boolean BackgroundPixel(Standard_Integer& aPixel) const;


friend class Xw_Driver;
friend class Xw_IconBox;


  DEFINE_STANDARD_RTTI(Xw_Window)

protected:

  //! Returns the ExtendedWindow address of the created window. <br>
  Standard_EXPORT     Standard_Address ExtendedWindow() const;
  //! Returns the ExtendedColorMap address of the created window. <br>
  Standard_EXPORT     Standard_Address ExtendedColorMap() const;
  //! Returns the ExtendedTypeMap address of the created window. <br>
  Standard_EXPORT     Standard_Address ExtendedTypeMap() const;
  //! Returns the ExtendedWidthMap address of the created window. <br>
  Standard_EXPORT     Standard_Address ExtendedWidthMap() const;
  //! Returns the ExtendedFontMap address of the created window. <br>
  Standard_EXPORT     Standard_Address ExtendedFontMap() const;
  //! Returns the ExtendedMarkMap address of the created window. <br>
  Standard_EXPORT     Standard_Address ExtendedMarkMap() const;
  //! Print last error or raise depending of the error gravity. <br>
  Standard_EXPORT   static  void PrintError() ;

Xw_WindowQuality MyQuality;
Handle_Xw_ColorMap MyColorMap;
Handle_Xw_TypeMap MyTypeMap;
Handle_Xw_WidthMap MyWidthMap;
Handle_Xw_FontMap MyFontMap;
Handle_Xw_MarkMap MyMarkMap;
Aspect_Handle MyXWindow;
Aspect_Handle MyXParentWindow;
Aspect_Handle MyXPixmap;
Xw_TypeOfVisual MyVisualClass;
Standard_Integer MyDepth;
Standard_Integer MyBackgroundIndex;
Standard_Address MyExtendedDisplay;
Standard_Address MyExtendedWindow;
Standard_Address MyExtendedColorMap;
Standard_Address MyExtendedTypeMap;
Standard_Address MyExtendedWidthMap;
Standard_Address MyExtendedFontMap;
Standard_Address MyExtendedMarkMap;


private: 

  
  Standard_EXPORT     void SetWindow(const Aspect_Handle aWindow,const Xw_WindowQuality aQuality,const Quantity_NameOfColor BackColor) ;
  
  Standard_EXPORT     void SetWindow(const Standard_CString Title,const Quantity_Parameter Xc,const Quantity_Parameter Yc,const Quantity_Parameter Width,const Quantity_Parameter Height,const Xw_WindowQuality Quality,const Quantity_NameOfColor BackColor,const Aspect_Handle Parent) ;
  //! Initialise the fileds of class <br>
  Standard_EXPORT     void Init() ;



};





// other Inline functions and methods (like "C++: function call" methods)


#endif
