(* $Id: simple-insert.ml,v 1.2 2005/11/17 09:56:53 rwmj Exp $ *)

open Printf

open ExamplesLib

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  let dbh = set_up_database dbname in

  print_employees "Before taking on new employees" dbh;

  (* INSERT some new employees.  Notice that we reuse the prepared
   * statement handle multiple times.  This is OK - in fact on some
   * databases it can be very efficient.  Notice also the use of
   * #serial to retrieve the serial number of the previously inserted
   * row (on databases which support this).
   *)
  let sth = dbh#prepare "insert into employees (name, salary, position)
                         values (?, ?, ?)" in

  sth#execute [`String "Bruce"; `Int 8000; `Int 3 ];
  printf "Bruce's employee ID is %Ld\n" (sth#serial "employees_id_seq");

  sth#execute [`String "Fred"; `Int 8000; `Int 3 ];
  printf "Fred's employee ID is %Ld\n" (sth#serial "employees_id_seq");

  sth#execute [`String "Hannah"; `Int 8000; `Int 3 ];
  printf "Hannah's employee ID is %Ld\n" (sth#serial "employees_id_seq");

  sth#execute [`String "Stephanie"; `Int 8000; `Int 3 ];
  printf "Stephanie's employee ID is %Ld\n" (sth#serial "employees_id_seq");

  print_employees "After taking on new employees" dbh
