from math import log
from array import array
from copy import deepcopy

bpencoder={'A':1,'C':2,'G':3,'T':4,
           'a':1,'c':2,'g':3,'t':4,
           '-':0
          }

rvencoder={'A':4,'C':3,'G':2,'T':1,
           'a':4,'c':3,'g':2,'t':1,
           '-':0
          }

R                      = 1.987
SALT_METHOD_SANTALUCIA = 1
SALT_METHOD_OWCZARZY   = 2
DEF_CONC_PRIMERS       = 8.e-7
DEF_CONC_SEQUENCES     = 0.
DEF_SALT               = 0.05
forbidden_entropy      = 0.
forbidden_enthalpy     = 1.e18

__dH = [[[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]]
      ]
__dS =  [[[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]],
      [[[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]],
       [[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.],[0.,0.,0.,0.,0.,0.]]]
      ]

def initParams(c1, c2, kp, sm,nparm={}):
    global forbidden_entropy
    global dH,dS
    
    dH=deepcopy(__dH)
    dS=deepcopy(__dS)
    
    nparm['Ct1'] = c1;
    nparm['Ct2'] = c2;
    nparm['kplus'] = kp;
    maxCT = 1;
    
    if(nparm['Ct2'] > nparm['Ct1']):
        maxCT = 2

    if(nparm['Ct1'] == nparm['Ct2']):
        ctFactor = nparm['Ct1']/2
    elif (maxCT == 1):
        ctFactor = nparm['Ct1']-nparm['Ct2']/2
    else:
        ctFactor = nparm['Ct2']-nparm['Ct1']/2

    nparm['rlogc'] = R * log(ctFactor)
    forbidden_entropy = nparm['rlogc']
    nparm['kfac'] = 0.368 * log(nparm['kplus'])
    nparm['saltMethod'] = sm


    # Set all X-/Y-, -X/Y- and X-/-Y so, that TM will be VERY small!
    for x in xrange(1,5):
        for y in xrange(1,5):
            dH[0][x][y][0]=forbidden_enthalpy;
            dS[0][x][y][0]=forbidden_entropy;
            dH[x][0][0][y]=forbidden_enthalpy;
            dS[x][0][0][y]=forbidden_entropy;
            dH[x][0][y][0]=forbidden_enthalpy;
            dS[x][0][y][0]=forbidden_entropy;
            # forbid X-/Y$ and X$/Y- etc., i.e. terminal must not be paired with gap!
            dH[x][5][y][0]=forbidden_enthalpy;
            dS[x][5][y][0]=forbidden_entropy;
            dH[x][0][y][5]=forbidden_enthalpy;
            dS[x][0][y][5]=forbidden_entropy;
            dH[5][x][0][y]=forbidden_enthalpy;
            dS[5][x][0][y]=forbidden_entropy;
            dH[0][x][5][y]=forbidden_enthalpy;
            dS[0][x][5][y]=forbidden_entropy;
            
            #forbid X$/-Y etc.
            dH[x][5][0][y]=forbidden_enthalpy;
            dS[x][5][0][y]=forbidden_entropy;
            dH[x][0][5][y]=forbidden_enthalpy;
            dS[x][0][5][y]=forbidden_entropy;
            dH[5][x][y][0]=forbidden_enthalpy;
            dS[5][x][y][0]=forbidden_entropy;
            dH[0][x][y][5]=forbidden_enthalpy;
            dS[0][x][y][5]=forbidden_entropy;

        
        
        #also, forbid x-/-- and --/x-, i.e. no two inner gaps paired
        dH[x][0][0][0]=forbidden_enthalpy;
        dS[x][0][0][0]=forbidden_entropy;
        dH[0][0][x][0]=forbidden_enthalpy;
        dS[0][0][x][0]=forbidden_entropy;
        # x-/-$
        dH[x][0][0][5]=forbidden_enthalpy;
        dS[x][0][0][5]=forbidden_entropy;
        dH[5][0][0][x]=forbidden_enthalpy;
        dS[5][0][0][x]=forbidden_entropy;
        dH[0][5][x][0]=forbidden_enthalpy;
        dS[x][0][0][5]=forbidden_entropy;
        dH[0][x][5][0]=forbidden_enthalpy;
        dS[0][x][5][0]=forbidden_entropy;
    
    # forbid --/--
    dH[0][0][0][0]=forbidden_enthalpy;
    dS[0][0][0][0]=forbidden_entropy;

    dH[5][0][0][0]=forbidden_enthalpy;
    dS[5][0][0][0]=forbidden_entropy;
    dH[0][0][5][0]=forbidden_enthalpy;
    dS[0][0][5][0]=forbidden_entropy;
    dH[0][5][5][0]=forbidden_enthalpy;
    dS[0][5][5][0]=forbidden_entropy;

    # Interior loops (double Mismatches)
    iloop_entropy=-0.97
    iloop_enthalpy=0.0
    
    for x in xrange(1,5):
        for y in xrange(1,5):
            for a in xrange(1,5):
                for b in xrange(1,5):
                    # AT and CG pair, and as A=1, C=2, G=3, T=4 this means
                    # we have Watson-Crick pairs if (x+a==5) and (y+b)==5.
                    if ( not ((x+a==5) or (y+b==5))):
                        # No watson-crick-pair, i.e. double mismatch!
                        # set enthalpy/entropy to loop expansion!
                        dH[x][y][a][b] = iloop_enthalpy;
                        dS[x][y][a][b] = iloop_entropy;
                    

    # xy/-- and --/xy (Bulge Loops of size > 1)
    bloop_entropy=-1.3
    bloop_enthalpy=0.0

    for x in xrange(1,5):
        for y in xrange(1,5):
            dH[x][y][0][0] = bloop_enthalpy;
            dS[x][y][0][0] = bloop_entropy;
            dH[0][0][x][y] = bloop_enthalpy;
            dS[0][0][x][y] = bloop_entropy;
        

    # x-/ya abd xa/y- as well as -x/ay and ax/-y
    # bulge opening and closing parameters with
    # adjacent matches / mismatches
    # obulge_mism and cbulge_mism chosen so high to avoid
    #     AAAAAAAAA
    #    T--G----T
    # being better than
    #     AAAAAAAAA
    #     TG------T
    obulge_match_H  =-2.66e3
    obulge_match_S  =-14.22
    cbulge_match_H  =-2.66e3
    cbulge_match_S  =-14.22
    obulge_mism_H   = 0.0
    obulge_mism_S   = -6.45
    cbulge_mism_H   = 0.0
    cbulge_mism_S   =-6.45
    
    for x in xrange(1,5):
        for y in xrange(1,5):
            for a in xrange(1,5):
                if (x+y==5):  # other base pair matches!
            
                    dH[x][0][y][a]=obulge_match_H;  # bulge opening
                    dS[x][0][y][a]=obulge_match_S;
                    dH[x][a][y][0]=obulge_match_H;
                    dS[x][a][y][0]=obulge_match_S;
                    dH[0][x][a][y]=cbulge_match_H;  # bulge closing
                    dS[0][x][a][y]=cbulge_match_S;
                    dH[a][x][0][y]=cbulge_match_H;
                    dS[a][x][0][y]=cbulge_match_S;
                else:
                    # mismatch in other base pair!
                    dH[x][0][y][a]=obulge_mism_H;   # bulge opening
                    dS[x][0][y][a]=obulge_mism_S;
                    dH[x][a][y][0]=obulge_mism_H;
                    dS[x][a][y][0]=obulge_mism_S;
                    dH[0][x][a][y]=cbulge_mism_H;   # bulge closing
                    dS[0][x][a][y]=cbulge_mism_S;
                    dH[a][x][0][y]=cbulge_mism_H;
                    dS[a][x][0][y]=cbulge_mism_S;
                
            

    # Watson-Crick pairs (note that only ten are unique, as obviously
    # 5'-AG-3'/3'-TC-5'  =  5'-CT-3'/3'-GA-5' etc.
    dH[1][1][4][4]=-7.6e3;  dS[1][1][4][4]=-21.3    # AA/TT 04
    dH[1][2][4][3]=-8.4e3;  dS[1][2][4][3]=-22.4    # AC/TG adapted GT/CA
    dH[1][3][4][2]=-7.8e3;  dS[1][3][4][2]=-21.0    # AG/TC adapted CT/GA
    dH[1][4][4][1]=-7.2e3;  dS[1][4][4][1]=-20.4    # AT/TA 04
    dH[2][1][3][4]=-8.5e3;  dS[2][1][3][4]=-22.7    # CA/GT 04
    dH[2][2][3][3]=-8.0e3;  dS[2][2][3][3]=-19.9    # CC/GG adapted GG/CC
    dH[2][3][3][2]=-10.6e3; dS[2][3][3][2]=-27.2    # CG/GC 04
    dH[2][4][3][1]=-7.8e3;  dS[2][4][3][1]=-21.0    # CT/GA 04
    dH[3][1][2][4]=-8.2e3;  dS[3][1][2][4]=-22.2    # GA/CT 04
    dH[3][2][2][3]=-9.8e3;  dS[3][2][2][3]=-24.4    # GC/CG 04
    dH[3][3][2][2]=-8.0e3;  dS[3][3][2][2]=-19.9    # GG/CC 04
    dH[3][4][2][1]=-8.4e3;  dS[3][4][2][1]=-22.4    # GT/CA 04
    dH[4][1][1][4]=-7.2e3;  dS[4][1][1][4]=-21.3    # TA/AT 04
    dH[4][2][1][3]=-8.2e3;  dS[4][2][1][3]=-22.2    # TC/AG adapted GA/CT
    dH[4][3][1][2]=-8.5e3;  dS[4][3][1][2]=-22.7    # TG/AC adapted CA/GT
    dH[4][4][1][1]=-7.6e3;  dS[4][4][1][1]=-21.3    # TT/AA adapted AA/TT

    # A-C Mismatches (Values for pH 7.0)
    dH[1][1][2][4]=7.6e3;   dS[1][1][2][4]=20.2     # AA/CT
    dH[1][1][4][2]=2.3e3;   dS[1][1][4][2]=4.6      # AA/TC
    dH[1][2][2][3]=-0.7e3;  dS[1][2][2][3]=-3.8     # AC/CG
    dH[1][2][4][1]=5.3e3;   dS[1][2][4][1]=14.6     # AC/TA
    dH[1][3][2][2]=0.6e3;   dS[1][3][2][2]=-0.6     # AG/CC
    dH[1][4][2][1]=5.3e3;   dS[1][4][2][1]=14.6     # AT/CA
    dH[2][1][1][4]=3.4e3;   dS[2][1][1][4]=8.0      # CA/AT
    dH[2][1][3][2]=1.9e3;   dS[2][1][3][2]=3.7      # CA/GC
    dH[2][2][1][3]=5.2e3;   dS[2][2][1][3]=14.2     # CC/AG
    dH[2][2][3][1]=0.6e3;   dS[2][2][3][1]=-0.6     # CC/GA
    dH[2][3][1][2]=1.9e3;   dS[2][3][1][2]=3.7      # CG/AC
    dH[2][4][1][1]=2.3e3;   dS[2][4][1][1]=4.6      # CT/AA
    dH[3][1][2][2]=5.2e3;   dS[3][1][2][2]=14.2     # GA/CC
    dH[3][2][2][1]=-0.7e3;  dS[3][2][2][1]=-3.8     # GC/CA
    dH[4][1][1][2]=3.4e3;   dS[4][1][1][2]=8.0      # TA/AC
    dH[4][2][1][1]=7.6e3;   dS[4][2][1][1]=20.2     # TC/AA

    # C-T Mismatches
    dH[1][2][4][4]=0.7e3;   dS[1][2][4][4]=0.2      # AC/TT
    dH[1][4][4][2]=-1.2e3;  dS[1][4][4][2]=-6.2     # AT/TC
    dH[2][1][4][4]=1.0e3;   dS[2][1][4][4]=0.7      # CA/TT
    dH[2][2][3][4]=-0.8e3;  dS[2][2][3][4]=-4.5     # CC/GT
    dH[2][2][4][3]=5.2e3;   dS[2][2][4][3]=13.5     # CC/TG
    dH[2][3][4][2]=-1.5e3;  dS[2][3][4][2]=-6.1     # CG/TC
    dH[2][4][3][2]=-1.5e3;  dS[2][4][3][2]=-6.1     # CT/GC
    dH[2][4][4][1]=-1.2e3;  dS[2][4][4][1]=-6.2     # CT/TA
    dH[3][2][2][4]=2.3e3;   dS[3][2][2][4]=5.4      # GC/CT
    dH[3][4][2][2]=5.2e3;   dS[3][4][2][2]=13.5     # GT/CC
    dH[4][1][2][4]=1.2e3;   dS[4][1][2][4]=0.7      # TA/CT
    dH[4][2][2][3]=2.3e3;   dS[4][2][2][3]=5.4      # TC/CG
    dH[4][2][1][4]=1.2e3;   dS[4][2][1][4]=0.7      # TC/AT
    dH[4][3][2][2]=-0.8e3;  dS[4][3][2][2]=-4.5     # TG/CC
    dH[4][4][2][1]=0.7e3;   dS[4][4][2][1]=0.2      # TT/CA
    dH[4][4][1][2]=1.0e3;   dS[4][4][1][2]=0.7      # TT/AC

    # G-A Mismatches
    dH[1][1][3][4]=3.0e3;   dS[1][1][3][4]=7.4      # AA/GT
    dH[1][1][4][3]=-0.6e3;  dS[1][1][4][3]=-2.3     # AA/TG
    dH[1][2][3][3]=0.5e3;   dS[1][2][3][3]=3.2      # AC/GG
    dH[1][3][3][2]=-4.0e3;  dS[1][3][3][2]=-13.2    # AG/GC
    dH[1][3][4][1]=-0.7e3;  dS[1][3][4][1]=-2.3     # AG/TA
    dH[1][4][3][1]=-0.7e3;  dS[1][4][3][1]=-2.3     # AT/GA
    dH[2][1][3][3]=-0.7e3;  dS[2][1][3][3]=-2.3     # CA/GG
    dH[2][3][3][1]=-4.0e3;  dS[2][3][3][1]=-13.2    # CG/GA
    dH[3][1][1][4]=0.7e3;   dS[3][1][1][4]=0.7      # GA/AT
    dH[3][1][2][3]=-0.6e3;  dS[3][1][2][3]=-1.0     # GA/CG
    dH[3][2][1][3]=-0.6e3;  dS[3][2][1][3]=-1.0     # GC/AG
    dH[3][3][1][2]=-0.7e3;  dS[3][3][1][2]=-2.3     # GG/AC
    dH[3][3][2][1]=0.5e3;   dS[3][3][2][1]=3.2      # GG/CA
    dH[3][4][1][1]=-0.6e3;  dS[3][4][1][1]=-2.3     # GT/AA
    dH[4][1][1][3]=0.7e3;   dS[4][1][1][3]=0.7      # TA/AG
    dH[4][3][1][1]=3.0e3;   dS[4][3][1][1]=7.4      # TG/AA

    # G-T Mismatches
    dH[1][3][4][4]=1.0e3;   dS[1][3][4][4]=0.9      # AG/TT
    dH[1][4][4][3]=-2.5e3;  dS[1][4][4][3]=-8.3     # AT/TG
    dH[2][3][3][4]=-4.1e3;  dS[2][3][3][4]=-11.7    # CG/GT
    dH[2][4][3][3]=-2.8e3;  dS[2][4][3][3]=-8.0     # CT/GG
    dH[3][1][4][4]=-1.3e3;  dS[3][1][4][4]=-5.3     # GA/TT
    dH[3][2][4][3]=-4.4e3;  dS[3][2][4][3]=-12.3    # GC/TG
    dH[3][3][2][4]=3.3e3;   dS[3][3][2][4]=10.4     # GG/CT
    dH[3][3][4][2]=-2.8e3;  dS[3][3][4][2]=-8.0     # GG/TC
#    dH[3][3][4][4]=5.8e3;   dS[3][3][4][4]=16.3     # GG/TT
    dH[3][4][2][3]=-4.4e3;  dS[3][4][2][3]=-12.3    # GT/CG
    dH[3][4][4][1]=-2.5e3;  dS[3][4][4][1]=-8.3     # GT/TA
#    dH[3][4][4][3]=4.1e3;   dS[3][4][4][3]=9.5      # GT/TG
    dH[4][1][3][4]=-0.1e3;  dS[4][1][3][4]=-1.7     # TA/GT
    dH[4][2][3][3]=3.3e3;   dS[4][2][3][3]=10.4     # TC/GG
    dH[4][3][1][4]=-0.1e3;  dS[4][3][1][4]=-1.7     # TG/AT
    dH[4][3][3][2]=-4.1e3;  dS[4][3][3][2]=-11.7    # TG/GC
#    dH[4][3][3][4]=-1.4e3;  dS[4][3][3][4]=-6.2     # TG/GT
    dH[4][4][1][3]=-1.3e3;  dS[4][4][1][3]=-5.3     # TT/AG
    dH[4][4][3][1]=1.0e3;   dS[4][4][3][1]=0.9      # TT/GA
#    dH[4][4][3][3]=5.8e3;   dS[4][4][3][3]=16.3     # TT/GG

    # A-A Mismatches
    dH[1][1][1][4]=4.7e3;   dS[1][1][1][4]=12.9     # AA/AT
    dH[1][1][4][1]=1.2e3;   dS[1][1][4][1]=1.7      # AA/TA
    dH[1][2][1][3]=-2.9e3;  dS[1][2][1][3]=-9.8     # AC/AG
    dH[1][3][1][2]=-0.9e3;  dS[1][3][1][2]=-4.2     # AG/AC
    dH[1][4][1][1]=1.2e3;   dS[1][4][1][1]=1.7      # AT/AA
    dH[2][1][3][1]=-0.9e3;  dS[2][1][3][1]=-4.2     # CA/GA
    dH[3][1][2][1]=-2.9e3;  dS[3][1][2][1]=-9.8     # GA/CA
    dH[4][1][1][1]=4.7e3;   dS[4][1][1][1]=12.9     # TA/AA

    # C-C Mismatches
    dH[1][2][4][2]=0.0e3;   dS[1][2][4][2]=-4.4     # AC/TC
    dH[2][1][2][4]=6.1e3;   dS[2][1][2][4]=16.4     # CA/CT
    dH[2][2][2][3]=3.6e3;   dS[2][2][2][3]=8.9      # CC/CG
    dH[2][2][3][2]=-1.5e3;  dS[2][2][3][2]=-7.2     # CC/GC
    dH[2][3][2][2]=-1.5e3;  dS[2][3][2][2]=-7.2     # CG/CC
    dH[2][4][2][1]=0.0e3;   dS[2][4][2][1]=-4.4     # CT/CA
    dH[3][2][2][2]=3.6e3;   dS[3][2][2][2]=8.9      # GC/CC
    dH[4][2][1][2]=6.1e3;   dS[4][2][1][2]=16.4     # TC/AC

    # G-G Mismatches
    dH[1][3][4][3]=-3.1e3;  dS[1][3][4][3]=-9.5     # AG/TG
    dH[2][3][3][3]=-4.9e3;  dS[2][3][3][3]=-15.3    # CG/GG
    dH[3][1][3][4]=1.6e3;   dS[3][1][3][4]=3.6      # GA/GT
    dH[3][2][3][3]=-6.0e3;  dS[3][2][3][3]=-15.8    # GC/GG
    dH[3][3][2][3]=-6.0e3;  dS[3][3][2][3]=-15.8    # GG/CG
    dH[3][3][3][2]=-4.9e3;  dS[3][3][3][2]=-15.3    # GG/GC
    dH[3][4][3][1]=-3.1e3;  dS[3][4][3][1]=-9.5     # GT/GA
    dH[4][3][1][3]=1.6e3;   dS[4][3][1][3]=3.6      # TG/AG

    # T-T Mismatches
    dH[1][4][4][4]=-2.7e3;  dS[1][4][4][4]=-10.8    # AT/TT
    dH[2][4][3][4]=-5.0e3;  dS[2][4][3][4]=-15.8    # CT/GT
    dH[3][4][2][4]=-2.2e3;  dS[3][4][2][4]=-8.4     # GT/CT
    dH[4][1][4][4]=0.2e3;   dS[4][1][4][4]=-1.5     # TA/TT
    dH[4][2][4][3]=-2.2e3;  dS[4][2][4][3]=-8.4     # TC/TG
    dH[4][3][4][2]=-5.0e3;  dS[4][3][4][2]=-15.8    # TG/TC
    dH[4][4][1][4]=0.2e3;   dS[4][4][1][4]=-1.5     # TT/AT
    dH[4][4][4][1]=-2.7e3;  dS[4][4][4][1]=-10.8    # TT/TA

    # Dangling Eds
    dH[5][1][1][4]=-0.7e3;  dS[5][1][1][4]=-0.8     # $A/AT
    dH[5][1][2][4]=4.4e3;   dS[5][1][2][4]=14.9     # $A/CT
    dH[5][1][3][4]=-1.6e3;  dS[5][1][3][4]=-3.6     # $A/GT
    dH[5][1][4][4]=2.9e3;   dS[5][1][4][4]=10.4     # $A/TT
    dH[5][2][1][3]=-2.1e3;  dS[5][2][1][3]=-3.9     # $C/AG
    dH[5][2][2][3]=-0.2e3;  dS[5][2][2][3]=-0.1     # $C/CG
    dH[5][2][3][3]=-3.9e3;  dS[5][2][3][3]=-11.2    # $C/GG
    dH[5][2][4][3]=-4.4e3;  dS[5][2][4][3]=-13.1    # $C/TG
    dH[5][3][1][2]=-5.9e3;  dS[5][3][1][2]=-16.5    # $G/AC
    dH[5][3][2][2]=-2.6e3;  dS[5][3][2][2]=-7.4     # $G/CC
    dH[5][3][3][2]=-3.2e3;  dS[5][3][3][2]=-10.4    # $G/GC
    dH[5][3][4][2]=-5.2e3;  dS[5][3][4][2]=-15.0    # $G/TC
    dH[5][4][1][1]=-0.5e3;  dS[5][4][1][1]=-1.1     # $T/AA
    dH[5][4][2][1]=4.7e3;   dS[5][4][2][1]=14.2     # $T/CA
    dH[5][4][3][1]=-4.1e3;  dS[5][4][3][1]=-13.1    # $T/GA
    dH[5][4][4][1]=-3.8e3;  dS[5][4][4][1]=-12.6    # $T/TA
    dH[1][5][4][1]=-2.9e3;  dS[1][5][4][1]=-7.6     # A$/TA
    dH[1][5][4][2]=-4.1e3;  dS[1][5][4][2]=-13.0    # A$/TC
    dH[1][5][4][3]=-4.2e3;  dS[1][5][4][3]=-15.0    # A$/TG
    dH[1][5][4][4]=-0.2e3;  dS[1][5][4][4]=-0.5     # A$/TT
    dH[1][1][5][4]=0.2e3;   dS[1][1][5][4]=2.3      # AA/$T
    dH[1][1][4][5]=-0.5e3;  dS[1][1][4][5]=-1.1     # AA/T$
    dH[1][2][5][3]=-6.3e3;  dS[1][2][5][3]=-17.1    # AC/$G
    dH[1][2][4][5]=4.7e3;   dS[1][2][4][5]=14.2     # AC/T$
    dH[1][3][5][2]=-3.7e3;  dS[1][3][5][2]=-10.0    # AG/$C
    dH[1][3][4][5]=-4.1e3;  dS[1][3][4][5]=-13.1    # AG/T$
    dH[1][4][5][1]=-2.9e3;  dS[1][4][5][1]=-7.6     # AT/$A
    dH[1][4][4][5]=-3.8e3;  dS[1][4][4][5]=-12.6    # AT/T$
    dH[2][5][3][1]=-3.7e3;  dS[2][5][3][1]=-10.0    # C$/GA
    dH[2][5][3][2]=-4.0e3;  dS[2][5][3][2]=-11.9    # C$/GC
    dH[2][5][3][3]=-3.9e3;  dS[2][5][3][3]=-10.9    # C$/GG
    dH[2][5][3][4]=-4.9e3;  dS[2][5][3][4]=-13.8    # C$/GT
    dH[2][1][5][4]=0.6e3;   dS[2][1][5][4]=3.3      # CA/$T
    dH[2][1][3][5]=-5.9e3;  dS[2][1][3][5]=-16.5    # CA/G$
    dH[2][2][5][3]=-4.4e3;  dS[2][2][5][3]=-12.6    # CC/$G
    dH[2][2][3][5]=-2.6e3;  dS[2][2][3][5]=-7.4     # CC/G$
    dH[2][3][5][2]=-4.0e3;  dS[2][3][5][2]=-11.9    # CG/$C
    dH[2][3][3][5]=-3.2e3;  dS[2][3][3][5]=-10.4    # CG/G$
    dH[2][4][5][1]=-4.1e3;  dS[2][4][5][1]=-13.0    # CT/$A
    dH[2][4][3][5]=-5.2e3;  dS[2][4][3][5]=-15.0    # CT/G$
    dH[3][5][2][1]=-6.3e3;  dS[3][5][2][1]=-17.1    # G$/CA
    dH[3][5][2][2]=-4.4e3;  dS[3][5][2][2]=-12.6    # G$/CC
    dH[3][5][2][3]=-5.1e3;  dS[3][5][2][3]=-14.0    # G$/CG
    dH[3][5][2][4]=-4.0e3;  dS[3][5][2][4]=-10.9    # G$/CT
    dH[3][1][5][4]=-1.1e3;  dS[3][1][5][4]=-1.6     # GA/$T
    dH[3][1][2][5]=-2.1e3;  dS[3][1][2][5]=-3.9     # GA/C$
    dH[3][2][5][3]=-5.1e3;  dS[3][2][5][3]=-14.0    # GC/$G
    dH[3][2][2][5]=-0.2e3;  dS[3][2][2][5]=-0.1     # GC/C$
    dH[3][3][5][2]=-3.9e3;  dS[3][3][5][2]=-10.9    # GG/$C
    dH[3][3][2][5]=-3.9e3;  dS[3][3][2][5]=-11.2    # GG/C$
    dH[3][4][5][1]=-4.2e3;  dS[3][4][5][1]=-15.0    # GT/$A
    dH[3][4][2][5]=-4.4e3;  dS[3][4][2][5]=-13.1    # GT/C$
    dH[4][5][1][1]=0.2e3;   dS[4][5][1][1]=2.3      # T$/AA
    dH[4][5][1][2]=0.6e3;   dS[4][5][1][2]=3.3      # T$/AC
    dH[4][5][1][3]=-1.1e3;  dS[4][5][1][3]=-1.6     # T$/AG
    dH[4][5][1][4]=-6.9e3;  dS[4][5][1][4]=-20.0    # T$/AT
    dH[4][1][5][4]=-6.9e3;  dS[4][1][5][4]=-20.0    # TA/$T
    dH[4][1][1][5]=-0.7e3;  dS[4][1][1][5]=-0.7     # TA/A$
    dH[4][2][5][3]=-4.0e3;  dS[4][2][5][3]=-10.9    # TC/$G
    dH[4][2][1][5]=4.4e3;   dS[4][2][1][5]=14.9     # TC/A$
    dH[4][3][5][2]=-4.9e3;  dS[4][3][5][2]=-13.8    # TG/$C
    dH[4][3][1][5]=-1.6e3;  dS[4][3][1][5]=-3.6     # TG/A$
    dH[4][4][5][1]=-0.2e3;  dS[4][4][5][1]=-0.5     # TT/$A
    dH[4][4][1][5]=2.9e3;   dS[4][4][1][5]=10.4     # TT/A$


    nparm['dH']=dH
    nparm['dS']=dS
    
    return nparm


defaultParm=initParams(DEF_CONC_PRIMERS,DEF_CONC_SEQUENCES,DEF_SALT, SALT_METHOD_SANTALUCIA)

def seqencoder(seq):
    return [bpencoder[x] for x in seq]

def getInitialEntropy(nparm=defaultParm):
    return     -5.9+nparm['rlogc']

def getEnthalpy(x0, x1, y0, y1,nparm=defaultParm):
    return nparm['dH'][x0][x1][y0][y1]

def GetEntropy(x0, x1, y0, y1,nparm=defaultParm):
    
    nx0=x0
    nx1=x1
    ny0=y0
    ny1=y1
    dH=nparm['dH']
    dS=nparm['dS']
    answer = dS[nx0][nx1][ny0][ny1]

    if (nparm['saltMethod'] == SALT_METHOD_SANTALUCIA):
        if(nx0!=5 and 1<= nx1 and nx1<=4): 
            answer += 0.5*nparm['kfac']
        
        if(ny1!=5 and 1<= ny0 and ny0<=4): 
            answer += 0.5*nparm['kfac']
        
    if (nparm['saltMethod'] == SALT_METHOD_OWCZARZY):
        logk = log(nparm['kplus']);
        answer += dH[nx0][nx1][ny0][ny1]*((4.29 * nparm['gcContent']-3.95)* 1e-5 * logk + 0.0000094*logk**2);
    
    return answer;

def CalcTM(entropy,enthalpy):
    tm = 0
    if (enthalpy>=forbidden_enthalpy) :
        return 0;
    
    if (entropy<0) : 
        tm = enthalpy/entropy
        if (tm<0):
            return 0;

    return tm;




def countGCContent(seq): 
    count = 0;
    for k in seq :
        if k in 'cgGC':
            count+=1;
    return count;


#def cleanSeq (inseq,outseq,length):
#
#    seqlen = len(inseq)
#    if (len != 0)
#        seqlen = length;
#
#    j=0
#    for i in xrange(seqlen):
#    {
#        switch (inseq[i])
#        {
#        case 'a':
#        case '\0':
#        case 'A':
#            outseq[j++] = 'A'; break;
#        case 'c':
#        case '\1':
#        case 'C':
#            outseq[j++] = 'C'; break;
#        case 'g':
#        case '\2':
#        case 'G':
#            outseq[j++] = 'G'; break;
#        case 't':
#        case '\3':
#        case 'T':
#            outseq[j++] = 'T'; break;
#        }
#    }
#    outseq[j] = '\0';
#}

def calcSelfTM(seq,nparm=defaultParm):
    dH=nparm['dH']
    dS=nparm['dS']
    length=len(seq)
    
    thedH = 0;
    thedS = -5.9+nparm['rlogc']
    for i in xrange(1,length):
        c1 = rvencoder[seq[i-1]];
        c2 = rvencoder[seq[i]];
        c3 = bpencoder[seq[i-1]];
        c4 = bpencoder[seq[i]];

        thedH += dH[c3][c4][c1][c2];
        thedS += GetEntropy(c3, c4, c1, c2, nparm)
    
    mtemp = CalcTM(thedS,thedH);
#    print thedH,thedS,nparm['rlogc']
    return mtemp-273.15;


def calcTMTwoSeq(seq1,seq2,nparm=defaultParm):

    thedH = 0;
    thedS = -5.9+nparm['rlogc']
    dH=nparm['dH']
    dS=nparm['dS']
    length=len(seq1)
    
    for i in xrange(1,length):
        c1 = rvencoder[seq2[i-1]]
        c2 = rvencoder[seq2[i]]
        c3 = bpencoder[seq1[i-1]]
        c4 = bpencoder[seq1[i]]

        thedH += dH[c3][c4][c1][c2]
        thedS += GetEntropy(c3, c4, c1, c2, nparm)

    mtemp = CalcTM(thedS,thedH);
#    print thedH,thedS,nparm['rlogc']

    return mtemp-273.15;


