/*
 * nzb
 *
 * Copyright (C) 2004-2006 Mattias Nordstrom <matta at ftlight net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Authors:
 *   Mattias Nordstrom <matta at ftlight net>
 *
 * $Id: decoder.h,v 1.1 2005/08/21 16:34:20 mnordstr Exp $
 *   This file provides the decoders.
 */


#ifndef DECODER_H
#define DECODER_H

#include <QtCore>
#include <QtNetwork>

#include "nzbdata.h"

class Decoder : public QThread
{
	Q_OBJECT
public:
	Decoder(NzbList *nzblist, int thread_id, QMutex *file_lock, QObject *parent = 0);
	void run();

signals:
	void decodeEvent(QString message, int row, int type = 0);

public slots:
	void processFiles();
	void stop();
	
private slots:
	void processFile();
	
private:
	bool getNext(int *file, int *seg);
	void yDecode(int file, int seg);
	bool crc32Check(int crc32, QString c_crc/*, QString data*/);
	void uDecode(int file, int seg, bool multi = false, int type = 0);
	void crcInit(int *crc32);
	void crcAdd(int *crc32, int c);
		
	QObject *parent;
	NzbList *nzblist;
	int thread_id;
	QMutex *file_lock;
	int file, seg;
	bool processing;
};

#endif
