/* -*- Mode:C++; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * \file
 * \ingroup tests
 * This file provides some doxygen documentation for the tests module.
 */


/**
 * \ingroup tests
 * \defgroup system-tests System Tests
 * 
 * \brief The "tests" module contains the System Tests, i.e., tests that
 * dependss on multiple modules. Due to their dependencies, the System Tests
 * are in this module.
 * 
 * Unit tests, on the contrary, are located in each module.
 */

/**
 * \ingroup system-tests
 * \ingroup traffic-control-test
 * \defgroup system-tests-tc TrafficControl System Tests
 * 
 * \brief TrafficControl System Tests
 */

/**
 * \ingroup system-tests
 * \ingroup internet-test
 * \defgroup system-tests-tcp TCP System Tests
 * 
 * \brief TCP System Tests
 */

/**
 * \ingroup system-tests
 * \ingroup wifi-test
 * \defgroup system-tests-wifi WiFi System Tests
 * 
 * \brief WiFi System Tests
 */

/**
 * \ingroup system-tests
 * \defgroup system-tests-perf Performance System Tests
 * 
 * \brief Performance System Tests
 * 
 * Note: these tests are (for real) scripts to be run.
 * The ouput is the time (in nanoseconds) that the test 
 * required to perform the requested write operations.
 */

/**
 * \ingroup system-tests
 * \ingroup core-tests
 * \defgroup system-tests-traced TracedCallback System Tests
 * 
 * \brief TracedCallback System Tests
 */

/**
 * \ingroup system-tests
 * \ingroup csma
 * \defgroup system-tests-csma CSMA System Tests
 * 
 * \brief CSMA System Tests
 */
