/* 
   01/05/2003 Nrg2Iso v 0.1

   Copyright (C) 2003 Grgory Kokanosky <gregory.kokanosky@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
 


void usage(){
  printf("Nrg2Iso by G. Kokanosky\n");
  printf("thx to Meles :)\n");
  printf("released under the GNU GPL v2 or later\n\n");

  printf("Usage\n");
  printf("nrg2iso image.nrg image.iso\n");
}


int checkIso(char *filename)
{
  int iso = 0 ;
  FILE *f;
  char buf[17*2048];
  
  if(!(f=fopen(filename,"r"))) return 0;
  
  if( fread( buf, 1,17*2048 ,f) == 17*2048 ) {

    // taken from k3b
    // check if this is an iso9660-image
    // the beginning of the 16th sector needs to have the following format:
    
    // first byte: 1
    // second to 11th byte: 67, 68, 48, 48, 49, 1 (CD001)
    // 12th byte: 0
    
    iso = ( buf[16*2048] == 1 &&
	    buf[16*2048+1] == 67 &&
	    buf[16*2048+2] == 68 &&
	    buf[16*2048+3] == 48 &&
	    buf[16*2048+4] == 48 &&
	    buf[16*2048+5] == 49 &&
	    buf[16*2048+6] == 1 &&
	    buf[16*2048+7] == 0 );
  }
  if(iso){
    printf("It seems that %s is already an ISO 9660 image \n",filename);
    printf("[Aborting conversion]\n");
  }

  
  fclose(f);
 return iso;
}



int main(int argc, char **argv){
  FILE *nrgFile, *isoFile;
  char buffer[1048576];
  int i=0,j=0;
  int size=0,k=0,l;
  int nrgSize=0;
  float pourcent=0.0;
  struct stat buf;
  
  if(argc!=3 ||(argc==2 && strcmp(argv[1],"--help")==0)){
    usage();
  }
  else {
    
    if( stat(argv[1],&buf)==0){
      
      if(!checkIso(argv[1])){
      
	nrgSize = buf.st_size;
	nrgFile=fopen(argv[1],"r");
	fseek (nrgFile, 307200, SEEK_SET);
	
	isoFile=fopen(argv[2],"w+");
	
	while((i=  fread( buffer, 1, 1048576, nrgFile ))>0){
	  fwrite(buffer,i,1,isoFile);

	  size+=i;
	  pourcent = (100.0*size)/nrgSize;
	 
	  if(j==10){
	    j=0;
	    k++;
	    printf("\r");
	    printf("|");
	      for(l=0;l<k;l++)
		printf("=");
	    printf(">[%d\%%]",(int)pourcent);
	    fflush(stdout);
	  }
	  j++;
	}
	
	printf("\r");
	printf("|");
	for(l=0;l<k+1;l++)
	  printf("=");
	printf(">[100%%]");
	fflush(stdout);
	  
	fclose(nrgFile);
	fclose(isoFile);
	printf("\n%s written : %d bytes\n",argv[2],size);
      }
    }
    else 
      printf("%s : No such file\n",argv[1]);
  }
  

  return 0;
  
}
