////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Implements interface creation (main window, password dialog, options dialog, ...)
////////////////////////////////////////////////////////////////////////////

#include "config.h"

#ifdef _WIN32
 #pragma warning(disable: 4786)
#endif

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef _WIN32
 #include <unistd.h>
#endif 

#include "lib/NoteDocument.h"
#include "lib/DocumentIterator.h"
#include "lib/IniFile.h"
#include "lib/FilePath.h"
#include "lib/DocActionManager.h"
#include "DocAction.h"
#include "mru.h"

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "TreeView.h"
#include "TextView.h"
#include "MainWnd.h"

#ifdef _WIN32
 #include "_win/RegisterExtension.h"
 #include <windows.h>
#endif

extern NoteDocument g_doc;
extern GtkWidget *window1;
extern DocActionManager g_undoManager;
TreeView g_tree;
TextView g_text;
MainWindow g_wnd;

int load_file(const char *filename);
void UpdateTextFromScreen();
void register_extensions_check();
int gtkMessageBox(const char *szText, int nButtons = GTK_BUTTONS_OK, int nIcon = GTK_MESSAGE_INFO);
void set_title_bar(const char *szText);

gboolean treeview1_popup_menu_event_handler (GtkWidget *widget, GdkEventButton *event, gpointer user_data);	
void cell_edited_callback(GtkCellRendererText *cell, gchar *path_string, gchar *new_text, gpointer user_data);
void on_MRU_activate (GtkMenuItem *menuitem, gpointer user_data);

//
// MRU list
//
MRU g_objMRU;
GtkWidget *g_menuitem5;

//
static void do_popup_menu (GtkWidget *my_widget, GdkEventButton *event)
{
	GtkWidget *menu, *submenu;
	GtkWidget *menu_item, *move_item;
	int button, event_time;
	
	menu = gtk_menu_new ();
	//g_signal_connect (menu, "deactivate", G_CALLBACK(gtk_widget_destroy), NULL);

	GtkAccelGroup *accel_group = gtk_accel_group_new();
	gtk_menu_set_accel_group (GTK_MENU (menu), accel_group);

	// ... add menu items with accelerators ... 
	menu_item = gtk_menu_item_new_with_label(_("Insert Node"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_insert_node), NULL);
	gtk_menu_append(menu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Insert, (GdkModifierType)0, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));

	menu_item = gtk_menu_item_new_with_label(_("Insert Child Node"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_insert_child_node), NULL);
	gtk_menu_append(menu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Insert, (GdkModifierType)GDK_SHIFT_MASK, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));

	menu_item = gtk_menu_item_new_with_label(_("Delete Node"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_delete_node), NULL);
	gtk_menu_append(menu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Delete, (GdkModifierType)0, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));
	
	menu_item = gtk_menu_item_new_with_label(_("Rename Node"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_rename_node), NULL);
	gtk_menu_append(menu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_F2, (GdkModifierType)0, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));
	
	move_item = gtk_menu_item_new_with_label(_("Move Node"));
	gtk_menu_append(menu, move_item);
	gtk_widget_show (move_item);  // Show the widget 

	menu_item = gtk_menu_item_new_with_label(_("Expand All"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_expand_all), NULL);
	gtk_menu_append(menu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 

	menu_item = gtk_menu_item_new_with_label(_("Collapse All"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_collapse_all), NULL);
	gtk_menu_append(menu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 

	menu_item = gtk_menu_item_new_with_label(_("Node Properties"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_node_properties), NULL);
	gtk_menu_append(menu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Return, (GdkModifierType)GDK_CONTROL_MASK, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));

	//"move node" submenu
	submenu = gtk_menu_new ();
	
	menu_item = gtk_menu_item_new_with_label(_("Up"));
	gtk_menu_append(submenu, menu_item);
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_move_up), NULL);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Up, (GdkModifierType)GDK_SHIFT_MASK, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));
	
	menu_item = gtk_menu_item_new_with_label(_("Down"));
	gtk_menu_append(submenu, menu_item);
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_move_down), NULL);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Down, (GdkModifierType)GDK_SHIFT_MASK, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));
	
	menu_item = gtk_menu_item_new_with_label(_("Left"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_move_left), NULL);
	gtk_menu_append(submenu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Left, (GdkModifierType)GDK_SHIFT_MASK, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));
	
	menu_item = gtk_menu_item_new_with_label(_("Right"));
	g_signal_connect(menu_item, "activate",	G_CALLBACK (on_menu_move_right), NULL);
	gtk_menu_append(submenu, menu_item);
	gtk_widget_show (menu_item);  // Show the widget 
	gtk_widget_add_accelerator (menu_item, "activate", accel_group, GDK_Right, (GdkModifierType)GDK_SHIFT_MASK, (GtkAccelFlags)(GTK_ACCEL_VISIBLE));

	gtk_menu_item_set_submenu (GTK_MENU_ITEM (move_item), submenu);
	
	if (event)
		event_time = event->time;
	else
		event_time = gtk_get_current_event_time ();
	button = 0;	//FIX: allow mouse button to trigger the submenu
	
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, button, event_time);
}

gboolean treeview1_popup_menu_event_handler (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	// Ignore double-clicks and triple-clicks
	if (event->button == 3 && event->type == GDK_BUTTON_RELEASE)
		do_popup_menu (widget, event);
	return FALSE;
}

void cell_edited_callback(GtkCellRendererText *cell, gchar *path_string, gchar *new_text, gpointer user_data)
{
	//do not allow empty node titles
	if(0 == strlen(new_text))  
		return;

	//get document node index from GUI tree iterator
	GtkTreePath* path1 = gtk_tree_path_new_from_string( path_string );
	int nIdx = NodeIdxFromPath(path1);
	
	//
	//store new text into the document node
	//
	std::string strOldTitle;

	//TOFIX separate method -> SetNodeTitle(idx, szText) -> w/o undo inside
	if(nIdx > -1)
	{
		strOldTitle = g_doc.GetNodeByIdx(nIdx).GetTitle();
		g_doc.GetNodeByIdx(nIdx).SetTitle(new_text);
	}
	
	//store new text into the tree store for given cell
	GtkWidget *treeview = lookup_widget(window1, "treeview1");
	GtkTreeModel *model = gtk_tree_view_get_model((GtkTreeView *)treeview);
	
	if(nIdx > -1){
		GtkTreeIter iter;
		gtk_tree_model_get_iter(model, &iter, path1);
		gtk_tree_store_set (GTK_TREE_STORE(model), &iter, STORE_IDX_TEXT, new_text, -1);

		//update node title label
		set_title_bar(new_text);
		
		//if the name was actually changed
		if(0 != strcmp(strOldTitle.c_str(), new_text))
		{
			//push document change into undo/redo manager
			DocAction *pAction = new DocAction;
			pAction->SetType(ACT_NODE_RENAME);
			pAction->SetDoc(g_doc);
			pAction->m_nNodeIndex = nIdx;  //TOFIX recursive index
			pAction->m_strNodeNameNew = new_text;
			pAction->m_strNodeNameOld = strOldTitle;

			g_undoManager.AddAction(pAction);
			UpdateUndoRedoMenus();
			g_doc.SetModified(true);
		}

		RefreshMainTitle(); // updates modified doc state in window title bar
	}
	
	gtk_tree_path_free(path1);
}

void on_textview_edited( GtkTextBuffer *widget,
						gpointer   data )
{
	g_doc.SetModified(true);
	RefreshMainTitle();
}

//
// Helper methods
//
//TOFIX move to DocTreeNavigation or similar class ?
int NodeIdxFromPath(GtkTreePath* path1)
{
	gint* arrIndices = gtk_tree_path_get_indices(path1);
	int nMax = gtk_tree_path_get_depth(path1);
	
	int nIdx = -1;
	int nParentID = -1;
	DocumentIterator itDoc(g_doc);
	for(int i=0; i<nMax; i++)
	{
		//go to the next sibling node
		nIdx = itDoc.GetChildIdx(nParentID, arrIndices[i]);
		if(nIdx < 0)
			break;	//TOFIX assert
		nParentID = itDoc.GetNodeByIdx(nIdx).m_nID;
	}
	
	return nIdx;
}

//TOFIX move to DocTreeNavigation or similar class ?
bool PathFromNodeIdx(int nIdx, GtkTreePath *&path1)
{
	std::string strPath;
	
	//prepare path string
	while(nIdx >= 0)
	{
		//append level at start
		char szLevel[20]="";
		sprintf(szLevel, "%d:", g_doc.GetNodeByIdx(nIdx).m_nSiblingIdx);
		strPath.insert(0, szLevel);
		
		//calculate parent index
		nIdx = g_doc.GetIdxFromID(g_doc.GetNodeByIdx(nIdx).m_nParentID);
	}
	
	//strip off last ':' character
	strPath = strPath.substr(0, strPath.size()-1);
	
	//now convert that path string into the path object
	path1 = gtk_tree_path_new_from_string(strPath.c_str());
	return (path1 != NULL);
}

//TOFIX move to DocTreeNavigation or similar class ?
bool IteratorFromNodeIdx(int nIdx, GtkTreeIter &iter)
{
	GtkTreePath *path1 = NULL;
	if(!PathFromNodeIdx(nIdx, path1))
		return false;
	
	GtkWidget *treeview = lookup_widget(window1, "treeview1");
	GtkTreeModel *model = gtk_tree_view_get_model((GtkTreeView *)treeview);
	bool bResult = (FALSE != gtk_tree_model_get_iter(model, &iter, path1));
	gtk_tree_path_free(path1);
	return bResult;
}

void on_MRU_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	//pull file name from MRU list
	unsigned long nIdx = (unsigned long)user_data;

	if(nIdx < (unsigned long)g_objMRU.GetFileCount())
	{
		std::string strFile = g_objMRU.GetFile(nIdx);
		
		int nResult = load_file(strFile.c_str());

		//do not delete MRU for file that exists, but failed to open
		g_objMRU.Change(strFile.c_str(), (DOC_LOAD_NOT_FOUND != nResult));
	}
	else
	{
		int nRes = gtkMessageBox(_("Are you sure you want to delete history list?"),GTK_BUTTONS_YES_NO);
		if(GTK_RESPONSE_YES == nRes)
			g_objMRU.Clear();	//delete MRU
	}
}

void register_extensions_check()
{
#ifdef _WIN32
	std::string strApp = GetAppPath();
	std::string strCmd = strApp;
	strCmd += " %1";
	
	RegisterFileExtension reg;
	if(!reg.IsRegistered(".ncd"))
	{
		//register our unencrypted format
		reg.SetFormatName("NoteCase.PlainFormat");
		reg.SetExtension(".ncd");
		reg.SetDescription("NoteCase unencrypted file format");
		reg.SetDefaultIcon(strApp.c_str(), 0);
		reg.AddShellAction("open", strCmd.c_str());
		reg.SetShellDefault("open");
		
		reg.UpdateRegistry();
	}
	if(!reg.IsRegistered(".nce"))
	{
		//register our encrypted format
		reg.ClearData();
		reg.SetFormatName("NoteCase.EncryptedFormat");
		reg.SetExtension(".nce");
		reg.SetDescription("NoteCase encrypted file format");
		reg.SetDefaultIcon(strApp.c_str(), 0);
		reg.AddShellAction("open", strCmd.c_str());
		reg.SetShellDefault("open");

		reg.UpdateRegistry();
	}
#else
	//TOFIX linux version missing
#endif
}

void set_title_bar(const char *szText)
{
	GtkWidget *label1 = lookup_widget(window1, "label1");
	gtk_label_set_text(GTK_LABEL(label1), szText);

}
