package jnormaliz;

/**
 * Simple class to calculate elapsed times
 */
public class ElapsedTime {

    private long ini = System.currentTimeMillis();
    private long end = -1;

    /**
     *
     * @return The current number of seconds elapsed
     */
    public int getSeconds() {
        if(end == -1)
            return (int) ((System.currentTimeMillis() - ini) / 1000);
        else
            return (int) (end - ini) / 1000;
    }

    /**
     *
     * @return The elapsed time in the format hours:minutes:seconds
     */
    public String getElapsedTime() {
        final long seconds = getSeconds();
        return String.format("%d:%02d:%02d", seconds / 3600,
                (seconds % 3600) / 60, seconds % 60);
    }

    /*
     * Freezes timer
     */
    public void stop() {
        end = System.currentTimeMillis();
    }

    /**
     * Resets timer, taking the current time as the new starting point
     */
    public void reset() {
        ini = System.currentTimeMillis();
        end = -1;
    }
}
