---
layout: "docs"
page_title: "Base Plugin"
sidebar_current: "docs-internals-plugins-base"
description: |-
  Learn about how to author a Nomad plugin.
---

# Base Plugin

The base plugin is a special plugin type implemented by all plugins. It allows
for common plugin operations such as defining a configuration schema and
version information.

## Plugin API

#### `PluginInfo() (*PluginInfoResponse, error)`

A `PluginInfoResponse` contains meta data about the plugin.

```go
PluginInfoResponse{
    // Type is the plugin type which is implemented
    Type: PluginTypeDriver,
    // Plugin API versions supported by the plugin
    PluginApiVersions: []string{drivers.ApiVersion010},
    // Version of the plugin
    PluginVersion: "0.1.0",
    // Name of the plugin
    Name: "foodriver",
}
```

#### `ConfigSchema() (*hclspec.Spec, error)`

The `ConfigSchema` function allows a plugin to tell Nomad the schema for its
configuration. This configuration is given in a [plugin block][pluginblock] of
the client configuration. The schema is defined with the [hclspec][hclspec]
package.

#### `SetConfig(config *Config) error`

The `SetConfig` function is called when starting the plugin for the first
time. The `Config` given has two different configuration fields. The first
`PluginConfig`, is an encoded configuration from the `plugin` block of the
client config. The second, `AgentConfig`, is the Nomad agent's configuration
which is given to all plugins.

## HCL Specifications

`*hclspec.Spec` is a struct that defines the schema to validate an HCL entity
against. The full documentation of the different hcl attribute types can be
found on the [hclspec godoc][hclspec].

For a basic example, lets look at the driver configuration for the raw_exec
driver:

```hcl
job "example" {
...
      driver = "raw_exec"
      config {
        command = "/bin/sleep"
        args = ["100"] 
      }
}
```

The `config` block is what is validated against the `hclspec.Spec`. It has two
keys, command which takes a string attribute and args which takes an array
attribute. The corresponding `*hclspec.Spec` would be:

```go
    spec :=  hclspec.NewObject(map[string]*hclspec.Spec{
		"command": hclspec.NewAttr("command", "string", true),
		"args":    hclspec.NewAttr("args", "list(string)", false),
	})
```


[hclspec]: https://godoc.org/github.com/hashicorp/nomad/plugins/shared/hclspec
[pluginblock]: /docs/configuration/plugin.html
