// Generated by LiveScript 1.6.0
var sinon, ref$, apply, curry, flip, fix, over, memoize, eq, notEq, deepEq, ok;
sinon = require('sinon');
ref$ = require('../..').Func, apply = ref$.apply, curry = ref$.curry, flip = ref$.flip, fix = ref$.fix, over = ref$.over, memoize = ref$.memoize;
ref$ = require('assert'), eq = ref$.strictEqual, notEq = ref$.notStrictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
suite('apply', function(){
  test('empty list', function(){
    var f;
    f = function(){
      return 1;
    };
    return eq(1, apply(f, []));
  });
  test('a couple of args', function(){
    return eq(5, apply(curry$(function(x$, y$){
      return x$ + y$;
    }), [2, 3]));
  });
  return test('curried', function(){
    var f;
    f = apply(curry$(function(x$, y$){
      return x$ + y$;
    }));
    return eq(5, f([2, 3]));
  });
});
suite('curry', function(){
  return test('simple function', function(){
    var add, addCurried, addFour;
    add = function(x, y){
      return x + y;
    };
    addCurried = curry(add);
    addFour = addCurried(4);
    return eq(6, addFour(2));
  });
});
suite('flip', function(){
  return test('minus op', function(){
    return eq(10, flip(curry$(function(x$, y$){
      return x$ - y$;
    }))(5, 15));
  });
});
suite('fix', function(){
  test('single arg', function(){
    return eq(89, fix(function(fib){
      return function(n){
        switch (false) {
        case !(n <= 1):
          return 1;
        default:
          return fib(n - 1) + fib(n - 2);
        }
      };
    })(10));
  });
  return test('multi-arg variation', function(){
    return eq(89, fix(function(fib){
      return function(n, minus){
        minus == null && (minus = 0);
        switch (false) {
        case !(n - minus <= 1):
          return 1;
        default:
          return fib(n, minus + 1) + fib(n, minus + 2);
        }
      };
    })(10));
  });
});
suite('over', function(){
  test('basic', function(){
    var f;
    f = over(curry$(function(x$, y$){
      return x$ === y$;
    }), function(it){
      return it;
    });
    ok(f(2, 2));
    return ok(!f(2, 3));
  });
  return test('with accessor function', function(){
    var sameLength;
    sameLength = over(curry$(function(x$, y$){
      return x$ === y$;
    }), function(it){
      return it.length;
    });
    ok(sameLength([1, 2, 3], [4, 5, 6]));
    return ok(!sameLength([1, 2], [4, 5, 6]));
  });
});
suite('memoize', function(){
  var spy, f;
  spy = f = null;
  setup(function(){
    spy = sinon.spy(function(){
      return arguments;
    });
    return f = memoize(spy);
  });
  test('only 1 call when using the same arguments', function(){
    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10].forEach(function(){
      return f();
    });
    return ok(spy.calledOnce);
  });
  test('call again when using different arguments', function(){
    f('mung');
    f('mung');
    f('1,2');
    f([1, 2]);
    return ok(spy.calledThrice);
  });
  return test('that the correct values are returned', function(){
    eq(f('mung'), f('mung'));
    eq(f('mung', 'face'), f('mung', 'face'));
    return notEq(f('mung'), f('mung', 'face'));
  });
});
function curry$(f, bound){
  var context,
  _curry = function(args) {
    return f.length > 1 ? function(){
      var params = args ? args.concat() : [];
      context = bound ? context || this : this;
      return params.push.apply(params, arguments) <
          f.length && arguments.length ?
        _curry.call(context, params) : f.apply(context, params);
    } : f;
  };
  return _curry();
}
