---
id: more-resources
title: More Resources
---

By now you should have a good idea of how Jest can make it easy to test your applications. If you're interested in learning more, here's some related stuff you might want to check out.

## Browse the docs

- Learn about [Snapshot Testing](SnapshotTesting.md), [Mock Functions](MockFunctions.md), and more in our in-depth guides.
- Migrate your existing tests to Jest by following our [migration guide](MigrationGuide.md).
- Learn how to [configure Jest](Configuration.md).
- Look at the full [API Reference](GlobalAPI.md).
- [Troubleshoot](Troubleshooting.md) problems with Jest.

## Learn by example

You will find a number of example test cases in the [`examples`](https://github.com/facebook/jest/tree/master/examples) folder on GitHub. You can also learn from the excellent tests used by the [React](https://github.com/facebook/react/tree/master/packages/react/src/__tests__), [Relay](https://github.com/facebook/relay/tree/master/packages/react-relay/__tests__), and [React Native](https://github.com/facebook/react-native/tree/master/Libraries/Animated/src/__tests__) projects.

## Join the community

Ask questions and find answers from other Jest users like you. [Reactiflux](http://www.reactiflux.com/) is a Discord chat where a lot of Jest discussion happens. Check out the [#jest](https://discord.gg/MWRhKCj) channel.

Follow the [Jest Twitter account](https://twitter.com/fbjest) and [blog](/blog/) to find out what's happening in the world of Jest.
