/* Declarations for workspace.c.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#define TYPE_WORKSPACE (workspace_get_type())
#define WORKSPACE( obj ) (GTK_CHECK_CAST( (obj), TYPE_WORKSPACE, Workspace ))
#define WORKSPACE_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_WORKSPACE, WorkspaceClass ))
#define IS_WORKSPACE( obj ) (GTK_CHECK_TYPE( (obj), TYPE_WORKSPACE ))
#define IS_WORKSPACE_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_WORKSPACE ))

/* Three sorts of workspace file load.
 */
typedef enum {
	WORKSPACE_LOAD_TOP,	/* Load as new workspace */
	WORKSPACE_LOAD_COLUMNS,	/* Merge columns into current workspace */
	WORKSPACE_LOAD_ROWS	/* Merge rows into current column */
} WorkspaceLoadType;

/* Save mode ... controls behaviour of column_save_test() and row_save_test()
 */
typedef enum {
	WORKSPACE_SAVE_ALL,	/* Save all rows */
	WORKSPACE_SAVE_SELECTED	/* Only save selected rows */
} WorkspaceSaveType;

/* A workspace.
 */
struct _Workspace {
	Symbol sym;

	/* State.
	 */
	int next;		/* Index for next column name */
	Column *current;	/* Current column */
	GSList *selected;	/* Rows selected in this workspace */
	GSList *errors;		/* Rows with errors */
	gboolean ontop;		/* This is workspace_current */

	/* Control load/save for this ws.
	 */
	WorkspaceLoadType load_type;
	WorkspaceSaveType save_type;

	/* Set during ws load as hints for display.
	 */
	Symbol *last_symbol;
	Column *last_column;

	Rect area;		/* Rect enclosing the set of columns */
	Rect vp;		/* Viewport hint ... set by views */

	int auto_save_timeout;	/* Timeout for next autosave */
};

typedef struct _WorkspaceClass {
	SymbolClass parent_class;

	/* Methods.
	 */
} WorkspaceClass;

Workspacegroup *workspace_get_workspacegroup( Workspace *ws );

void *workspace_map( workspace_map_fn fn, void *a, void *b );
void *workspace_map_column( Workspace *ws, column_map_fn fn, void *a );
void *workspace_map_symbol( Workspace *ws, symbol_map_fn fn, void *a );
void *workspace_map_view( Workspace *ws, view_map_fn fn, void *a );

void *workspace_selected_map( Workspace *ws, row_map_fn fn, void *a, void *b );
void *workspace_selected_map_sym( Workspace *ws, 
	symbol_map_fn fn, void *a, void *b );
gboolean workspace_selected_any( Workspace *ws );
int workspace_selected_num( Workspace *ws );
gboolean workspace_selected_sym( Workspace *ws, Symbol *sym );
Row *workspace_selected_one( Workspace *ws );
void workspace_deselect_all( Workspace *ws );
void workspace_selected_names( Workspace *ws, BufInfo *buf, char *separator );
void workspace_select_all( Workspace *ws );
Column *workspace_is_one_empty( Workspace *ws );

Column *workspace_column_find( Workspace *ws, const char *name );
Column *workspace_column_get( Workspace *ws, const char *name );
char *workspace_column_name_new( Workspace *ws, xmlNode *columns );
Column *workspace_column_pick( Workspace *ws );
void workspace_column_select( Workspace *ws, Column *col );

Symbol *workspace_add_symbol( Workspace *ws );
Symbol *workspace_add_def( Workspace *ws, const char *str );

gboolean workspace_selected_save( Workspace *ws, const char *filename );
gboolean workspace_clone_selected( Workspace *ws );

void workspace_checkmark( Workspace *ws );
void workspace_retain_clean( void );
gboolean workspace_auto_recover( void );

GtkType workspace_get_type( void );
Workspace *workspace_new( Workspacegroup *wsg, const char *name );
Workspace *workspace_new_from_file( Workspacegroup *wsg, const char *fname );
gboolean workspace_merge_file( Workspace *ws, const char *fname );
gboolean workspace_merge_column_file( Workspace *ws, const char *fname );
void workspace_set_modified( Symbol *sym );

Row *workspace_get_bottom( Workspace *ws );

void workspace_symbol_action( Workspace *ws, Symbol *sym );

void workspace_new_column( Workspace *ws );

int workspace_number( void );
