/* a toggle button ... put/get methods
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#include "ip.h"

/*
#define DEBUG
 */

static ClassmodelClass *parent_class = NULL;

static void
toggle_destroy( GtkObject *object )
{
	Toggle *tog;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_TOGGLE( object ) );

	tog = TOGGLE( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Widgets for toggle edit.
 */
typedef struct _ToggleEdit {
	iDialog *idlg;

	Toggle *toggle;

	GtkWidget *caption;
	GtkWidget *value;
} ToggleEdit;

/* Done button hit.
 */
/*ARGSUSED*/
static void
toggle_done_cb( iWindow *iwnd, void *client, 
	iWindowNotifyFn nfn, void *sys )
{
	ToggleEdit *eds = (ToggleEdit *) client;
	Toggle *toggle = eds->toggle;
	Classmodel *classmodel = CLASSMODEL( toggle );

	gboolean value = GTK_TOGGLE_BUTTON( eds->value )->active;
	const char *caption = gtk_editable_get_chars( 
		GTK_EDITABLE( eds->caption ), 0, -1 );

	/* Reset toggle.
	 */
	toggle->value = value;
	model_set( MODEL( toggle ), NULL, caption );

	/* Rebuild object.
	 */
	classmodel_update( classmodel );
	symbol_recalculate_all();

	nfn( sys, IWINDOW_TRUE );
}

/* Build the insides of toggle edit.
 */
static void
toggle_buildedit( iDialog *idlg, GtkWidget *vb, ToggleEdit *eds )
{
	Toggle *toggle = eds->toggle;

        eds->caption = build_glabeltext2( vb, "Caption:", 15 );
	idialog_init_entry( idlg, eds->caption,
		"Set toggle caption here", "%s", MODEL( toggle )->caption );

        eds->value = build_gtoggle( vb, "State" );
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( eds->value ), 
		toggle->value );
	set_tooltip( eds->value, "Set toggle state here" );

        gtk_widget_show_all( vb );
}

/* Pop up a toggle edit box.
 */
static void 
toggle_edit( GtkWidget *parent, Model *model )
{
	Toggle *toggle = TOGGLE( model );
	ToggleEdit *eds = IM_NEW( NULL, ToggleEdit );
	GtkWidget *idlg;

	eds->toggle = toggle;

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), "Edit toggle" );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) toggle_buildedit, eds, NULL, NULL );
	idialog_set_callbacks( IDIALOG( idlg ), 
		iwindow_true_cb, NULL, NULL, idialog_free_client, eds );
	idialog_add_ok( IDIALOG( idlg ), toggle_done_cb, "Set toggle" );
	idialog_set_parent( IDIALOG( idlg ), parent );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

static xmlNode *
toggle_save( Model *model, xmlNode *xnode )
{
	Toggle *toggle = TOGGLE( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_sprop( xthis, "value", 
			bool_to_char( toggle->value ) ) )
			return( NULL );
	}

	return( xthis );
}

static gboolean
toggle_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Toggle *toggle = TOGGLE( model );

	if( !IS_RHS( parent ) ) {
		ierrors( "toggle_load: can only add a toggle to a rhs" );
		return( FALSE );
	}

	if( get_bprop( xnode, "value", &toggle->value ) )
		classmodel_set_edited( CLASSMODEL( model ), TRUE );

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

static gboolean
toggle_class_get( Classmodel *classmodel, PElement *root )
{
	Toggle *toggle = TOGGLE( classmodel );
	char buf[MAX_STRSIZE];

	if( !class_get_member_string( root, MEMBER_CAPTION, 
		buf, MAX_STRSIZE ) ||
		!class_get_member_bool( root, MEMBER_VALUE, &toggle->value ) )
		return( FALSE );

	model_set( MODEL( classmodel ), NULL, buf );

	return( TRUE );
}

/* Make a new "fn caption value" application.
 */
static gboolean
toggle_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *hi = reduce_context->hi;
	Toggle *toggle = TOGGLE( classmodel );

	PElement rhs;

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( hi, out, &rhs ) ||
		!heap_string_new( hi, MODEL( classmodel )->caption, &rhs ) ||
		!heap_appl_add( hi, out, &rhs ) ||
		!heap_bool_new( hi, toggle->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
toggle_class_init( ToggleClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_CLASSMODEL );

	object_class->destroy = toggle_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = toggleview_new;
	model_class->edit = toggle_edit;
	model_class->save = toggle_save;
	model_class->load = toggle_load;

	classmodel_class->class_get = toggle_class_get;
	classmodel_class->class_new = toggle_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
toggle_init( Toggle *toggle )
{
        toggle->value = FALSE;

	model_set( MODEL( toggle ), CLASS_TOGGLE, NULL );
}

GtkType
toggle_get_type( void )
{
	static GtkType toggle_type = 0;

	if( !toggle_type ) {
		static const GtkTypeInfo info = {
			"Toggle",
			sizeof( Toggle ),
			sizeof( ToggleClass ),
			(GtkClassInitFunc) toggle_class_init,
			(GtkObjectInitFunc) toggle_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		toggle_type = gtk_type_unique( TYPE_CLASSMODEL, &info );
	}

	return( toggle_type );
}

Classmodel *
toggle_new( Rhs *rhs )
{
	Toggle *tog = gtk_type_new( TYPE_TOGGLE );

	model_child_add( MODEL( rhs ), MODEL( tog ), -1 );

	return( CLASSMODEL( tog ) );
}
