/* a subcolumnview button in a workspace
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* 
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
subcolumnview_destroy( GtkObject *object )
{
	Subcolumnview *sview;

#ifdef DEBUG
	printf( "subcolumnview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_SUBCOLUMNVIEW( object ) );

	sview = SUBCOLUMNVIEW( object );

	/* When we go, our table will be destroyed, and with it, all the
	 * widgets making up our rowviews. However, that won't trigger the
	 * rowview_destroys ... rowviews are not proper widgets, they're
	 * really part of us.
	 *
	 * Trigger rowview_destroys explicitiy.
	 */
	view_map( VIEW( sview ),
		(view_map_fn) object_destroy, NULL, NULL );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Event in the column event_box ... pass down to the appropriate widget.
 */
static gboolean
subcolumnview_event_cb( GtkWidget *widget, GdkEvent *ev, Subcolumnview *sview )
{
	gboolean used = FALSE;
        GtkWidget *child;

        if( !sview->ebox )
                return( FALSE );
        if( ev->any.window != sview->ebox->window )
                return( FALSE );
        if( ev->type != GDK_BUTTON_PRESS && ev->type != GDK_BUTTON_RELEASE )
                return( FALSE );
        if( !(child = table_find_child( sview->table, 
		ev->button.x, ev->button.y )) )
                return( FALSE );

	/* Click on various things we define ... pass down for further testing.
	 */
        if( IS_VIEW( child ) ) {
                if( view_event( VIEW( child ), ev ) ) {
			gtk_signal_emit_stop_by_name( 
				GTK_OBJECT( widget ), "event" );
			used = TRUE;
		}
        }

        return( used );
}

static void *
subcolumnview_refresh_sub( Rowview *rview, Subcolumnview *sview )
{
	Subcolumn *scol = SUBCOLUMN( VIEW( sview )->model );
	Row *row = ROW( VIEW( rview )->model );
	int i;

	/* Most predicates need a sym.
	 */
	if( !row->sym )
		return( NULL );

	for( i = 0; i <= scol->vislevel; i++ )
		if( subcolumn_visibility[i].pred( row ) ) {
			rowview_set_visible( rview, TRUE );
			sview->nvis++;
			break;
		}
	if( i > scol->vislevel )
		rowview_set_visible( rview, FALSE );

	return( NULL );
}

static void 
subcolumnview_refresh( View *view )
{
	Subcolumnview *sview = SUBCOLUMNVIEW( view );
	Subcolumn *scol = SUBCOLUMN( VIEW( sview )->model );
	int model_rows = model_get_n_children( MODEL( scol ) );
	int old_nvis = sview->nvis;

#ifdef DEBUG
	printf( "subcolumnview_refresh\n" );
#endif /*DEBUG*/

	if( sview->rows != model_rows ) {
		sview->rows = model_rows;
		gtk_table_resize( GTK_TABLE( sview->table ), sview->rows, 4 );

#ifdef DEBUG
		printf( "subcolumnview_refresh: resize to %d rows\n",
			sview->rows );
#endif /*DEBUG*/
	}

	sview->nvis = 0;
	(void) view_map( view, 
		(view_map_fn) subcolumnview_refresh_sub, sview, NULL );

	if( sview->nvis != old_nvis ) {
		view_resize( view );
		model_changed( MODEL( scol->top_col ) );
	}

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
subcolumnview_link( View *view, Model *model, View *parent )
{
	Subcolumnview *sview = SUBCOLUMNVIEW( view );
	Subcolumn *scol = SUBCOLUMN( model );

#ifdef DEBUG
	printf( "subcolumnview_link: " );
	if( HEAPMODEL( scol )->row )
		row_name_print( HEAPMODEL( scol )->row );
	else
		printf( "(null)" );
	printf( "\n" );
#endif /*DEBUG*/

	VIEW_CLASS( parent_class )->link( view, model, parent );

	/* Add to enclosing column, if there is one. Attached to enclosing row
	 * by rowview_refresh() if we're a subcolumn.
	 */
	if( scol->istop ) {
		sview->cview = COLUMNVIEW( parent );

		gtk_container_add( GTK_CONTAINER( sview->cview->frame ), 
			GTK_WIDGET( sview ) );
	}
	else 
		sview->rhsview = RHSVIEW( parent );

	gtk_widget_show( GTK_WIDGET( sview ) );
}

static void
subcolumnview_class_init( SubcolumnviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	ViewClass *view_class = (ViewClass*) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = subcolumnview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = subcolumnview_refresh;
	view_class->link = subcolumnview_link;
}

static void
subcolumnview_init( Subcolumnview *sview )
{
	sview->cview = NULL;
	sview->rhsview = NULL;

        sview->ebox = NULL;
        sview->table = NULL;
        sview->rows = 0;
        sview->nvis = 0;

        sview->table = gtk_table_new( sview->rows, 4, FALSE );
        sview->ebox = gtk_event_box_new();
        gtk_container_add( GTK_CONTAINER( sview->ebox ), sview->table );
        gtk_signal_connect( GTK_OBJECT( sview->ebox ), "event",
                GTK_SIGNAL_FUNC( subcolumnview_event_cb ), sview );
        gtk_box_pack_start( GTK_BOX( sview ), sview->ebox, FALSE, FALSE, 0 );
        gtk_widget_show_all( sview->ebox );
}

GtkType
subcolumnview_get_type( void )
{
	static GtkType subcolumnview_type = 0;

	if (!subcolumnview_type) {
		static const GtkTypeInfo sview_info = {
			"Subcolumnview",
			sizeof( Subcolumnview ),
			sizeof( SubcolumnviewClass ),
			(GtkClassInitFunc) subcolumnview_class_init,
			(GtkObjectInitFunc) subcolumnview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		subcolumnview_type = gtk_type_unique( TYPE_VIEW, &sview_info );
	}

	return( subcolumnview_type );
}

View *
subcolumnview_new( void )
{
	Subcolumnview *sview = gtk_type_new( TYPE_SUBCOLUMNVIEW );

	return( VIEW( sview ) );
}
