/* a pair of spin buttons, with no entry ... don't actually use buttons,
 * since we may have lots and lots of these, and we don't want to make an X
 * window for each one
 *
 * we do the event handling ourselves ... our enclosing view passes the ev 
 * to spin_event(), this triggers signals as required
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

/* 
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

/* Our signals. Up and down click.
 */
enum {
	UP_CLICK,
	DOWN_CLICK,
	LAST_SIGNAL
};

static guint spin_signals[LAST_SIGNAL] = { 0 };

static void
spin_destroy( GtkObject *object )
{
	Spin *spin;

	g_return_if_fail( object != NULL);
	g_return_if_fail( IS_SPIN( object ) );

	spin = SPIN( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Default up and down signal handlers.
 */
static void
spin_real_up_click( Spin *spin )
{
#ifdef DEBUG
	printf( "spin_real_up_click\n" );
#endif /*DEBUG*/
}

static void
spin_real_down_click( Spin *spin )
{
#ifdef DEBUG
	printf( "spin_real_down_click\n" );
#endif /*DEBUG*/
}

static void
allocation2rect( GtkAllocation *from, Rect *to )
{
        to->left = from->x;
        to->top = from->y;
        to->width = from->width;
        to->height = from->height;
}

typedef struct {
	Spin *spin;
	GdkEvent *ev;
	gboolean handled;
} SpinEvent;

static void
spin_value_event_test( GtkWidget *widget, gpointer data )
{
	SpinEvent *sev = (SpinEvent *) data;
	Rect pos;

	if( sev->handled )
		return;

	allocation2rect( &widget->allocation, &pos );
	if( im_rect_includespoint( &pos, 
		sev->ev->button.x, sev->ev->button.y ) ) {
		if( GTK_IS_ARROW( widget ) ) {
			sev->handled = TRUE;

			if( GTK_ARROW( widget )->arrow_type == GTK_ARROW_UP )
				gtk_signal_emit( GTK_OBJECT( sev->spin ), 
					spin_signals[UP_CLICK] );
			else
				gtk_signal_emit( GTK_OBJECT( sev->spin ), 
					spin_signals[DOWN_CLICK] );
		}
	}
}

/* Call this with an event we think ought to be in this widget.
 */
static gboolean 
spin_event( View *view, GdkEvent *ev )
{
	Spin *spin = SPIN( view );
	SpinEvent sev;

#ifdef DEBUG
	printf( "spin_event\n" );
#endif /*DEBUG*/

        if( ev->type != GDK_BUTTON_RELEASE )
                return( FALSE );

	sev.spin = spin;
	sev.ev = ev;
	sev.handled = FALSE;
	gtk_container_foreach( GTK_CONTAINER( spin ), 
		spin_value_event_test, (gpointer) &sev );

	return( sev.handled );
}

static void
spin_class_init( SpinClass *klass )
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;
	ViewClass *view_class;

	object_class = (GtkObjectClass *) klass;
	widget_class = (GtkWidgetClass *) klass;
	view_class = (ViewClass *) klass;

	parent_class = (ViewClass *) gtk_type_class( TYPE_VIEW );

	object_class->destroy = spin_destroy;

	/* Create signals.
         */
	spin_signals[UP_CLICK] = gtk_signal_new( "up_click",
		GTK_RUN_FIRST,
		object_class->type,
		GTK_SIGNAL_OFFSET( SpinClass, up_click ),
		gtk_marshal_NONE__NONE,
		GTK_TYPE_NONE, 1,
		GTK_TYPE_NONE );
	spin_signals[DOWN_CLICK] = gtk_signal_new( "down_click",
		GTK_RUN_FIRST,
		object_class->type,
		GTK_SIGNAL_OFFSET( SpinClass, down_click ),
		gtk_marshal_NONE__NONE,
		GTK_TYPE_NONE, 1,
		GTK_TYPE_NONE );

	gtk_object_class_add_signals( object_class, spin_signals, LAST_SIGNAL );

	view_class->event = spin_event;

	klass->up_click = spin_real_up_click;
	klass->down_click = spin_real_down_click;
}

static void
spin_init( Spin *spin )
{
	spin->up = gtk_arrow_new( GTK_ARROW_UP, GTK_SHADOW_OUT );
        spin->down = gtk_arrow_new( GTK_ARROW_DOWN, GTK_SHADOW_OUT );
        gtk_box_pack_start( GTK_BOX( spin ), spin->up, FALSE, FALSE, 0 );
        gtk_box_pack_start( GTK_BOX( spin ), spin->down, FALSE, FALSE, 0 );
	gtk_widget_show( spin->up );
        gtk_widget_show( spin->down );
}

GtkType
spin_get_type( void )
{
	static GtkType spin_type = 0;

	if (!spin_type) {
		static const GtkTypeInfo spin_info = {
			"Spin",
			sizeof( Spin ),
			sizeof( SpinClass ),
			(GtkClassInitFunc) spin_class_init,
			(GtkObjectInitFunc) spin_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		spin_type = gtk_type_unique( TYPE_VIEW, &spin_info );
	}

	return( spin_type );
}

GtkWidget *
spin_new( void )
{
	Spin *spin = (Spin *) gtk_type_new( TYPE_SPIN );

	return( GTK_WIDGET( spin ) );
}
