/* run the display for an image in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#define DISPLAY_THUMBNAIL (watch_int_get( "DISPLAY_THUMBNAIL", 64 ))

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
realview_destroy( GtkObject *object )
{
	Realview *realview;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_REALVIEW( object ) );

	realview = REALVIEW( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void 
realview_refresh( View *view )
{
	Realview *realview = REALVIEW( view );
	Real *real = REAL( view->model );

#ifdef DEBUG
	printf( "realview_refresh\n" );
#endif /*DEBUG*/

	set_glabel( realview->label, "%s", buf_all( &real->caption ) );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
realview_class_init( RealviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = realview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = realview_refresh;
}

static void
realview_init( Realview *realview )
{
	GtkWidget *eb;

#ifdef DEBUG
	printf( "realview_init\n" );
#endif /*DEBUG*/

        eb = gtk_event_box_new();
        gtk_box_pack_start( GTK_BOX( realview ), eb, FALSE, FALSE, 0 );

	realview->label = gtk_label_new( "" );
        gtk_misc_set_alignment( GTK_MISC( realview->label ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( realview->label ), 2, 0 );
        gtk_container_add( GTK_CONTAINER( eb ), realview->label );
	set_name( eb, "caption_widget" );

        gtk_widget_show_all( GTK_WIDGET( realview ) );
}

GtkType
realview_get_type( void )
{
	static GtkType realview_type = 0;

	if( !realview_type ) {
		static const GtkTypeInfo info = {
			"Realview",
			sizeof( Realview ),
			sizeof( RealviewClass ),
			(GtkClassInitFunc) realview_class_init,
			(GtkObjectInitFunc) realview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		realview_type = gtk_type_unique( TYPE_VIEW, &info );
	}

	return( realview_type );
}

View *
realview_new( void )
{
	Realview *realview = gtk_type_new( TYPE_REALVIEW );

	return( VIEW( realview ) );
}
