/* widgets for the paintbox bar
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static GtkFrameClass *parent_class = NULL;

/* The popup menu.
 */
static GtkWidget *paintboxview_menu = NULL;

/* Cursor shape, indexed by PaintboxTool.
 */
iWindowShape paintboxview_shape[] = {
	IWINDOW_SHAPE_DROPPER,		/* PAINTBOX_DROPPER */
	IWINDOW_SHAPE_PEN,		/* PAINTBOX_PEN */
	IWINDOW_SHAPE_PEN,		/* PAINTBOX_LINE */
	IWINDOW_SHAPE_RECT,		/* PAINTBOX_RECT */
	IWINDOW_SHAPE_FLOOD,		/* PAINTBOX_FLOOD */
	IWINDOW_SHAPE_FLOOD,		/* PAINTBOX_BLOB */
	IWINDOW_SHAPE_TEXT,		/* PAINTBOX_TEXT */
	IWINDOW_SHAPE_SMUDGE,		/* PAINTBOX_SMUDGE */
	IWINDOW_SHAPE_SMEAR		/* PAINTBOX_SMEAR */
};

static void
paintboxview_destroy( GtkObject *object )
{
	Paintboxview *pbv;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_PAINTBOXVIEW( object ) );

	pbv = PAINTBOXVIEW( object );

	/* My instance destroy stuff.
	 */
	FREESID( pbv->conv_changed_sid, pbv->iv->conv );
	FREESID( pbv->conv_destroy_sid, pbv->iv->conv );
	FREESID( pbv->ii_undo_changed_sid, pbv->ii );
	FREESID( pbv->ii_destroy_sid, pbv->ii );
	pbv->ii = NULL;

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Hide this paintboxview.
 */
static void
paintboxview_hide_cb( GtkWidget *menu, GtkWidget *host, Paintboxview *pbv )
{
	imageview_set_paint( pbv->iv, FALSE );
}

static void
paintboxview_class_init( PaintboxviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;

	GtkWidget *pane;

	parent_class = gtk_type_class( GTK_TYPE_FRAME );

	object_class->destroy = paintboxview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */

	pane = paintboxview_menu = popup_build( "Paintbox bar menu" );
	popup_add_but( pane, "Hide", paintboxview_hide_cb );
}

/* New tool selected.
 */
static void
paintboxview_new_tool_cb( GtkWidget *wid, Paintboxview *pbv )
{
	const PaintboxTool paintbox_tool = 
		(PaintboxTool) get_goption( pbv->tool );

	if( pbv->iv->conv->paintbox_tool != paintbox_tool ) {
		pbv->iv->conv->paintbox_tool = paintbox_tool;

		model_changed( MODEL( pbv->iv->conv ) );
	}
}

/* New nib selected.
 */
static void
paintboxview_new_nib_cb( GtkWidget *wid, Paintboxview *pbv )
{
	const PaintboxNib paintbox_nib = 
		(PaintboxNib) get_goption( pbv->nib );

	if( pbv->iv->conv->paintbox_nib != paintbox_nib ) {
		pbv->iv->conv->paintbox_nib = paintbox_nib;

		model_changed( MODEL( pbv->iv->conv ) );
	}
}

/* Widgets for font edit.
 */
typedef struct _FontEdit {
	iDialog *idlg;

	Paintboxview *pbv;

	GtkWidget *font_widget;
} FontEdit;

/* Done button hit.
 */
static void
paintboxview_font_done_cb( iWindow *iwnd, void *client, 
	iWindowNotifyFn nfn, void *sys )
{
	FontEdit *eds = (FontEdit *) client;
	GtkFontSelection *fontsel = GTK_FONT_SELECTION( eds->font_widget );
	Paintboxview *pbv = eds->pbv;
	Conversion *conv = pbv->iv->conv;

	if( gtk_font_selection_get_font( fontsel ) ) {
		SETSTR( conv->paintbox_font_name,
			gtk_font_selection_get_font_name( 
				GTK_FONT_SELECTION( eds->font_widget ) ) ); 

		FREEF( gdk_font_unref, conv->paintbox_font );
		conv->paintbox_font = gtk_font_selection_get_font( fontsel );
		gdk_font_ref( conv->paintbox_font );

		nfn( sys, IWINDOW_TRUE );
	}
	else {
		ierrors( "no such font" );
		nfn( sys, IWINDOW_FALSE );
	}
}

/* Build the insides of font edit.
 */
static void
paintboxview_font_buildedit( iDialog *idlg, GtkWidget *work, FontEdit *eds )
{
	eds->font_widget = gtk_font_selection_new();
	gtk_font_selection_set_font_name( 
		GTK_FONT_SELECTION( eds->font_widget ), 
		eds->pbv->iv->conv->paintbox_font_name );
        gtk_box_pack_start( GTK_BOX( work ), 
		eds->font_widget, TRUE, TRUE, 2 );

        gtk_widget_show_all( work );
}

/* Pop up a font edit box.
 */
static void 
paintboxview_font_edit( GtkWidget *parent, Paintboxview *pbv )
{
	FontEdit *eds = IM_NEW( NULL, FontEdit );
	GtkWidget *idlg;

	eds->pbv = pbv;

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), "Select font" );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) paintboxview_font_buildedit, eds, NULL, NULL );
	idialog_set_callbacks( IDIALOG( idlg ), 
		iwindow_true_cb, NULL, NULL, idialog_free_client, eds );
	idialog_add_ok( IDIALOG( idlg ), 
		paintboxview_font_done_cb, "Set font" );
	idialog_set_parent( IDIALOG( idlg ), parent );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

static void
paintboxview_font_cb( GtkWidget *widget, Paintboxview *pbv )
{
	paintboxview_font_edit( GTK_WIDGET( pbv->iv ), pbv );
}

static void
paintboxview_undo_cb( GtkWidget *widget, Paintboxview *pbv )
{
	imageinfo_undo( pbv->iv->conv->ii );
	imagepresent_paint_recalc( pbv->iv->ip );
}

static void
paintboxview_redo_cb( GtkWidget *widget, Paintboxview *pbv )
{
	imageinfo_redo( pbv->iv->conv->ii );
	imagepresent_paint_recalc( pbv->iv->ip );
}

static void
paintboxview_clear_cb2( iWindow *iwnd, void *client, 
	iWindowNotifyFn nfn, void *sys )
{
	Paintboxview *pbv = PAINTBOXVIEW( client );

	imageinfo_undo_clear( pbv->iv->conv->ii );

	nfn( sys, IWINDOW_TRUE );
}

static void
paintboxview_clear_cb( GtkWidget *widget, Paintboxview *pbv )
{
	box_yesno( GTK_WIDGET( pbv->iv ),
		paintboxview_clear_cb2, iwindow_true_cb, pbv,
		iwindow_notify_null, NULL,
		"Clear all undo",
		"are you sure you want to clear all undo/redo buffers?" );
}

static void
paintboxview_text_changed_cb( GtkWidget *widget, Paintboxview *pbv )
{
	char *text = gtk_entry_get_text( GTK_ENTRY( pbv->text ) );

	SETSTR( pbv->iv->conv->paintbox_text, text );
}

static void
paintboxview_init( Paintboxview *pbv )
{
	/* Order important! Keep in sync with PaintboxTool.
	 */
	static const char *tool_names[] = {
		"Dropper",		/* PAINTBOX_DROPPER */
		"Pen",			/* PAINTBOX_PEN */
		"Line draw",		/* PAINTBOX_LINE */
		"Rectangle fill",	/* PAINTBOX_RECT */
		"Flood",		/* PAINTBOX_FLOOD */
		"Flood blob",		/* PAINTBOX_BLOB */
		"Text",			/* PAINTBOX_TEXT */
		"Smudge" 		/* PAINTBOX_SMUDGE */
	};

	static const char *nib_names[] = {
		"1 round",		/* PAINTBOX_1ROUND */
		"2 round",		/* PAINTBOX_2ROUND */
		"3 round",		/* PAINTBOX_3ROUND */
		"4 round",		/* PAINTBOX_4ROUND */
		"5 round",		/* PAINTBOX_5ROUND */
		"6 round",		/* PAINTBOX_6ROUND */
		"10 round",		/* PAINTBOX_10ROUND */
		"2 italic",		/* PAINTBOX_2ITALIC */
		"3 italic",		/* PAINTBOX_3ITALIC */
		"4 italic",		/* PAINTBOX_4ITALIC */
		"5 italic",		/* PAINTBOX_5ITALIC */
		"6 italic",		/* PAINTBOX_6ITALIC */
		"10 italic"		/* PAINTBOX_10ITALIC */
	};

	GtkWidget *eb;
	GtkWidget *hb;
	GtkWidget *label;

	pbv->iv = NULL;

	pbv->conv_changed_sid = 0;
	pbv->conv_destroy_sid = 0;

	pbv->ii_undo_changed_sid = 0;
	pbv->ii_destroy_sid = 0;
	pbv->ii = NULL;

        gtk_frame_set_shadow_type( GTK_FRAME( pbv ), GTK_SHADOW_OUT );

	eb = gtk_event_box_new();
        gtk_container_add( GTK_CONTAINER( pbv ), eb );
        popup_attach( eb, paintboxview_menu, pbv );

	hb = gtk_hbox_new( FALSE, 4 );
        gtk_container_set_border_width( GTK_CONTAINER( hb ), 1 );
        gtk_container_add( GTK_CONTAINER( eb ), hb );

	pbv->undo = gtk_button_new_with_label( "Undo" );
        gtk_box_pack_start( GTK_BOX( hb ), pbv->undo, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( pbv->undo ), "clicked", 
		GTK_SIGNAL_FUNC( paintboxview_undo_cb ), pbv );
	set_tooltip( pbv->undo, "Undo last paint action" );

	pbv->redo = gtk_button_new_with_label( "Redo" );
        gtk_box_pack_start( GTK_BOX( hb ), pbv->redo, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( pbv->redo ), "clicked", 
		GTK_SIGNAL_FUNC( paintboxview_redo_cb ), pbv );
	set_tooltip( pbv->redo, "Redo last paint action" );

	pbv->clear = gtk_button_new_with_label( "Clear" );
        gtk_box_pack_start( GTK_BOX( hb ), pbv->clear, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( pbv->clear ), "clicked", 
		GTK_SIGNAL_FUNC( paintboxview_clear_cb ), pbv );
	set_tooltip( pbv->clear, "Clear all undo/redo buffers" );

	pbv->tool = build_goption( hb, "Tool:", 
		tool_names, IM_NUMBER( tool_names ),
		GTK_SIGNAL_FUNC( paintboxview_new_tool_cb ), pbv );

	pbv->nib = build_goption( hb, "Nib:", 
		nib_names, IM_NUMBER( nib_names ),
		GTK_SIGNAL_FUNC( paintboxview_new_nib_cb ), pbv );

	label = gtk_label_new( "Ink:" );
        gtk_box_pack_start( GTK_BOX( hb ), label, FALSE, TRUE, 0 );
	pbv->ink = (GtkWidget *) colourdisplay_new( NULL );
	imagedisplay_set_size( IMAGEDISPLAY( pbv->ink ), 20, 10 );
        gtk_box_pack_start( GTK_BOX( hb ), pbv->ink, FALSE, TRUE, 0 );

	pbv->font = gtk_button_new_with_label( "Times 24" );
        gtk_misc_set_padding( GTK_MISC( GTK_BIN( pbv->font )->child ), 2, 2 );
        gtk_box_pack_start( GTK_BOX( hb ), pbv->font, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( pbv->font ), "clicked", 
		GTK_SIGNAL_FUNC( paintboxview_font_cb ), pbv );
	set_tooltip( pbv->font, "Click to select font" );

	pbv->text = gtk_entry_new();
        gtk_box_pack_start( GTK_BOX( hb ), pbv->text, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( pbv->text ), "changed", 
		GTK_SIGNAL_FUNC( paintboxview_text_changed_cb ), pbv );
	set_tooltip( pbv->text, "Enter text for text tool" );

	gtk_widget_show_all( eb );
}

GtkType
paintboxview_get_type( void )
{
	static GtkType paintboxview_type = 0;

	if( !paintboxview_type ) {
		static const GtkTypeInfo sinfo = {
			"Paintboxview",
			sizeof( Paintboxview ),
			sizeof( PaintboxviewClass ),
			(GtkClassInitFunc) paintboxview_class_init,
			(GtkObjectInitFunc) paintboxview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		paintboxview_type = 
			gtk_type_unique( GTK_TYPE_FRAME, &sinfo );
	}

	return( paintboxview_type );
}

static void
paintboxview_ii_undo_changed_cb( Imageinfo *imageinfo, Paintboxview *pbv )
{
	gtk_widget_set_sensitive( GTK_WIDGET( pbv->undo ), 
		imageinfo->undo != NULL );
	gtk_widget_set_sensitive( GTK_WIDGET( pbv->redo ), 
		imageinfo->redo != NULL );
	gtk_widget_set_sensitive( GTK_WIDGET( pbv->clear ), 
		imageinfo->undo != NULL || imageinfo->redo != NULL );
}

static void
paintboxview_ii_destroy_cb( Imageinfo *imageinfo, Paintboxview *pbv )
{
	pbv->ii_undo_changed_sid = 0;
	pbv->ii_destroy_sid = 0;
	pbv->ii = NULL;
}

/* Our conversion has changed ... update.
 */
static void
paintboxview_conv_changed_cb( Conversion *conv, Paintboxview *pbv )
{
	Colourdisplay *ink = COLOURDISPLAY( pbv->ink );
	const PaintboxTool paintbox_tool = 
		(PaintboxTool) get_goption( pbv->tool );
	const PaintboxNib paintbox_nib = (PaintboxNib) get_goption( pbv->nib );

	widget_visible( GTK_WIDGET( pbv ), conv->paintbox );

	/* Has the ii changed? Link to it for undo/redo changes.
	 */
	if( conv->ii != pbv->ii ) {
		FREESID( pbv->ii_undo_changed_sid, pbv->ii );
		FREESID( pbv->ii_destroy_sid, pbv->ii );

		pbv->ii = conv->ii;

		if( conv->ii ) {
			pbv->ii_undo_changed_sid = 
				gtk_signal_connect( GTK_OBJECT( conv->ii ), 
				"undo_changed", 
				GTK_SIGNAL_FUNC( 
					paintboxview_ii_undo_changed_cb ), 
				pbv );
			pbv->ii_destroy_sid = 
				gtk_signal_connect( GTK_OBJECT( conv->ii ), 
				"destroy", 
				GTK_SIGNAL_FUNC( paintboxview_ii_destroy_cb ), 
				pbv );

			paintboxview_ii_undo_changed_cb( conv->ii, pbv );
		}
	}

	/* Link ink display to new conversion.
	 */
	conversion_set_image( IMAGEDISPLAY( ink )->conv, conv->paintbox_ink );

	/* Has the tool changed? Update.
	 */
	if( paintbox_tool != conv->paintbox_tool ) 
		set_goption( pbv->tool, conv->paintbox_tool );
	if( paintbox_nib != conv->paintbox_nib ) 
		set_goption( pbv->nib, conv->paintbox_nib );
}

/* Our conversion has been destroyed ... destroy us in turn.
 */
static void
paintboxview_destroy_cb( Conversion *conv, Paintboxview *pbv )
{
	gtk_widget_destroy( GTK_WIDGET( pbv ) );
}

static void
paintboxview_link( Paintboxview *pbv, Imageview *iv )
{
	assert( !pbv->iv );

	pbv->iv = iv;

	pbv->conv_changed_sid = gtk_signal_connect( 
		GTK_OBJECT( pbv->iv->conv ), "changed", 
		GTK_SIGNAL_FUNC( paintboxview_conv_changed_cb ), pbv );
	pbv->conv_destroy_sid = gtk_signal_connect( 
		GTK_OBJECT( pbv->iv->conv ), "destroy", 
		GTK_SIGNAL_FUNC( paintboxview_destroy_cb ), pbv );
}

Paintboxview *
paintboxview_new( Imageview *iv )
{
	Paintboxview *pbv = gtk_type_new( TYPE_PAINTBOXVIEW );

	paintboxview_link( pbv, iv );

	return( pbv );
}

