/* an ip arrow class object in a workspace
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
iarrow_destroy( GtkObject *object )
{
	Iarrow *iarrow;

#ifdef DEBUG
	printf( "iarrow_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IARROW( object ) );

	iarrow = IARROW( object );

	/* My instance destroy stuff.
	 */
	iregion_instance_destroy( &iarrow->instance );
	buf_destroy( &iarrow->caption );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void *
iarrow_caption_update_sub( Iimage *iimage, Iarrow *iarrow, gboolean *first )
{
	Workspace *ws = HEAPMODEL( iarrow )->row->ws;
	Row *row = HEAPMODEL( iimage )->row;

	/* Supress this name in the caption if it's a superclass. If this
	 * thing is on a super, it's on the subclass too ... not helpful to
	 * have it twice.
	 */
	if( !is_super( row->sym ) ) {
		if( *first )
			*first = FALSE;
		else 
			buf_appends( &iarrow->caption, ", " );

		row_qualified_name_relative( SYMBOL( ws ), 
			row, &iarrow->caption );
	}

	return( NULL );
}

/* The printf strings for the various region types.
 */
typedef struct {
	const char *name;
	const char *fmt;
} IarrowDisplay;

static IarrowDisplay iarrow_display_table[] = {
	{ CLASS_HGUIDE, "at %2$d" },
	{ CLASS_VGUIDE, "at %1$d" },
	{ CLASS_POINT, "at (%d, %d)" },
	{ CLASS_ARROW, "at (%d, %d), offset (%d, %d)" }
};

static void
iarrow_caption_update( Iarrow *iarrow, PElement *root  )
{
	const int nimages = g_slist_length( CLASSMODEL( iarrow )->iimages );

	gboolean result;
	gboolean first;
	Compile *compile;
	int i;

	if( !heap_isclass( root, &result ) || !result )
		return;

	compile = PEGETCLASSCOMPILE( root );
	buf_rewind( &iarrow->caption );
	symbol_qualified_name( compile->sym, &iarrow->caption );
	buf_appendf( &iarrow->caption, " on " );
	if( nimages > 1 )
		buf_appendf( &iarrow->caption, "[" );
	first = TRUE;
	slist_map2( CLASSMODEL( iarrow )->iimages,
		(SListMap2Fn) iarrow_caption_update_sub, iarrow, &first );
	if( nimages > 1 )
		buf_appendf( &iarrow->caption, "]" );
	buf_appendf( &iarrow->caption, " " );

	for( i = 0; i < IM_NUMBER( iarrow_display_table ); i++ ) {
		const char *name = iarrow_display_table[i].name;

		if( !heap_isinstanceof( name, root, &result ) )
			return;
		if( result ) {
			buf_appendf( &iarrow->caption, 
				iarrow_display_table[i].fmt,
				iarrow->instance.area.left, 
				iarrow->instance.area.top,
				iarrow->instance.area.width, 
				iarrow->instance.area.height );
			break;
		}
	}
}

static void *
iarrow_update_model( Heapmodel *heapmodel )
{
	/* Parent first ... this will update our instance vars.
	 */
	if( HEAPMODEL_CLASS( parent_class )->update_model( heapmodel ) )
		return( heapmodel );

	if( heapmodel->row->expr ) {
		Iarrow *iarrow = IARROW( heapmodel );
		PElement *root = &heapmodel->row->expr->root;

		/* Update who-has-displays-on-what stuff.
		 */
		classmodel_iimage_update( CLASSMODEL( iarrow ), 
			iarrow->instance.image );

		iarrow_caption_update( iarrow, root );

		model_changed( MODEL( heapmodel ) );
	}

	return( NULL );
}

static void *
iarrow_get_instance( Classmodel *classmodel )
{
	Iarrow *iarrow = IARROW( classmodel );

	return( &iarrow->instance );
}

static void
iarrow_class_init( IarrowClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	HeapmodelClass *heapmodel_class = (HeapmodelClass *) klass;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) klass;

	/* We share methods with iregion in a sort of MI way ... iregion needs
	 * to be initialised before we can work. Force it to start up.
	 */
	(void) iregion_get_type();

	parent_class = gtk_type_class( TYPE_CLASSMODEL );

	/* Create signals.
	 */

	/* Init methods.
	 */
	object_class->destroy = iarrow_destroy;

	model_class->view_new = iarrowview_new;
	model_class->edit = iregion_edit;
	model_class->parent_add = iregion_parent_add;
	model_class->save = iregion_save;
	model_class->load = iregion_load;

	heapmodel_class->update_model = iarrow_update_model;
	heapmodel_class->update_heap = iregion_update_heap;

	classmodel_class->class_get = iregion_class_get;
	classmodel_class->class_new = iregion_class_new;
	classmodel_class->get_instance = iarrow_get_instance;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
iarrow_init( Iarrow *iarrow )
{
	iregion_instance_init( &iarrow->instance, CLASSMODEL( iarrow ) );
	buf_init_dynamic( &iarrow->caption, MAX_LINELENGTH );

	model_set( MODEL( iarrow ), CLASS_ARROW, NULL );
}

GtkType
iarrow_get_type( void )
{
	static GtkType iarrow_type = 0;

	if( !iarrow_type ) {
		static const GtkTypeInfo info = {
			"Iarrow",
			sizeof( Iarrow ),
			sizeof( IarrowClass ),
			(GtkClassInitFunc) iarrow_class_init,
			(GtkObjectInitFunc) iarrow_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		iarrow_type = gtk_type_unique( TYPE_CLASSMODEL, &info );
	}

	return( iarrow_type );
}

Classmodel *
iarrow_new( Rhs *rhs )
{
	Iarrow *iarrow = gtk_type_new( TYPE_IARROW );

	model_child_add( MODEL( rhs ), MODEL( iarrow ), -1 );

	return( CLASSMODEL( iarrow ) );
}

