/* Declarations supporting gtkutil.c
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* Look up an object's parent class dynamically.
 */
#define PARENT_CLASS_DYNAMIC( OBJECT ) \
	gtk_type_class( gtk_type_parent( GTK_OBJECT( OBJECT )->klass->type ) )

/* Names of objects and classes.
 */
#define CLASS_NAME( KLASS ) (gtk_type_name( GTK_OBJECT_CLASS( KLASS )->type ))
#define OBJECT_CLASS_NAME( OBJ ) (CLASS_NAME( GTK_OBJECT( OBJ )->klass))

/* Like GTK_CHECK_TYPE, but insist on an exact match.
 */
#define TYPE_EXACT( OBJ, TYPE ) \
	(GTK_OBJECT( OBJ )->klass->type == (TYPE))

void
adjustments_set_value( GtkAdjustment *hadj, GtkAdjustment *vadj,
        float hval, float vval );

void *object_destroy( void *obj );
void *null_g_free( void *obj );
const char *object_type_name( GtkObject *obj );

void widget_visible( GtkWidget *widget, gboolean visible );
gboolean table_find_pos( GtkWidget *widget, 
	int x, int y, int *row, int *column );
GtkWidget *table_find_child( GtkWidget *widget, int x, int y );

/* Make widgets.
 */
GtkWidget *build_button( const char *name, GtkSignalFunc cb, gpointer user );
void get_geo( GtkWidget *widget, const char *text, Rect *geo );
void set_fixed( GtkWidget *widget, int nchars );
GtkWidget *build_entry( int nchars );

GtkWidget *menu_build( const char *name );
GtkWidget *menu_add_but( GtkWidget *menu, 
	const char *name, GtkSignalFunc cb, void *user );
GtkWidget *menu_add_tog( GtkWidget *menu, 
	const char *name, GtkSignalFunc cb, void *user );
GtkWidget *menu_add_sep( GtkWidget *menu );

/* Popup menu handling.
 */
GtkWidget *popup_build( const char *name );
GtkWidget *popup_add_but( GtkWidget *, const char *, GtkSignalFunc );
GtkWidget *popup_add_tog( GtkWidget *, const char *, GtkSignalFunc );
void popup_show( GtkWidget *host, GdkEvent *ev );
void popup_link( GtkWidget *host, GtkWidget *popup, gpointer data );
guint popup_attach( GtkWidget *host, GtkWidget *popup, gpointer data );
void popup_detach( GtkWidget *host, guint sid );

void set_tooltip( GtkWidget *wid, const char *fmt, ... );

/* Set/get a label/entry, printf style.
 */
void set_gentryv( GtkWidget *edit, const char *fmt, va_list ap );
void set_gentry( GtkWidget *entry, const char *fmt, ... );
void set_glabel( GtkWidget *label, const char *fmt, ... );
void set_glabels( GtkWidget *label, const char *str );
gboolean get_geditable_string( GtkWidget *text, char *out, int sz );
gboolean get_geditable_name( GtkWidget *text, char *out, int sz );
gboolean get_geditable_filename( GtkWidget *text, char *out, int sz );
gboolean get_geditable_double( GtkWidget *text, double *out );
gboolean get_geditable_int( GtkWidget *text, int *n );
gboolean get_geditable_uint( GtkWidget *text, int *n );
gboolean get_geditable_pint( GtkWidget *text, int *n );

/* Set a name for a widget and all its children.
 */
void set_name( GtkWidget *widget, const char *name );

/* Make widget groups.
 */
GtkWidget *build_glabelframe( GtkWidget *box, const char *label );
GtkWidget *build_glabelframe2( GtkWidget *box, const char *label );
GtkWidget *build_glabeltext( GtkWidget *box, const char *label );
GtkWidget *build_glabeltext2( GtkWidget *box, const char *label, int nchars );
GtkWidget *build_glabeltext3( GtkWidget *box, const char *label );
GtkWidget *build_gtoggle( GtkWidget *box, const char *caption );
GtkWidget *build_goption( GtkWidget *box, const char *name, 
	const char *item_names[], int nitem,
	GtkSignalFunc fn, void *value );

int get_goption( GtkWidget *widget );
int get_gradio( GtkWidget *widget );
void set_goption( GtkWidget *widget, int i );

void process_events_graphics_expose( GtkWidget *widget );

typedef gboolean (*FiledropFunc)( void *client, const char *file );
void filedrop_register( GtkWidget *widget, FiledropFunc fn, void *client );
