/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __GTK_FILESEL2_H__
#define __GTK_FILESEL2_H__


#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_FILE_SELECTION2            (gtk_file_selection2_get_type ())
#define GTK_FILE_SELECTION2(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_FILE_SELECTION2, GtkFileSelection2))
#define GTK_FILE_SELECTION2_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_FILE_SELECTION2, GtkFileSelection2Class))
#define GTK_IS_FILE_SELECTION2(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_FILE_SELECTION2))
#define GTK_IS_FILE_SELECTION2_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FILE_SELECTION2))

typedef struct _GtkFileSelection2            GtkFileSelection2;
typedef struct _GtkFileSelection2Class       GtkFileSelection2Class;
typedef struct _GtkFileSelection2FileType    GtkFileSelection2FileType;

/* How we define a file type. Pass a NULL-terminated array of pointers
 * to these puppies to gtk_file_selection2_set_file_types().
 * gtk_file_selection2_set_file_types() makes a copy of the data itself,
 * so you can free if you want.
 */
struct _GtkFileSelection2FileType {
  /* Descriptive name for this file type. Eg:
   *	"TIFF image file (*.tif; *.tiff)"
   */
  const char *name;

  /* NULL-terminated array of suffixes identifying this 
   * file type. Put the default first. Eg:
   *	{ ".tif", ".tiff", NULL }, or 
   *	{ ".htm", ".html", NULL }
   */
  const char **suffixes;
};

/* Predicate for filename filtering ... all file names must 
 * pass one of these.
 */
typedef gboolean (*GtkFileSelection2FilenamePredicate) (const gchar *name, 
					     		gpointer data);

struct _GtkFileSelection2
{
  iDialog   idlg;

  GtkWidget *dir_list;
  GtkWidget *file_list;
  GtkWidget *selection_entry;
  GtkWidget *selection_text;
  GtkWidget *main_vbox;
  GtkWidget *history_pulldown;
  GtkWidget *history_menu;
  GList     *history_list;
  GtkWidget *fileop_dialog;
  GtkWidget *fileop_entry;
  gchar     *fileop_file;
  gpointer   cmpl_state;
  
  GtkWidget *fileop_c_dir;
  GtkWidget *fileop_del_file;
  GtkWidget *fileop_ren_file;
  
  GtkWidget *button_area;
  GtkWidget *work;
  
  GtkWidget *path_text;
  GtkWidget *path_entry;
  GtkWidget *type_menu_pane;
  GtkWidget *type_option_menu;
  GList     *file_types;	/* List of all suffix lists */
  GList     *suffixes;		/* Current suffix list */

  gchar	    *current_file;	/* Track last selected file and dir */
  gchar	    *current_dir;

  gboolean  multi;		/* in multi-select mode */
  GSList    *selected_names;	/* in multi, list of selected names */
};

struct _GtkFileSelection2Class
{
  iDialogClass parent_class;

  void (* file_select)	(GtkFileSelection2 *filesel, 
			 const gchar *filename);
  void (* dir_enter)	(GtkFileSelection2 *filesel, 
			 const gchar *dirname);
  void (* refresh)	(GtkFileSelection2 *filesel);
};

GtkType    gtk_file_selection2_get_type            (void);
GtkWidget* gtk_file_selection2_new                 (const gchar       *title);
void       gtk_file_selection2_set_multi           (GtkFileSelection2 *filesel,
						    gboolean 	      multi);
void       gtk_file_selection2_set_filename        (GtkFileSelection2 *filesel,
						    const gchar	      *filename);
gchar*     gtk_file_selection2_get_filename        (GtkFileSelection2 *filesel);
GSList*    gtk_file_selection2_get_filename_multi  (GtkFileSelection2 *filesel);
void	   gtk_file_selection2_complete		   (GtkFileSelection2 *filesel,
						    const gchar	      *pattern);
void       gtk_file_selection2_show_fileop_buttons (GtkFileSelection2 *filesel);
void       gtk_file_selection2_hide_fileop_buttons (GtkFileSelection2 *filesel);

void       gtk_file_selection2_update_history_menu (GtkFileSelection2 *filesel,
						    const gchar       *new_dir);

void       gtk_file_selection2_show_file_types     (GtkFileSelection2 *filesel);
void       gtk_file_selection2_hide_file_types     (GtkFileSelection2 *filesel);
void	   gtk_file_selection2_set_file_types 	   (GtkFileSelection2 *filesel, 
						    GtkFileSelection2FileType *types[]);
void	   gtk_file_selection2_set_file_type       (GtkFileSelection2 *filesel, 
						    int n);
gchar*	   gtk_file_selection2_get_file_type   	   (GtkFileSelection2 *filesel); 
void	   gtk_file_selection2_set_filter   	   (GtkFileSelection2 *filesel, 
						    GtkFileSelection2FilenamePredicate pred,
						    gpointer data);
void	   gtk_file_selection2_refresh 		   (GtkFileSelection2 *filesel);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_FILESEL2_H__ */










