/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#include <stdio.h>

#include <gtk/gtk.h>

#include "gtkfilesel2.h"

/*
 * GtkFileSelection2
 */
gchar *source_suffs[] = {".c", ".h", NULL};
gchar *obj_suffs[] = {".o", NULL};
gchar *tiff_suffs[] = {".tif", ".tiff", NULL};
gchar *jpeg_suffs[] = {".jpg", ".jpeg", NULL};
gchar *all_suffs[] = {"", NULL};

GtkFileSelection2FileType 
  cfiles = {"C source files (*.c; *.h)", source_suffs},
  ofiles = {"Object files (*.o)", obj_suffs},
  tfiles = {"TIFF image files (*.tif; *.tiff)", tiff_suffs},
  jfiles = {"JPEG image files (*.jpg; *.jpeg)", jpeg_suffs},
  allfiles = {"All files (*)", all_suffs};

GtkFileSelection2FileType 
  *programming_types[] = {&cfiles, &ofiles, &allfiles, NULL},
  *image_types[] = {&tfiles, &jfiles, &allfiles, NULL};

void
set_c_types (GtkFileSelection2 *fs)
{
  gtk_file_selection2_set_file_types (fs, programming_types);
}

void
set_image_types (GtkFileSelection2 *fs)
{
  gtk_file_selection2_set_file_types (fs, image_types);
}

void
set_no_types (GtkFileSelection2 *fs)
{
  gtk_file_selection2_set_file_types (fs, NULL);
}

void
file_selection2_ok (GtkWidget        *w,
		   GtkFileSelection2 *fs)
{
  g_print ("%s\n", gtk_file_selection2_get_filename (fs));
  gtk_widget_destroy (GTK_WIDGET (fs));
}

void
create_file_selection2 (void)
{
  static GtkWidget *window = NULL;

  if (!window)
    {
      GtkWidget *button;
      GtkWidget *vb;
      GtkWidget *hb;
      GtkWidget *mp;
      GtkWidget *om;
      GtkWidget *frame;

      window = gtk_file_selection2_new ("file selection dialog");

      gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			  &window);
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION2 (window)->ok_button),
			  "clicked", GTK_SIGNAL_FUNC(file_selection2_ok),
			  window);
      gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION2 (window)->cancel_button),
				 "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
				 GTK_OBJECT (window));

      /* Add a couple of useful dirs to the file list.
       */
      gtk_file_selection2_update_history_menu (GTK_FILE_SELECTION2 (window),
      					       "/usr/local/myapp/tutorial");
      gtk_file_selection2_update_history_menu (GTK_FILE_SELECTION2 (window),
      					       "/usr/local/bin");

      frame = gtk_frame_new ("testgtk controls");
      gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION2 (window)->action_area), 
			  frame, TRUE, TRUE, 0);
      gtk_widget_show (frame);

      vb = gtk_vbox_new (FALSE, 3);
      gtk_container_set_border_width (GTK_CONTAINER (vb), 3);
      gtk_container_add (GTK_CONTAINER (frame), vb);
      gtk_widget_show (vb);

      hb = gtk_hbox_new (TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vb), hb, FALSE, FALSE, 0);
      gtk_widget_show (hb);

      button = gtk_button_new_with_label ("Hide Fileops");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			         GTK_SIGNAL_FUNC (gtk_file_selection2_hide_fileop_buttons), 
			         GTK_OBJECT (window));
      gtk_box_pack_start (GTK_BOX (hb), button, FALSE, FALSE, 0);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Show Fileops");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_file_selection2_show_fileop_buttons), 
				 GTK_OBJECT (window));
      gtk_box_pack_start (GTK_BOX (hb), button, FALSE, FALSE, 0);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Hide Files");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_hide), 
				 GTK_OBJECT (GTK_FILE_SELECTION2 (window)->file_list->parent));
      gtk_box_pack_start (GTK_BOX (hb), button, FALSE, FALSE, 0);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Show Files");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_show), 
				 GTK_OBJECT (GTK_FILE_SELECTION2 (window)->file_list->parent));
      gtk_box_pack_start (GTK_BOX (hb), button, FALSE, FALSE, 0);
      gtk_widget_show (button);

      hb = gtk_hbox_new (TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vb), hb, FALSE, FALSE, 0);
      gtk_widget_show (hb);

      button = gtk_button_new_with_label ("Force Reread Of Files");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_file_selection2_refresh), 
				 GTK_OBJECT (window));
      gtk_box_pack_start (GTK_BOX (hb), button, FALSE, FALSE, 0);
      gtk_widget_show (button);

      hb = gtk_hbox_new (TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vb), hb, FALSE, FALSE, 0);
      gtk_widget_show (hb);

      button = gtk_button_new_with_label ("Hide Types");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_file_selection2_hide_file_types), 
				 GTK_OBJECT (window));
      gtk_box_pack_start (GTK_BOX (hb), button, FALSE, FALSE, 0);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Show Types");
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_file_selection2_show_file_types), 
				 GTK_OBJECT (window));
      gtk_box_pack_start (GTK_BOX (hb), button, FALSE, FALSE, 0);
      gtk_widget_show (button);

      mp = gtk_menu_new();

      button = gtk_menu_item_new_with_label ("No types");
      gtk_signal_connect_object (GTK_OBJECT (button), "activate",
	  			 GTK_SIGNAL_FUNC (set_no_types), 
				 GTK_OBJECT (window) );
      gtk_menu_append (GTK_MENU (mp), button );
      gtk_widget_show (button);

      button = gtk_menu_item_new_with_label ("C types");
      gtk_signal_connect_object (GTK_OBJECT (button), "activate",
	  			 GTK_SIGNAL_FUNC (set_c_types), 
				 GTK_OBJECT (window) );
      gtk_menu_append (GTK_MENU (mp), button );
      gtk_widget_show (button);

      button = gtk_menu_item_new_with_label ("Image types");
      gtk_signal_connect_object (GTK_OBJECT (button), "activate",
	  			 GTK_SIGNAL_FUNC (set_image_types), 
				 GTK_OBJECT (window) );
      gtk_menu_append (GTK_MENU (mp), button );
      gtk_widget_show (button);

      om = gtk_option_menu_new ();
      gtk_option_menu_set_menu (GTK_OPTION_MENU (om), mp);
      gtk_box_pack_start (GTK_BOX(hb), om, FALSE, FALSE, 0);
      gtk_widget_show (om);

    }
  
  if (!GTK_WIDGET_VISIBLE (window))
    gtk_widget_show (window);
  else
    gtk_widget_destroy (window);
}

/*
 * Main Window and Exit
 */

void
do_exit (GtkWidget *widget, GtkWidget *window)
{
  gtk_widget_destroy (window);
  gtk_main_quit ();
}

void
create_main_window (void)
{
  struct {
    char *label;
    void (*func) ();
  } buttons[] =
    {
      { "file selection", create_file_selection2 },
    };
  int nbuttons = sizeof (buttons) / sizeof (buttons[0]);
  GtkWidget *window;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *scrolled_window;
  GtkWidget *button;
  GtkWidget *label;
  gchar buffer[64];
  GtkWidget *separator;
  int i;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_widget_set_name (window, "main window");
  gtk_widget_set_usize (window, 200, 400);
  gtk_widget_set_uposition (window, 20, 20);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC(gtk_main_quit),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete-event",
		      GTK_SIGNAL_FUNC (gtk_false),
		      NULL);

  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box1);

  if (gtk_micro_version > 0)
    sprintf (buffer,
	     "Gtk+ v%d.%d.%d",
	     gtk_major_version,
	     gtk_minor_version,
	     gtk_micro_version);
  else
    sprintf (buffer,
	     "Gtk+ v%d.%d",
	     gtk_major_version,
	     gtk_minor_version);

  label = gtk_label_new (buffer);
  gtk_box_pack_start (GTK_BOX (box1), label, FALSE, FALSE, 0);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (scrolled_window), 10);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
     		                  GTK_POLICY_AUTOMATIC, 
                                  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box1), scrolled_window, TRUE, TRUE, 0);

  box2 = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window), box2);
  gtk_container_set_focus_vadjustment (GTK_CONTAINER (box2),
				       gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolled_window)));
  gtk_widget_show (box2);

  for (i = 0; i < nbuttons; i++)
    {
      button = gtk_button_new_with_label (buttons[i].label);
      if (buttons[i].func)
        gtk_signal_connect (GTK_OBJECT (button), 
			    "clicked", 
			    GTK_SIGNAL_FUNC(buttons[i].func),
			    NULL);
      else
        gtk_widget_set_sensitive (button, FALSE);
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
    }

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);

  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);

  button = gtk_button_new_with_label ("close");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (do_exit),
		      window);
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);

  gtk_widget_show_all (window);
}

int
main (int argc, char *argv[])
{
  srand (time (NULL));

  gtk_set_locale ();

  gtk_rc_add_default_file ("testgtkrc");

  gtk_init (&argc, &argv);

  gdk_rgb_init ();

  create_main_window ();

  gtk_main ();

  return 0;
}
