# -*- coding: utf-8 -*-
#
#  osuwari.py - a Osuwari compatible Saori module for ninix
#  Copyright (C) 2006-2009 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#

# TODO: MOVE, NOCLIP, FIX, etc.

import gobject
import gtk

from ninix.dll import SAORI
import ninix.pix


class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)
        self.timeout_id = None
        self.settings = {}
        self.__sakura = None

    def need_ghost_backdoor(self, sakura):
        self.__sakura = sakura

    def check_import(self):
        return 1

    def setup(self): ## FIXME
        return 1

    def execute(self, argument):
        if not argument:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        if argument[0] == 'START':
            if len(argument) < 7:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            try:
                assert argument[2] in ['ACTIVE', 'FIX'] or \
                       arguent[2].stratswith('@') or \
                       argument[2].startswith('#')
                assert argument[3] in ['TL', 'TR', 'BL', 'BR']
                self.settings['hwnd'] = argument[1]
                self.settings['target'] = argument[2]
                self.settings['position'] = argument[3]
                self.settings['offset_x'] = int(argument[4])
                self.settings['offset_y'] = int(argument[5])
                self.settings['timeout'] = int(argument[6])
                self.settings['xmove'] = 0
                self.settings['ymove'] = 0
                self.settings['noclip'] = 0
                if len(argument) > 7:
                    if 'XMOVE' in argument[7]:
                        self.settings['xmove'] = 1
                    if 'YMOVE' in argument[7]:
                        self.settings['ymove'] = 1
                    if 'NOCLIP' in argument[7]:
                        self.settings['noclip'] = 1
                self.settings['except'] = ('DESKTOP', 'CENTER')
                #if len(argument) > 8:
                #    target, position = argument[8].split()
                #    assert target in ['DESKTOP', 'WORKAREA']
                #    assert position in ['TOP', 'LEFT', 'RIGHT', 'BOTTOM']
                #    self.settings['except'] = (target, position)
            except:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            #self.timeout_id = gobject.timeout_add(self.settings['timeout'], self.do_idle_tasks)
            self.timeout_id = gobject.timeout_add(100, self.do_idle_tasks)
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        elif argument[0] == 'STOP':
            if self.timeout_id is not None:
                gobject.source_remove(self.timeout_id)
                self.timeout_id = None
                self.settings = {}
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        else:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'

    def do_idle_tasks(self):
        if self.timeout_id is None:
            return False
        target = self.settings['target']
        left, top, scrn_w, scrn_h = ninix.pix.get_workarea()
        if target == 'ACTIVE':
            active_window = self.get_active_window()
            if active_window:
                if self.__sakura.identify_window(active_window):
                    return True
                else:
                    rect = active_window.get_frame_extents()
                    target_x = rect.x
                    target_y = rect.y
                    target_w = rect.width
                    target_h = rect.height
            else:
                return True
        elif target == 'FIX': ## FIXME
            target_x = left
            target_y = top
            target_w = scrn_w
            target_h = scrn_h
        elif target.startswith('@'): ## FIXME
            #win = self.get_window_by_name(target[1:])
            #if self.__sakura.identify_window(win):
            #    return True
            #target_x, target_y = active_window.get_root_origin()
            #rect = active_window.get_frame_extents()
            #target_w = rect.width
            #target_h = rect.height
            return False
        elif target.startswith('#'): ## FIXME
            return False
        else:
            return False # should not reach here
        pos = self.settings['position']
        scale = self.prefs.get('surface_scale')
        offset_x = int(self.settings['offset_x'] * scale / 100)
        offset_y = int(self.settings['offset_y'] * scale / 100)
        if self.settings['hwnd'].startswith('s'):
            try:
                side = int(self.settings['hwnd'][1:])
            except:
                return False
        else:
            try:
                side = int(self.settings['hwnd'])
            except:
                return False
        w, h = self.__sakura.get_surface_size(side)
        if pos[0] == 'T':
            y = target_y + offset_y
        elif pos[0] == 'B':
            y = target_y + target_h + offset_y - h
        else:
            return False # should not reach here
        if pos[1] == 'L':
            x = target_x + offset_x
        elif pos[1] == 'R':
            x = target_x + target_w + offset_x - w
        else:
            return False # should not reach here
        if not self.settings['noclip']:
            if x < left or y < top:
                pass ## FIXME
        self.__sakura.set_surface_position(side, x, y)
        self.__sakura.raise_surface(side)
        return True

    def get_window_by_name(self, name): ## FIXME
        return None

    def get_active_window(self):
        scrn = gtk.gdk.screen_get_default()
        if not scrn.supports_net_wm_hint('_NET_ACTIVE_WINDOW') or \
                not scrn.supports_net_wm_hint('_NET_WM_WINDOW_TYPE'):
            return None
        active_window =scrn.get_active_window()
        window_type = active_window.property_get('_NET_WM_WINDOW_TYPE')[-1][0]
        if window_type == '_NET_WM_WINDOW_TYPE_DESKTOP':
            return None
        else:
            return active_window
