/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import java.util.Collection;
import java.util.Iterator;

public abstract class SimpleVector
extends AbstractSequence
implements Sequence {
    public int size;

    public final int size() {
        return this.size;
    }

    public void setSize(int size) {
        int oldSize = this.size;
        this.size = size;
        if (size < oldSize) {
            this.clearBuffer(size, oldSize - size);
        } else {
            int oldLength = this.getBufferLength();
            if (size > oldLength) {
                int newLength = oldLength < 16 ? 16 : 2 * oldLength;
                this.setBufferLength(size > newLength ? size : newLength);
            }
        }
    }

    public abstract int getBufferLength();

    public abstract void setBufferLength(int var1);

    protected boolean isAfter(int ipos, Object xpos) {
        return (ipos & 1) != 0;
    }

    protected int nextIndex(int ipos, Object xpos) {
        return ipos >>> 1;
    }

    public void makePosition(int index, boolean isAfter, PositionContainer posSet, int posNumber) {
        posSet.setPosition(posNumber, index << 1 | (isAfter ? 1 : 0), null);
        posSet.setSequence(posNumber, this);
    }

    protected abstract Object getBuffer();

    public Object get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getBuffer(index);
    }

    protected Object getNext(int ipos, Object xpos) {
        int index = ipos >>> 1;
        return index >= this.size ? Sequence.eofValue : this.getBuffer(index);
    }

    public int intAtBuffer(int index) {
        return Convert.toInt(this.getBuffer(index));
    }

    public int intAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.intAtBuffer(index);
    }

    public long longAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longAtBuffer(index);
    }

    public long longAtBuffer(int index) {
        return Convert.toLong(this.getBuffer(index));
    }

    protected abstract Object getBuffer(int var1);

    public Object set(int index, Object value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object old = this.getBuffer(index);
        this.setBuffer(index, value);
        return old;
    }

    protected abstract Object setBuffer(int var1, Object var2);

    public void fill(Object value) {
        int i = this.size;
        while (--i >= 0) {
            this.setBuffer(i, value);
        }
    }

    public void fill(int fromIndex, int toIndex, Object value) {
        if (fromIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            this.setBuffer(i, value);
        }
    }

    public void shift(int srcStart, int dstStart, int count) {
        Object data = this.getBuffer();
        System.arraycopy(data, srcStart, data, dstStart, count);
    }

    public boolean add(Object o) {
        this.add(this.size, o);
        return true;
    }

    protected void add(PositionContainer posSet, int posNumber, Object value) {
        int ipos = posSet.getPositionInt(posNumber);
        this.add(ipos >>> 1, value);
        posSet.setPosition(posNumber, ipos + 2, null);
    }

    public void add(int index, Object o) {
        int newSize;
        this.size = newSize = this.size + 1;
        int length = this.getBufferLength();
        if (newSize > length) {
            this.setBufferLength(length < 16 ? 16 : 2 * length);
        }
        this.size = newSize;
        if (this.size != index) {
            this.shift(index, index + 1, this.size - index);
        }
        this.set(index, o);
    }

    public boolean addAll(int index, Collection c) {
        boolean changed = false;
        int count = c.size();
        this.setSize(this.size + count);
        this.shift(index, index + count, this.size - count - index);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.set(index++, it.next());
            changed = true;
        }
        return changed;
    }

    protected abstract void clearBuffer(int var1, int var2);

    protected void remove(int ipos0, Object xpos0, int ipos1, Object xpos1) {
        if ((ipos0 >>>= 1) < 0 || ipos0 > (ipos1 >>>= 1) || ipos1 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.shift(ipos1, ipos0, this.size - ipos1);
        int count = ipos1 - ipos0;
        this.size -= count;
        this.clearBuffer(this.size, count);
    }

    protected void remove(int ipos, Object xpos, int count) {
        int ipos1;
        int ipos0;
        int index = ipos >>> 1;
        if (count >= 0) {
            ipos0 = index;
            ipos1 = index + count;
        } else {
            ipos0 = index + count;
            ipos1 = index;
            count = -count;
        }
        if (ipos0 < 0 || ipos1 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.shift(ipos1, ipos0, this.size - ipos1);
        this.size -= count;
        this.clearBuffer(this.size, count);
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object result = this.get(index);
        this.shift(index + 1, index, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return result;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        Object result = this.get(index);
        this.shift(index + 1, index, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            Object value = this.get(i);
            if (c.contains(value)) {
                changed = true;
                continue;
            }
            if (changed) {
                this.set(j, value);
            }
            ++j;
        }
        this.setSize(j);
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            Object value = this.get(i);
            if (!c.contains(value)) {
                changed = true;
                continue;
            }
            if (changed) {
                this.set(j, value);
            }
            ++j;
        }
        this.setSize(j);
        return changed;
    }

    public void clear() {
        this.setSize(0);
    }

    public String getTag() {
        return null;
    }

    public void consume(int start, int length, Consumer out) {
        this.consume(start << 1, null, start + length << 1, null, out);
    }

    public boolean consumeNext(int ipos, Object xpos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeObject(this.getBuffer(index));
        return true;
    }

    protected void consume(int iposStart, Object xposStart, int iposEnd, Object xposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int end = iposEnd >>> 1;
        for (int i = iposStart >>> 1; i < end; ++i) {
            out.writeObject(this.getBuffer(i));
        }
    }

    public int getNextKind(int ipos, Object xpos) {
        return this.hasNext(ipos, xpos) ? this.getElementKind() : 0;
    }

    public int getElementKind() {
        return 32;
    }
}

