/*
 * Decompiled with CFR 0.152.
 */
package bossa.util;

import bossa.modules.Package;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.UserError;

public final class User {
    public static UserError error(Located responsible, Exception exn) {
        return User.error(responsible, exn.toString());
    }

    public static UserError error(Exception exn) {
        return User.error(exn.toString());
    }

    public static UserError error(Located responsible, String message, String dbgMsg) {
        if (Debug.powerUser) {
            return User.error(responsible, message + dbgMsg);
        }
        return User.error(responsible, message);
    }

    public static UserError error(Located responsible, String message, Exception dbgExn) {
        if (Debug.powerUser) {
            return User.error(responsible, message + " [" + dbgExn + "]");
        }
        return User.error(responsible, message);
    }

    public static UserError error(Located responsible, String message) {
        if (responsible == null) {
            throw new UserError(message);
        }
        throw new UserError(responsible, message);
    }

    public static UserError error(String message) {
        throw new UserError(message);
    }

    public static void warning(Located responsible, String message) {
        if (Debug.alwaysDumpStack) {
            Internal.printStackTrace();
        }
        Package.currentCompilation.warning(responsible == null ? null : responsible.location(), message);
    }

    public static void warning(String message) {
        User.warning(null, message);
    }
}

