/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.Monotype;
import bossa.syntax.PrimitiveType;
import bossa.util.Util;
import gnu.bytecode.ArrayType;
import gnu.expr.ApplyExp;
import java.util.List;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import nice.tools.code.LiteralArrayProc;
import nice.tools.code.SpecialTypes;
import nice.tools.code.Types;

public class LiteralArrayExp
extends Expression {
    private boolean wrapAsCollection;
    Expression[] elements;

    public LiteralArrayExp(List elements) {
        this.elements = LiteralArrayExp.toArray(elements);
    }

    void computeType() {
        Polytype elementType = Polytype.union(LiteralArrayExp.getType(this.elements));
        this.type = this.array(elementType);
        if (!this.type.trySimplify()) {
            this.type = this.array(PrimitiveType.objectPolytype());
        }
    }

    private Polytype array(Polytype elementType) {
        Polytype res = new Polytype(elementType.getConstraint(), Monotype.sure(new MonotypeConstructor(PrimitiveType.arrayTC, new mlsub.typing.Monotype[]{elementType.getMonotype()})));
        res.setNotSimplified();
        return res;
    }

    Expression resolveOverloading(Polytype expectedType) {
        mlsub.typing.Monotype elementType = nice.tools.typing.Types.getTypeParameter(expectedType, 0);
        if (elementType != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].adjustToExpectedType(elementType);
            }
        }
        return this;
    }

    void adjustToExpectedType(mlsub.typing.Monotype expectedType) {
        mlsub.typing.Monotype elementType;
        TypeConstructor tc = nice.tools.typing.Types.equivalent(expectedType).head();
        if (tc != PrimitiveType.arrayTC && tc != null && tc.isRigid() && Typing.testRigidLeq(tc, PrimitiveType.collectionTC)) {
            this.wrapAsCollection = true;
        }
        if ((elementType = nice.tools.typing.Types.getTypeParameter(expectedType, 0)) != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].adjustToExpectedType(elementType);
            }
        }
    }

    public gnu.expr.Expression compile() {
        gnu.expr.Expression[] args = Expression.compile(this.elements);
        ArrayType t = SpecialTypes.array(Types.lowestUpperBound(args));
        return new ApplyExp(new LiteralArrayProc(t, this.elements.length, this.wrapAsCollection), args);
    }

    public String toString() {
        return "[" + Util.map("", ", ", "", this.elements) + "]";
    }
}

