/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.link.Dispatch;
import bossa.syntax.Constraint;
import bossa.syntax.FormalParameters;
import bossa.syntax.JavaConstructor;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Monotype;
import bossa.util.Internal;
import bossa.util.Location;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import java.io.PrintWriter;
import mlsub.typing.Polytype;
import nice.tools.code.Gen;
import nice.tools.code.Import;

public class JavaMethod
extends MethodDeclaration {
    public static final String fullNamePrefix = "JAVA:";
    public Method reflectMethod;
    private boolean registered;

    JavaMethod(LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters) {
        super(name, constraint, returnType, parameters);
    }

    JavaMethod(LocatedString name, Polytype type, Method reflectMethod) {
        super(name, null, type);
        this.reflectMethod = reflectMethod;
        this.registerForDispatch();
    }

    static JavaMethod make(Method m, boolean constructor) {
        Polytype type = Import.type(m);
        if (type == null) {
            return null;
        }
        JavaMethod res = constructor ? new JavaConstructor(new LocatedString("new " + m.getDeclaringClass().getName(), Location.nowhere()), type, m) : new JavaMethod(new LocatedString(m.getName(), Location.nowhere()), type, m);
        return res;
    }

    public String getFullName() {
        return fullNamePrefix + this.name + ':' + this.getType();
    }

    public final LambdaExp getLambda() {
        return Gen.dereference(this.getCode());
    }

    public Type javaReturnType() {
        return this.reflectMethod.getReturnType();
    }

    public Type[] javaArgTypes() {
        return this.reflectMethod.getParameterTypes();
    }

    protected Expression computeCode() {
        return new QuoteExp(new PrimProcedure(this.reflectMethod));
    }

    Expression getCode() {
        return Gen.wrapInLambda(new PrimProcedure(this.reflectMethod));
    }

    public void printInterface(PrintWriter w) {
        Internal.error("Automatic java methods should not be exported");
    }

    public void registerForDispatch() {
        if (this.registered) {
            return;
        }
        Dispatch.register(this);
        this.registered = true;
    }
}

