/*
 * Decompiled with CFR 0.152.
 */
package bossa.link;

import bossa.link.Alternative;
import bossa.link.Compilation;
import bossa.modules.Package;
import bossa.syntax.ClassDefinition;
import bossa.syntax.ConstantExp;
import bossa.syntax.JavaMethod;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.NiceClass;
import bossa.syntax.NiceMethod;
import bossa.syntax.Pattern;
import bossa.syntax.PrimitiveType;
import bossa.syntax.SuperExp;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.Constraint;
import mlsub.typing.Enumeration;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeLeqCst;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.lowlevel.Element;
import nice.tools.typing.Types;
import nice.tools.util.Chronometer;

public final class Dispatch {
    private static Collection methods;
    private static Collection javaMethods;
    private static Chronometer chrono;
    private static Comparator tagComp;

    private Dispatch() {
    }

    public static void register(NiceMethod m) {
        methods.add(m);
    }

    public static void register(JavaMethod m) {
        javaMethods.add(m);
    }

    public static void unregister(MethodDeclaration m) {
        javaMethods.remove(m);
    }

    public static void reset() {
        methods = new ArrayList();
        javaMethods = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(Package module) {
        chrono.start();
        try {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                Dispatch.test((NiceMethod)i.next(), module);
            }
            i = javaMethods.iterator();
            while (i.hasNext()) {
                Dispatch.test((JavaMethod)i.next(), module);
            }
        }
        finally {
            chrono.stop();
        }
    }

    private static void test(NiceMethod m, Package module) {
        Stack sortedAlternatives = Alternative.sortedAlternatives(m);
        if (!Dispatch.trivialTestOK(sortedAlternatives)) {
            Dispatch.test(m, sortedAlternatives, false);
        }
        if (Debug.codeGeneration) {
            Debug.println("Generating dispatch function for " + m);
        }
        Compilation.compile(m, sortedAlternatives, module);
    }

    private static void test(JavaMethod m, Package module) {
        Stack sortedAlternatives = Alternative.sortedAlternatives(m);
        if (!Dispatch.trivialTestJava(m, sortedAlternatives)) {
            Dispatch.test(m, sortedAlternatives, true);
        }
        if (Debug.codeGeneration) {
            Debug.println("Generating dispatch function for " + m);
        }
        Compilation.compile(m, sortedAlternatives, module);
    }

    private static boolean trivialTestOK(Stack alternatives) {
        if (alternatives.size() != 1) {
            return false;
        }
        Alternative a = (Alternative)alternatives.peek();
        for (int i = 0; i < a.patterns.length; ++i) {
            if (a.patterns[i].atAny()) continue;
            return false;
        }
        return true;
    }

    private static boolean trivialTestJava(JavaMethod m, Stack alternatives) {
        Method reflectMethod = m.reflectMethod;
        if (reflectMethod.getStaticFlag() || reflectMethod.isConstructor()) {
            return true;
        }
        if (!reflectMethod.isAbstract()) {
            return m.getArity() == 1 || alternatives.size() < 2;
        }
        return false;
    }

    private static boolean[] findUsedPositions(int len, Stack alternatives) {
        boolean[] res = new boolean[len * 2];
        Iterator it = alternatives.iterator();
        while (it.hasNext()) {
            Alternative a = (Alternative)it.next();
            if (len != a.patterns.length) {
                Internal.error("Expected number of patterns is " + len + ".\nThe incorrect alternative: " + a);
            }
            for (int i = 0; i < len; ++i) {
                if (a.patterns[i].atAny()) continue;
                res[2 * i + 1] = true;
                res[2 * i] = true;
            }
        }
        return res;
    }

    private static void test(MethodDeclaration method, Stack sortedAlternatives, boolean isJavaMethod) {
        if (Debug.linkTests) {
            Debug.println("\nLink test for " + method);
            Iterator i = sortedAlternatives.iterator();
            while (i.hasNext()) {
                Debug.println("Alternative: " + i.next().toString());
            }
        }
        boolean[] used = Dispatch.findUsedPositions(method.getArity(), sortedAlternatives);
        Polytype type = method.getType();
        if (type == null) {
            throw Internal.error(method + " is not in a proper state.");
        }
        List multitags = Dispatch.enumerate(type, used);
        boolean[] isValue = new boolean[method.getArity()];
        List values = Dispatch.generateValues(sortedAlternatives, isValue);
        boolean hasValues = values.size() > 0;
        ArrayList errors = new ArrayList(3);
        int nb_errors = 0;
        Iterator i = multitags.iterator();
        while (i.hasNext()) {
            TypeConstructor[] tags = (TypeConstructor[])i.next();
            ClassType firstArg = null;
            if (isJavaMethod && (firstArg = Dispatch.classTypeOfNiceClass(tags[0])) == null || !(Dispatch.test(method, tags, sortedAlternatives, firstArg, errors) ? ++nb_errors > 3 : hasValues && Dispatch.testValues(method, tags, values, isValue, sortedAlternatives, errors) && ++nb_errors > 0)) continue;
            break;
        }
        if (nb_errors > 0) {
            User.error((Located)method, "The implementation test failed for method " + method.toString() + ":\n" + Util.map("", "\n", "", errors));
        }
    }

    private static ClassType classTypeOfNiceClass(TypeConstructor tc) {
        ClassDefinition def = ClassDefinition.get(tc);
        if (def == null || !(def.getImplementation() instanceof NiceClass)) {
            return null;
        }
        return ((NiceClass)def.getImplementation()).getClassExp().getClassType();
    }

    private static boolean test(MethodDeclaration method, TypeConstructor[] tags, Stack sortedAlternatives, ClassType firstArg, List errors) {
        boolean failed = false;
        if (Debug.linkTests) {
            Debug.println(Util.map("Multitag: ", ", ", "", tags));
        }
        Alternative first = null;
        Iterator i = sortedAlternatives.iterator();
        while (i.hasNext() && !failed) {
            Alternative a = (Alternative)i.next();
            if (!a.matches(tags)) continue;
            if (first == null) {
                first = a;
                continue;
            }
            if (Alternative.less(first, a) || a.containsTypeMatchingValue()) continue;
            failed = true;
            errors.add("ambiguity for parameters of type " + Dispatch.toString(tags) + "\nboth\n" + first.printLocated() + "\nand\n" + a.printLocated() + "\nmatch.");
        }
        if (first == null) {
            Method superImplementation;
            if (firstArg != null && (superImplementation = SuperExp.getImplementationAbove((JavaMethod)method, firstArg)) != null && !superImplementation.isAbstract()) {
                return false;
            }
            failed = true;
            if (sortedAlternatives.size() == 0) {
                User.error((Located)method, "Method " + method + " is declared but never implemented:\n" + "no alternative matches " + Dispatch.toString(tags));
            } else {
                errors.add("no alternative matches " + Dispatch.toString(tags));
            }
        }
        return failed;
    }

    private static boolean testValues(MethodDeclaration method, TypeConstructor[] tags, List valueCombis, boolean[] isValue, Stack sortedAlternatives, List errors) {
        boolean failed = false;
        ArrayList<Alternative> sortedTypeMatches = new ArrayList<Alternative>();
        Iterator i = sortedAlternatives.iterator();
        while (i.hasNext()) {
            Alternative a = (Alternative)i.next();
            if (!a.matchesTypePart(tags, isValue)) continue;
            sortedTypeMatches.add(a);
        }
        Iterator valit = valueCombis.iterator();
        while (valit.hasNext()) {
            Alternative first = null;
            ConstantExp[] values = (ConstantExp[])valit.next();
            Iterator i2 = sortedTypeMatches.iterator();
            while (i2.hasNext()) {
                Alternative a = (Alternative)i2.next();
                if (!a.matchesValuePart(values, isValue)) continue;
                if (first == null) {
                    first = a;
                    continue;
                }
                if (Alternative.less(first, a)) continue;
                failed = true;
                errors.add("ambiguity for parameters of type/value " + Dispatch.toString(tags, values, isValue) + "\nboth\n" + first.printLocated() + "\nand\n" + a.printLocated() + "\nmatch.");
                break;
            }
            if (first != null) continue;
            failed = true;
            errors.add("no alternative matches " + Dispatch.toString(tags, values, isValue));
            break;
        }
        return failed;
    }

    private static String toString(TypeConstructor[] tags) {
        StringBuffer res = new StringBuffer();
        res.append('(');
        int n = 0;
        for (int i = 0; i < tags.length; ++i) {
            res.append(tags[n++]);
            if (i + 1 >= tags.length) continue;
            res.append(", ");
        }
        return res.append(')').toString();
    }

    private static String toString(TypeConstructor[] tags, ConstantExp[] values, boolean[] isValue) {
        StringBuffer res = new StringBuffer();
        res.append('(');
        int n = 0;
        for (int i = 0; i < tags.length; ++i) {
            if (isValue[n]) {
                res.append(values[n++]);
            } else {
                res.append(tags[n++]);
            }
            if (i + 1 >= tags.length) continue;
            res.append(", ");
        }
        return res.append(')').toString();
    }

    private static List enumerate(Polytype type, boolean[] used) {
        Monotype[] domains = type.domain();
        Constraint cst = type.getConstraint();
        int len = used.length;
        Element[] types = new Element[len];
        int i = domains.length;
        while (--i >= 0) {
            Monotype raw;
            TypeConstructor marker;
            Monotype arg = domains[i];
            if (arg instanceof MonotypeConstructor) {
                MonotypeConstructor mc = (MonotypeConstructor)arg;
                marker = mc.getTC();
                raw = Types.rawType(mc);
            } else {
                marker = new TypeConstructor(PrimitiveType.maybeTC.variance);
                MonotypeVar var = new MonotypeVar("dispatchType");
                raw = var;
                MonotypeConstructor t = MonotypeConstructor.apply(marker, raw);
                cst = Constraint.and(cst, marker, var, (AtomicConstraint)new MonotypeLeqCst(t, arg), (AtomicConstraint)new MonotypeLeqCst(arg, t));
            }
            types[--len] = raw;
            types[--len] = marker;
        }
        if (len != 0) {
            throw new Error();
        }
        List res = Enumeration.enumerate(cst, types, used);
        res = Dispatch.mergeNullCases(res, domains.length);
        return Dispatch.enumerateBooleans(res, domains.length);
    }

    private static List mergeNullCases(List tuples, int length) {
        LinkedList<TypeConstructor[]> res = new LinkedList<TypeConstructor[]>();
        TreeSet<TypeConstructor[]> tupleSet = new TreeSet<TypeConstructor[]>(tagComp);
        Iterator i = tuples.iterator();
        while (i.hasNext()) {
            TypeConstructor[] tags = Dispatch.flatten((TypeConstructor[])i.next(), length);
            if (!tupleSet.add(tags)) continue;
            res.add(tags);
        }
        return res;
    }

    private static TypeConstructor[] flatten(TypeConstructor[] tags, int length) {
        TypeConstructor[] res = new TypeConstructor[length];
        int i = length;
        while (--i >= 0) {
            if (tags[2 * i] == PrimitiveType.nullTC) {
                res[i] = PrimitiveType.nullTC;
                continue;
            }
            res[i] = tags[2 * i + 1];
        }
        return res;
    }

    private static List enumerateBooleans(List tags, int length) {
        if (tags.size() < 1) {
            return tags;
        }
        for (int pos = 0; pos < length; ++pos) {
            ArrayList<TypeConstructor[]> res = new ArrayList<TypeConstructor[]>();
            Iterator i = tags.iterator();
            while (i.hasNext()) {
                TypeConstructor[] tc = (TypeConstructor[])i.next();
                if (tc[pos] == PrimitiveType.boolTC) {
                    TypeConstructor[] tc2 = new TypeConstructor[tc.length];
                    System.arraycopy(tc, 0, tc2, 0, tc.length);
                    tc[pos] = PrimitiveType.trueBoolTC;
                    res.add(tc);
                    tc2[pos] = PrimitiveType.falseBoolTC;
                    res.add(tc2);
                    continue;
                }
                res.add(tc);
            }
            tags = res;
        }
        return tags;
    }

    private static List generateValues(List alternatives, boolean[] isValue) {
        ArrayList values = new ArrayList();
        if (alternatives.size() < 1) {
            return values;
        }
        int len = isValue.length;
        for (int pos = 0; pos < len; ++pos) {
            Pattern pat;
            ArrayList valuesAtPos = new ArrayList();
            Iterator i = alternatives.iterator();
            while (i.hasNext()) {
                pat = ((Alternative)i.next()).getPatterns()[pos];
                if (!pat.atNonBoolValue()) continue;
                isValue[pos] = true;
                if (pat.atEnum()) {
                    Iterator it = pat.getEnumValues().iterator();
                    while (it.hasNext()) {
                        valuesAtPos.add(it.next());
                    }
                    continue;
                }
                valuesAtPos.add(pat.atValue);
            }
            i = alternatives.iterator();
            while (i.hasNext()) {
                int j;
                long hi;
                long lo;
                pat = ((Alternative)i.next()).getPatterns()[pos];
                if (!pat.atIntCompare()) continue;
                isValue[pos] = true;
                long val = pat.atValue.longValue();
                if (pat.compareKind == 1 || pat.compareKind == 5) {
                    lo = val - 1L;
                    hi = val;
                } else {
                    lo = val;
                    hi = val + 1L;
                }
                block4: while (true) {
                    for (j = 0; j < valuesAtPos.size(); ++j) {
                        if (!(((ConstantExp)valuesAtPos.get((int)j)).value instanceof Number) || ((ConstantExp)valuesAtPos.get(j)).longValue() != lo) {
                            continue;
                        }
                        --lo;
                        continue block4;
                    }
                    break;
                }
                valuesAtPos.add(new ConstantExp(new Long(lo)));
                block6: while (true) {
                    for (j = 0; j < valuesAtPos.size(); ++j) {
                        if (!(((ConstantExp)valuesAtPos.get((int)j)).value instanceof Number) || ((ConstantExp)valuesAtPos.get(j)).longValue() != hi) {
                            continue;
                        }
                        ++hi;
                        continue block6;
                    }
                    break;
                }
                valuesAtPos.add(new ConstantExp(new Long(hi)));
            }
            int valueCount = valuesAtPos.size();
            if (valueCount <= 0) continue;
            ArrayList<ConstantExp[]> res = new ArrayList<ConstantExp[]>();
            if (values.size() == 0) {
                for (int i2 = 0; i2 < valueCount; ++i2) {
                    ConstantExp[] arr2 = new ConstantExp[len];
                    arr2[pos] = (ConstantExp)valuesAtPos.get(i2);
                    res.add(arr2);
                }
            } else {
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    ConstantExp[] arr = (ConstantExp[])it.next();
                    for (int i3 = 0; i3 < valueCount; ++i3) {
                        ConstantExp[] arr2 = new ConstantExp[len];
                        System.arraycopy(arr, 0, arr2, 0, len);
                        arr2[pos] = (ConstantExp)valuesAtPos.get(i3);
                        res.add(arr2);
                    }
                }
            }
            values = res;
        }
        return values;
    }

    static {
        chrono = Chronometer.make("Dispatch tests");
        tagComp = new TagComparator();
    }

    private static class TagComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            TypeConstructor[] tc1 = (TypeConstructor[])o1;
            TypeConstructor[] tc2 = (TypeConstructor[])o2;
            for (int i = 0; i < tc1.length; ++i) {
                int b;
                if (tc1[i] == null) {
                    if (tc2[i] == null) {
                        return 0;
                    }
                    return -1;
                }
                if (tc2[i] == null) {
                    return 1;
                }
                int a = tc1[i].getId();
                if (a < (b = tc2[i].getId())) {
                    return -1;
                }
                if (a <= b) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return false;
        }
    }
}

