/*
 * Decompiled with CFR 0.152.
 */
package bossa.link;

import bossa.syntax.ConstantExp;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Pattern;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Util;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import mlsub.typing.TypeConstructor;
import nice.tools.code.Gen;

public abstract class Alternative
implements Located {
    String methodName;
    Pattern[] patterns;
    private static HashMap alternatives;
    private int mark = 0;
    private static int currentVisitedMark;

    public Alternative(String methodName, Pattern[] patterns) {
        this.methodName = methodName;
        this.patterns = patterns;
    }

    public static boolean leq(Alternative a, Alternative b) {
        for (int i = 0; i < a.patterns.length; ++i) {
            if (a.patterns[i].leq(b.patterns[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean less(Alternative a, Alternative b) {
        boolean strictly = false;
        for (int i = 0; i < a.patterns.length; ++i) {
            if (!a.patterns[i].leq(b.patterns[i])) {
                return false;
            }
            if (b.patterns[i].leq(a.patterns[i])) continue;
            strictly = true;
        }
        return strictly;
    }

    boolean matches(TypeConstructor[] tags) {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (this.patterns[i].matches(tags[i])) continue;
            return false;
        }
        return true;
    }

    boolean matchesTypePart(TypeConstructor[] tags, boolean[] isValue) {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (isValue[i] || this.patterns[i].matches(tags[i])) continue;
            return false;
        }
        return true;
    }

    boolean matchesValuePart(ConstantExp[] values, boolean[] isValue) {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!isValue[i] || this.patterns[i].matchesValue(values[i])) continue;
            return false;
        }
        return true;
    }

    boolean containsTypeMatchingValue() {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].atTypeMatchingValue()) continue;
            return true;
        }
        return false;
    }

    public abstract Expression methodExp();

    Expression matchTest(Expression[] parameters, boolean skipFirst) {
        if (parameters.length != this.patterns.length) {
            Internal.error("Incorrect parameters " + Util.map("", ", ", "", parameters) + " for " + this);
        }
        Expression result = QuoteExp.trueExp;
        for (int index = 0; index < parameters.length; ++index) {
            result = Gen.shortCircuitAnd(result, this.patterns[index].matchTest(parameters[index], index == 0 && skipFirst));
        }
        return result;
    }

    public String toString() {
        return this.methodName + Util.map("(", ", ", ")", this.patterns);
    }

    String printLocated() {
        return this.toString();
    }

    public Pattern[] getPatterns() {
        return this.patterns;
    }

    public static void reset() {
        alternatives = new HashMap();
    }

    protected void add(String fullName) {
        ArrayList<Alternative> l = (ArrayList<Alternative>)alternatives.get(fullName);
        if (l == null) {
            l = new ArrayList<Alternative>();
            alternatives.put(fullName, l);
        }
        l.add(this);
    }

    protected void add(String[] fullNames) {
        for (int i = 0; i < fullNames.length; ++i) {
            this.add(fullNames[i]);
        }
    }

    public static Stack sortedAlternatives(MethodDeclaration m) {
        List list = (List)alternatives.get(m.getFullName());
        if (list == null) {
            return new Stack();
        }
        return Alternative.sort(list);
    }

    private static Stack sort(List alternatives) {
        Stack sortedAlternatives = new Stack();
        if (alternatives.size() == 0) {
            return sortedAlternatives;
        }
        int visited = ++currentVisitedMark;
        Iterator i = alternatives.iterator();
        while (i.hasNext()) {
            Alternative a = (Alternative)i.next();
            if (a.mark == visited) continue;
            Alternative.visit(a, alternatives, sortedAlternatives, visited);
        }
        return sortedAlternatives;
    }

    private static final void visit(Alternative a, List alternatives, Stack sortedAlternatives, int visited) {
        a.mark = visited;
        Iterator i = alternatives.iterator();
        while (i.hasNext()) {
            Alternative daughter = (Alternative)i.next();
            if (daughter.mark == visited || !Alternative.leq(daughter, a)) continue;
            Alternative.visit(daughter, alternatives, sortedAlternatives, visited);
        }
        sortedAlternatives.push(a);
    }

    static {
        currentVisitedMark = 0;
    }
}

