/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import nice.tools.testsuite.TestNice;
import nice.tools.testsuite.TestSuiteException;

public class NiceSourceFile {
    public static final int STATUS_MAIN = 0;
    public static final int STATUS_TOPLEVEL = 1;
    private int _status = 0;
    public static final String DEFAULT_PACKAGE = "defaultpackage";
    private String _package = "defaultpackage" + TestNice.getFileCounter();
    private StringBuffer _mainMethodContent = new StringBuffer();
    private int _topLevelSectionLength = 0;
    private int _mainSectionLength = 0;
    private StringBuffer _topLevelContent = new StringBuffer();
    private Set _imports = new HashSet();

    public void setStatus(int status) {
        this._status = status;
    }

    public int getStatus() {
        return this._status;
    }

    public void consumeLine(String line) {
        switch (this._status) {
            case 0: {
                this.addToMainMethod(line);
                break;
            }
            case 1: {
                this.addToTopLevel(line);
            }
        }
    }

    public void addImportGlobal() {
        this._imports.add("global");
    }

    public void addToMainMethod(String line) {
        this._mainMethodContent.append(line).append('\n');
        ++this._mainSectionLength;
    }

    public void addToTopLevel(String line) {
        this._topLevelContent.append(line).append('\n');
        ++this._topLevelSectionLength;
    }

    public int getTopLevelSectionLength() {
        return this._topLevelSectionLength;
    }

    public int getMainSectionLength() {
        return this._mainSectionLength;
    }

    public void consumePackageKeyword(String keywordStatement) throws TestSuiteException {
        int spacePos;
        int dontCompilePos = keywordStatement.indexOf("dontcompile");
        if (dontCompilePos != -1) {
            keywordStatement = keywordStatement.substring(0, dontCompilePos) + keywordStatement.substring(dontCompilePos + "dontcompile".length());
        }
        if ((spacePos = (keywordStatement = keywordStatement.substring("package".length()).trim()).indexOf(" ")) == -1) {
            this.setPackage(keywordStatement);
            return;
        }
        this.setPackage(keywordStatement.substring(0, spacePos));
        int importStartPos = keywordStatement.indexOf("import", spacePos);
        if (importStartPos == -1) {
            throw new TestSuiteException("unknown keyword statement: " + keywordStatement);
        }
        keywordStatement = keywordStatement.substring(importStartPos + "import".length()).trim();
        StringTokenizer tokenizer = new StringTokenizer(keywordStatement, " ,;+");
        while (tokenizer.hasMoreTokens()) {
            this._imports.add(tokenizer.nextToken());
        }
    }

    public void setPackage(String packageName) {
        this._package = packageName;
    }

    public String getPackage() {
        return this._package;
    }

    public String getFileName() {
        return this._package + "_main.nice";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write() throws TestSuiteException {
        if (this.isEmpty()) {
            return;
        }
        File packageFolder = new File(TestNice.getTempFolder(), this._package.replace('.', File.separatorChar));
        if (!packageFolder.exists() && !packageFolder.mkdirs()) {
            throw new TestSuiteException("could not create folder: " + packageFolder);
        }
        File sourceFile = new File(packageFolder, this.getFileName());
        BufferedWriter writer = null;
        try {
            try {
                StringWriter debugWriter = new StringWriter();
                writer = new BufferedWriter(debugWriter);
                this.write(writer);
                writer.close();
                writer = new BufferedWriter(new FileWriter(sourceFile));
                writer.write(debugWriter.toString());
            }
            catch (IOException e) {
                throw new TestSuiteException("Exception while writing file: " + sourceFile, e);
            }
            Object var6_6 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new TestSuiteException("Could not close file: " + sourceFile, e);
            }
        }
        try {}
        catch (IOException e) {
            throw new TestSuiteException("Could not close file: " + sourceFile, e);
        }
        writer.close();
    }

    void write(BufferedWriter writer) throws IOException {
        this.writePackage(writer);
        this.writeImports(writer);
        this.writeTopLevel(writer);
        this.writeMainMethod(writer);
    }

    private void writePackage(BufferedWriter writer) throws IOException {
        writer.write("package ");
        writer.write(this._package);
        writer.write(";");
        writer.newLine();
        writer.newLine();
    }

    private void writeImports(BufferedWriter writer) throws IOException {
        Iterator iter = this._imports.iterator();
        while (iter.hasNext()) {
            writer.write("import ");
            writer.write((String)iter.next());
            writer.write(";");
            writer.newLine();
        }
    }

    private void writeMainMethod(BufferedWriter writer) throws IOException {
        if (!this.hasMainMethod()) {
            return;
        }
        writer.write("// main method");
        writer.newLine();
        writer.write("void main(java.lang.String[] args) {\n");
        writer.write(this._mainMethodContent.toString());
        writer.write("}\n");
    }

    private void writeTopLevel(BufferedWriter writer) throws IOException {
        writer.write("// Top level code");
        writer.newLine();
        writer.write(this._topLevelContent.toString());
    }

    public boolean hasMainMethod() {
        return true;
    }

    public boolean isEmpty() {
        return this._mainMethodContent.length() == 0 && this._topLevelContent.length() == 0;
    }

    int getCountImports() {
        return this._imports.size();
    }
}

