/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.ArrayType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.ProcedureN;

public class MultiArrayNewProc
extends ProcedureN
implements Inlineable {
    private ArrayType arrayType;
    private int nbDimensions;

    public MultiArrayNewProc(ArrayType arrayType, int nbDimensions) {
        this.arrayType = arrayType;
        this.nbDimensions = nbDimensions;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        int i = 0;
        while (i < this.nbDimensions) {
            args[i].compile(comp, Type.int_type);
            ++i;
        }
        this.arrayType = MultiArrayNewProc.creationType(this.arrayType, target);
        comp.getCode().emitNewArray(this.arrayType.getComponentType(), this.nbDimensions);
        target.compileFromStack(comp, this.arrayType);
    }

    static ArrayType creationType(ArrayType computedType, Target target) {
        ArrayType targetType;
        if (target.getType() instanceof ArrayType && MultiArrayNewProc.hasPrimitiveComponents(targetType = (ArrayType)target.getType())) {
            return targetType;
        }
        return computedType;
    }

    private static boolean hasPrimitiveComponents(ArrayType array) {
        Type componentType = array.getComponentType();
        return componentType instanceof ArrayType || componentType instanceof PrimType;
    }

    public Type getReturnType(Expression[] args) {
        return this.arrayType;
    }

    public Object applyN(Object[] args) {
        throw new Error("Not implemented");
    }
}

