/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.ProcedureN;
import nice.tools.code.MultiArrayNewProc;
import nice.tools.code.SpecialArray;
import nice.tools.code.SpecialTypes;
import nice.tools.code.Types;

public class LiteralArrayProc
extends ProcedureN
implements Inlineable {
    private ArrayType arrayType;
    private int nbElements;
    private boolean wrapAsCollection;

    public LiteralArrayProc(ArrayType arrayType, int nbElements, boolean wrapAsCollection) {
        this.arrayType = arrayType;
        this.nbElements = nbElements;
        this.wrapAsCollection = wrapAsCollection;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        this.arrayType = MultiArrayNewProc.creationType(this.arrayType, target);
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        Type componentType = this.getComponentType(args);
        code.emitPushInt(this.nbElements);
        code.emitNewArray(componentType);
        code.popType();
        code.pushType(SpecialTypes.array(componentType));
        if (this.nbElements > 0) {
            code.emitDup();
        }
        int i = 0;
        while (i < this.nbElements) {
            Type specificType;
            if (i % 2 == 0) {
                if (i < this.nbElements - 2) {
                    code.emitDup(2);
                } else if (i == this.nbElements - 2) {
                    code.emitDup();
                }
            }
            if (!(specificType = Types.componentType(this.arrayType, i)).isAssignableTo(componentType)) {
                specificType = componentType;
            }
            code.emitPushInt(i);
            args[i].compile(comp, specificType);
            code.emitArrayStore(componentType);
            ++i;
        }
        if (this.wrapAsCollection) {
            SpecialArray.emitCoerceToCollection(code);
        } else {
            target.compileFromStack(comp, code.topType());
        }
    }

    private Type getComponentType(Expression[] args) {
        Type type = Types.lowestUpperBound(args);
        if (type.isSubtype(this.arrayType.getComponentType())) {
            type = this.arrayType.getComponentType();
        }
        if (type == Type.nullType) {
            type = Type.pointer_type;
        }
        return type;
    }

    public Type getReturnType(Expression[] args) {
        if (this.wrapAsCollection) {
            return ClassType.make("java.util.List");
        }
        return SpecialTypes.array(this.getComponentType(args));
    }

    public Object applyN(Object[] args) {
        throw new Error("Not implemented");
    }
}

