/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure1;
import java.lang.reflect.Field;

public class GetFieldProc
extends Procedure1
implements Inlineable {
    private Declaration fieldDecl;

    public GetFieldProc(Declaration fieldDecl) {
        this.fieldDecl = fieldDecl;
        if (fieldDecl == null) {
            throw new NullPointerException();
        }
    }

    gnu.bytecode.Field getField() {
        return this.fieldDecl.field;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        gnu.bytecode.Field field = this.fieldDecl.field;
        boolean isStatic = field.getStaticFlag();
        CodeAttr code = comp.getCode();
        if (!isStatic) {
            ClassType ctype = field.getDeclaringClass();
            exp.getArgs()[0].compile(comp, ctype);
            code.emitGetField(field);
        } else {
            code.emitGetStatic(field);
        }
        target.compileFromStack(comp, field.getType());
    }

    public Type getReturnType(Expression[] args) {
        return this.fieldDecl.getType();
    }

    public Object apply1(Object arg1) {
        gnu.bytecode.Field field = this.fieldDecl.field;
        try {
            Field reflectField = field.getReflectField();
            return reflectField.get(arg1);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("no such field " + field.getSourceName() + " in " + field.getDeclaringClass());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("illegal access for field " + field.getSourceName());
        }
    }
}

